/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.nica.util;

import com.googlecode.jinahya.nica.util.Per;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ParME {
    private static void exchange(String[] a, int i, int j) {
        String t = a[i];
        a[i] = a[j];
        a[j] = t;
    }

    private static void sort(String[] keys, String[] values, int low, int high) {
        if (keys.length < 2) {
            return;
        }
        int i = low;
        int j = high;
        String p = keys[low + (high - low) / 2];
        while (i <= j) {
            while (keys[i].compareTo(p) < 0) {
                ++i;
            }
            while (keys[j].compareTo(p) > 0) {
                --j;
            }
            if (i > j) continue;
            ParME.exchange(keys, i, j);
            if (values != null) {
                ParME.exchange(values, i, j);
            }
            ++i;
            --j;
        }
        if (low < j) {
            ParME.sort(keys, values, low, j);
        }
        if (i < high) {
            ParME.sort(keys, values, i, high);
        }
    }

    private String[] split_string(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(original.substring(0, index));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            for (int loop = 0; loop < nodes.size(); ++loop) {
                result[loop] = (String)nodes.elementAt(loop);
                System.out.println(result[loop]);
            }
        }
        return result;
    }

    private static Vector split(String joined, String delimiter, Vector split) {
        if (delimiter == null) {
            throw new IllegalArgumentException("null delimiter");
        }
        if (delimiter.length() == 0) {
            throw new IllegalArgumentException("delimiter.length(" + delimiter.length() + ") == 0");
        }
        int f = 0;
        int i = -1;
        while ((i = joined.indexOf(delimiter, f)) != -1) {
            split.add(joined.substring(f, i));
            f = i + delimiter.length();
        }
        split.add(joined.substring(f));
        return split;
    }

    private static Vector split(String joined, String delimiter) {
        return ParME.split(joined, delimiter, new Vector());
    }

    protected static String encode(Hashtable decoded, StringBuffer buffer) {
        if (decoded == null) {
            throw new IllegalArgumentException("null decoded");
        }
        if (decoded.isEmpty()) {
            throw new IllegalArgumentException("empty decoded");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("null buffer");
        }
        String[] normalizedKeys = new String[decoded.size()];
        String[] normalizedValues = new String[decoded.size()];
        Enumeration keys = decoded.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key == null) {
                throw new IllegalArgumentException("null key");
            }
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("key(" + key + ") is not an instance of " + String.class);
            }
            normalizedKeys[i] = Per.encodeToString((String)key);
            Object value = decoded.get(key);
            if (value == null) {
                throw new IllegalArgumentException("null value");
            }
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("value(" + value + ") is not an instance of " + String.class);
            }
            normalizedValues[i] = Per.encodeToString((String)value);
            ++i;
        }
        ParME.sort(normalizedKeys, normalizedValues, 0, normalizedKeys.length - 1);
        if (normalizedKeys.length > 0) {
            buffer.append(normalizedKeys[0]).append('=').append(normalizedValues[0]);
        }
        for (i = 1; i < normalizedKeys.length; ++i) {
            buffer.append('&').append(normalizedKeys[i]).append('=').append(normalizedValues[i]);
        }
        return buffer.toString();
    }

    public static String encode(Hashtable decoded) {
        return ParME.encode(decoded, new StringBuffer());
    }

    protected static String encodeMultivalued(Hashtable decoded, StringBuffer buffer) {
        if (decoded == null) {
            throw new IllegalArgumentException("null decoded");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("null buffer");
        }
        Hashtable singleValued = new Hashtable(decoded.size());
        Enumeration keys = decoded.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object values = decoded.get(key);
            if (values == null) {
                throw new IllegalArgumentException("null values");
            }
            if (!(values instanceof Vector)) {
                throw new IllegalArgumentException("values(" + values + ") is not an instance of " + Vector.class);
            }
            buffer.delete(0, buffer.length());
            singleValued.put(key, ParME.encodeValues((Vector)values, buffer));
            ++i;
        }
        buffer.delete(0, buffer.length());
        return ParME.encode(singleValued, buffer);
    }

    public static String encodeMultivalued(Hashtable decoded) {
        return ParME.encodeMultivalued(decoded, new StringBuffer());
    }

    protected static String encodeValues(Vector values, StringBuffer buffer) {
        if (values == null) {
            throw new IllegalArgumentException("null values");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException("empty values");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("null buffer");
        }
        String[] normalizedValues = new String[values.size()];
        Enumeration elements = values.elements();
        int i = 0;
        while (elements.hasMoreElements()) {
            Object value = elements.nextElement();
            if (value == null) {
                throw new IllegalArgumentException("null value");
            }
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("value(" + value + ") is not an instance of " + String.class);
            }
            normalizedValues[i] = Per.encodeToString((String)value);
            ++i;
        }
        ParME.sort(normalizedValues, null, 0, normalizedValues.length - 1);
        if (normalizedValues.length > 0) {
            buffer.append(normalizedValues[0]);
        }
        for (i = 1; i < normalizedValues.length; ++i) {
            buffer.append('&').append(normalizedValues[i]);
        }
        return buffer.toString();
    }

    public static String encodeValues(Vector values) {
        return ParME.encodeValues(values, new StringBuffer());
    }

    public static Hashtable decode(String encoded, Hashtable decoded) {
        if (encoded == null) {
            throw new IllegalArgumentException("null encoded");
        }
        if (decoded == null) {
            throw new IllegalArgumentException("null decoded");
        }
        Enumeration pairs = ParME.split(encoded, "&").elements();
        while (pairs.hasMoreElements()) {
            String value;
            String pair = (String)pairs.nextElement();
            int index = pair.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("illegal encoded");
            }
            String key = Per.decodeToString(pair.substring(0, index));
            if (decoded.put(key, value = Per.decodeToString(pair.substring(index + 1))) == null) continue;
            throw new IllegalArgumentException("illegal encoded: duplicate key: " + key);
        }
        return decoded;
    }

    public static Hashtable decode(String encoded) {
        return ParME.decode(encoded, new Hashtable());
    }

    protected static Hashtable decodeMultivalued(String encoded, Hashtable decoded) {
        if (encoded == null) {
            throw new IllegalArgumentException("null encoded");
        }
        if (decoded == null) {
            throw new IllegalArgumentException("null decoded");
        }
        Hashtable singleValued = ParME.decode(encoded);
        Enumeration k = singleValued.keys();
        while (k.hasMoreElements()) {
            Object key = k.nextElement();
            decoded.put(key, ParME.decodeValues((String)singleValued.get(key)));
        }
        return decoded;
    }

    public static Hashtable decodeMultivalued(String encoded) {
        return ParME.decodeMultivalued(encoded, new Hashtable());
    }

    protected static Vector decodeValues(String encoded, Vector values) {
        if (encoded == null) {
            throw new IllegalArgumentException("null encoded");
        }
        if (values == null) {
            throw new IllegalArgumentException("null values");
        }
        Enumeration e = ParME.split(encoded, "&", new Vector()).elements();
        while (e.hasMoreElements()) {
            values.add(Per.decodeToString((String)e.nextElement()));
        }
        return values;
    }

    public static Vector decodeValues(String encoded) {
        return ParME.decodeValues(encoded, new Vector());
    }

    protected ParME() {
    }
}

