

package org.ocap.hn;


/**
 * Represents a Device Event. There are two types of Device events:
 * one that is generated by the NetManager when a Device is added or removed
 * from the home network. Application may register as a listener to NetManager
 * to receive such events. The other DeviceEvent is generated by the 
 * Device itself when its internal state changes. Application should register
 * as a listener with a particular Device for such events. In both scenarios, 
 * the Device that was the source of the event is returned.
 */
public class DeviceEvent extends java.util.EventObject {
    /**
     * A constant indicating new device is registered to home network.
     */
    public static final int DEVICE_ADDED = 100;

    /**
     * A constant indicating a device is removed from home network.
     */
    public static final int DEVICE_REMOVED = 101;

    /**
     * A constant indicating a device is updated from home network.
     */
    public static final int DEVICE_UPDATED = 102;

    /**
     * A constant indicating a device's internal state has changed.
     */
    public static final int STATE_CHANGE = 201;



    /**
     * Constructs a DeviceEvent by specifying type and source.
     * 
     * @param type
     *            Device change type, allowed type are defined in
     *            <code>DeviceEvent</code>
     * @param source
     *            Device where the change happens.
     */
    public DeviceEvent(int type, Object source) {
        super(source);

    }

    /**
     * Returns device event type, as defined in <code>DeviceEvent</code>.
     * 
     * @return device event type
     */
    public int getType() {
    	return 0;
    }

    /**
     * Returns device event source, which is always a Device.
     * 
     * @return device event source
     */
    public Object getSource() {
    	return null;
    }
}