/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.rfc3986;

import com.googlecode.jinahya.rfc3986.PercentCodecException;
import com.googlecode.jinahya.rfc3986.PercentEncoder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class PercentBinaryEncoderProxy
implements InvocationHandler {
    private static final Class<?> BINARY_ENCODER_CLASS;

    public static Object newInstance() {
        return Proxy.newProxyInstance(BINARY_ENCODER_CLASS.getClassLoader(), new Class[]{BINARY_ENCODER_CLASS}, (InvocationHandler)new PercentBinaryEncoderProxy());
    }

    protected PercentBinaryEncoderProxy() {
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args[0] == null) {
            throw new NullPointerException("null source");
        }
        if (args[0] instanceof String) {
            try {
                return PercentEncoder.encode((String)args[0]);
            }
            catch (PercentCodecException pce) {
                throw (Throwable)Class.forName("org.apache.commons.codec.EncoderException").getConstructor(Throwable.class).newInstance(pce);
            }
        }
        if (args[0] instanceof byte[]) {
            try {
                return PercentEncoder.encode((byte[])args[0]);
            }
            catch (PercentCodecException pce) {
                throw (Throwable)Class.forName("org.apache.commons.codec.EncoderException").getConstructor(Throwable.class).newInstance(pce);
            }
        }
        throw new IllegalArgumentException("unacceptable source type: " + args[0].getClass());
    }

    static {
        try {
            BINARY_ENCODER_CLASS = Class.forName("org.apache.commons.codec.BinaryEncoder");
        }
        catch (ClassNotFoundException cnfe) {
            throw new InstantiationError(cnfe.getMessage());
        }
    }
}

