/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.rfc3986;

import com.googlecode.jinahya.rfc3986.PercentDecoder;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class PercentBinaryDecoderProxy
implements InvocationHandler {
    private static final Class<?> BINARY_ENCODER_CLASS;

    public static Object newInstance() {
        return Proxy.newProxyInstance(BINARY_ENCODER_CLASS.getClassLoader(), new Class[]{BINARY_ENCODER_CLASS}, (InvocationHandler)new PercentBinaryDecoderProxy());
    }

    protected PercentBinaryDecoderProxy() {
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args[0] == null) {
            throw new NullPointerException("null source");
        }
        if (args[0] instanceof String) {
            try {
                return PercentDecoder.decode((String)args[0]);
            }
            catch (IOException ioe) {
                throw (Throwable)Class.forName("org.apache.commons.codec.DecoderException").getConstructor(Throwable.class).newInstance(ioe);
            }
        }
        if (args[0] instanceof byte[]) {
            try {
                return PercentDecoder.decode((byte[])args[0]);
            }
            catch (IOException ioe) {
                throw (Throwable)Class.forName("org.apache.commons.codec.DecoderException").getConstructor(Throwable.class).newInstance(ioe);
            }
        }
        throw new IllegalArgumentException("unacceptable source type: " + args[0].getClass());
    }

    static {
        try {
            BINARY_ENCODER_CLASS = Class.forName("org.apache.commons.codec.BinaryDecoder");
        }
        catch (ClassNotFoundException cnfe) {
            throw new InstantiationError(cnfe.getMessage());
        }
    }
}

