/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.rfc3986;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class PercentDecoder {
    public static byte[] decode(String input) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        return PercentDecoder.decode(input.getBytes("US-ASCII"));
    }

    public static byte[] decode(byte[] input) throws IOException {
        if (input == null) {
            throw new NullPointerException("null bytes");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PercentDecoder.decode(new ByteArrayInputStream(input), (OutputStream)output);
        output.flush();
        return output.toByteArray();
    }

    public static void decode(InputStream input, OutputStream output) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        if (output == null) {
            throw new NullPointerException("null output");
        }
        int b = -1;
        while ((b = input.read()) != -1) {
            if (b >= 48 && b <= 57 || b >= 65 && b <= 90 || b >= 97 && b <= 122 || b == 45 || b == 95 || b == 46 || b == 126) {
                output.write(b);
                continue;
            }
            if (b == 37) {
                int high = input.read();
                if (high == -1) {
                    throw new EOFException("eof");
                }
                int row = input.read();
                if (row == -1) {
                    throw new EOFException("eof");
                }
                output.write(PercentDecoder.atoi(high) << 4 | PercentDecoder.atoi(row));
                continue;
            }
            throw new IOException("illegal octet: " + b);
        }
    }

    public static void decode(Reader input, OutputStream output) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        if (output == null) {
            throw new NullPointerException("null output");
        }
        char[] hex = new char[2];
        int c = -1;
        while ((c = input.read()) != -1) {
            if (c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 45 || c == 95 || c == 46 || c == 126) {
                output.write(c);
                continue;
            }
            if (c == 37) {
                hex[0] = (char)input.read();
                if (hex[0] == '\uffffffff') {
                    throw new EOFException("eof");
                }
                hex[1] = (char)input.read();
                if (hex[1] == '\uffffffff') {
                    throw new EOFException("eof");
                }
                output.write(Integer.parseInt(new String(hex), 16));
                continue;
            }
            throw new IOException("illegal octet: " + c);
        }
    }

    private static int atoi(int ascii) throws IOException {
        if (ascii < 48) {
            throw new IOException("wrong ascii: " + ascii);
        }
        if (ascii <= 57) {
            return ascii - 48;
        }
        if (ascii <= 64) {
            throw new IOException("wrong ascii: " + ascii);
        }
        if (ascii <= 70) {
            return ascii - 55;
        }
        if (ascii <= 96) {
            throw new IOException("wrong ascii: " + ascii);
        }
        if (ascii <= 102) {
            return ascii - 87;
        }
        throw new IOException("wrong ascii: " + ascii);
    }

    protected PercentDecoder() {
    }
}

