/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.util.rfc3986;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;

public class PercentEncoder {
    public static byte[] encode(String input) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        return PercentEncoder.encode(input.getBytes("UTF-8"));
    }

    public static byte[] encode(byte[] input) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PercentEncoder.encode((InputStream)new ByteArrayInputStream(input), output);
        output.flush();
        return output.toByteArray();
    }

    public static void encode(InputStream input, OutputStream output) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (output == null) {
            throw new IllegalArgumentException("null output");
        }
        int b = -1;
        while ((b = input.read()) != -1) {
            if (b >= 48 && b <= 57 || b >= 65 && b <= 90 || b >= 97 && b <= 122 || b == 45 || b == 95 || b == 46 || b == 126) {
                output.write(b);
                continue;
            }
            output.write(37);
            output.write(PercentEncoder.itoa(b >> 4));
            output.write(PercentEncoder.itoa(b & 0xF));
        }
    }

    public static void encode(InputStream input, Writer output) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (output == null) {
            throw new IllegalArgumentException("null output");
        }
        int b = -1;
        while ((b = input.read()) != -1) {
            if (b >= 48 && b <= 57 || b >= 65 && b <= 90 || b >= 97 && b <= 122 || b == 45 || b == 95 || b == 46 || b == 126) {
                output.write(b);
                continue;
            }
            output.write(37);
            if (b <= 15) {
                output.write(48);
            }
            output.write(Integer.toHexString(b).toUpperCase());
        }
    }

    private static int itoa(int integer) throws IOException {
        if (integer < 0) {
            throw new IOException("wrong integer: " + integer);
        }
        if (integer <= 9) {
            return integer + 48;
        }
        if (integer <= 15) {
            return integer + 55;
        }
        throw new IOException("wrong integer: " + integer);
    }

    protected PercentEncoder() {
    }
}

