/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.rfc4648;

import com.googlecode.jinahya.io.BitInput;
import com.googlecode.jinahya.io.BitOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public abstract class Base {
    static final char PAD = '=';
    private static final int OCTET_SIZE = 8;
    private static final int ASCII_SIZE = 128;
    private static final int SMALLEST_VISIBLE_ASCII = 33;
    private final byte[] encode;
    private final byte[] decode;
    private final boolean padding;
    private final int bitsPerChar;
    private final int bytesPerWord;
    private final int charsPerWord;

    private static int lcm(int a, int b) {
        return a * b / Base.gcd(a, b);
    }

    private static int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return Base.gcd(b, a % b);
    }

    protected Base(byte[] alphabet, boolean padding) {
        int i;
        if (alphabet == null) {
            throw new NullPointerException("null alphabet");
        }
        if (alphabet.length == 0) {
            throw new IllegalArgumentException("empty alphabet");
        }
        this.encode = alphabet;
        this.decode = new byte[96];
        for (i = 0; i < this.decode.length; ++i) {
            this.decode[i] = -1;
        }
        for (i = 0; i < this.encode.length; i = (int)((byte)(i + 1))) {
            this.decode[this.encode[i] - 33] = i;
        }
        this.padding = padding;
        this.bitsPerChar = (int)(Math.log(this.encode.length) / Math.log(2.0));
        this.bytesPerWord = Base.lcm(8, this.bitsPerChar) / 8;
        this.charsPerWord = this.bytesPerWord * 8 / this.bitsPerChar;
    }

    public byte[] encode(byte[] input) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        return this.encode(new ByteArrayInputStream(input));
    }

    public byte[] encode(InputStream input) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.encode(input, output);
        output.flush();
        return output.toByteArray();
    }

    public final void encode(InputStream input, OutputStream output) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        if (output == null) {
            throw new NullPointerException("null output");
        }
        OutputStreamWriter writer = new OutputStreamWriter(output, "US-ASCII");
        this.encode(input, (Writer)writer);
        ((Writer)writer).flush();
    }

    public final void encode(InputStream input, Writer output) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        if (output == null) {
            throw new NullPointerException("null output");
        }
        this.encode(new BitInput(input), output);
    }

    private void encode(BitInput input, Writer output) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (output == null) {
            throw new IllegalArgumentException("null output");
        }
        block4: while (true) {
            int i = 0;
            while (true) {
                if (i >= this.charsPerWord) continue block4;
                int available = 8 - this.bitsPerChar * i % 8;
                if (available >= this.bitsPerChar) {
                    try {
                        int unsigned = input.readUnsignedInt(this.bitsPerChar);
                        output.write(this.encode[unsigned]);
                    }
                    catch (EOFException eofe) {
                        break block4;
                    }
                }
                int required = this.bitsPerChar - available;
                int unsigned = input.readUnsignedInt(available) << required;
                try {
                    output.write(this.encode[unsigned |= input.readUnsignedInt(required)]);
                }
                catch (EOFException eofe) {
                    output.write(this.encode[unsigned]);
                    if (!this.padding) break block4;
                    for (int j = i + 1; j < this.charsPerWord; ++j) {
                        output.write(61);
                    }
                    break block4;
                }
                ++i;
            }
            break;
        }
    }

    public final byte[] decode(byte[] input) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        return this.decode(new ByteArrayInputStream(input));
    }

    public final byte[] decode(InputStream input) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.decode(input, (OutputStream)output);
        output.flush();
        return output.toByteArray();
    }

    public final void decode(InputStream input, OutputStream output) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        if (output == null) {
            throw new NullPointerException("null outpute");
        }
        InputStreamReader reader = new InputStreamReader(input, "US-ASCII");
        this.decode((Reader)reader, output);
    }

    public final void decode(Reader input, OutputStream output) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        if (output == null) {
            throw new NullPointerException("null outpute");
        }
        this.decode(input, new BitOutput(output));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void decode(Reader input, BitOutput output) throws IOException {
        int j;
        int c;
        block0: while (true) {
            int i = 0;
            while (true) {
                if (i >= this.charsPerWord) continue block0;
                c = input.read();
                if (c == -1) {
                    if (i == 0) {
                        return;
                    }
                    if (i * this.bitsPerChar % 8 >= this.bitsPerChar) {
                        throw new EOFException("not finished properly");
                    }
                    if (this.padding) throw new EOFException("not finished properly");
                    return;
                }
                if (c == 61) {
                    if (!this.padding) {
                        throw new IOException("bad padding; no pads allowed");
                    }
                    if (i == 0) {
                        throw new IOException("bad padding");
                    }
                    if (i * this.bitsPerChar % 8 >= this.bitsPerChar) {
                        throw new IOException("bad padding");
                    }
                    j = i + 1;
                    break block0;
                }
                byte value = this.decode[c - 33];
                if (value == -1) {
                    throw new IOException("bad character: " + (char)c);
                }
                output.writeUnsignedInt(this.bitsPerChar, (int)value);
                ++i;
            }
            break;
        }
        while (j < this.charsPerWord) {
            c = input.read();
            if (c == -1) {
                throw new EOFException("not finished properly");
            }
            if (c != 61) {
                throw new IOException("bad padding");
            }
            ++j;
        }
    }
}

