/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.ucloud.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleHandler
extends DefaultHandler {
    private static final SAXParserFactory PARSER_FACTORY = SAXParserFactory.newInstance();
    private final String parentQName;
    private final Collection<Map<String, String>> results;
    private transient Map<String, String> result;
    private transient String childQName;
    private final transient StringBuilder builder = new StringBuilder();

    public static Collection<Map<String, String>> parse(InputStream input, String parentQName) throws ParserConfigurationException, SAXException, IOException {
        SimpleHandler handler = new SimpleHandler(parentQName);
        SAXParser parser = PARSER_FACTORY.newSAXParser();
        parser.parse(input, (DefaultHandler)handler);
        return handler.getResults();
    }

    public SimpleHandler(String parentQName) {
        this(parentQName, new ArrayList<Map<String, String>>());
    }

    public SimpleHandler(String parentQName, Collection<Map<String, String>> results) {
        if (parentQName == null) {
            throw new IllegalArgumentException("null parentQName");
        }
        if (results == null) {
            throw new IllegalArgumentException("null results");
        }
        this.parentQName = parentQName;
        this.results = results;
    }

    public String getParentQName() {
        return this.parentQName;
    }

    public Collection<Map<String, String>> getResults() {
        return this.results;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.childQName != null) {
            this.builder.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.parentQName.equals(qName)) {
            this.results.add(this.result);
            this.result = null;
        } else if (this.childQName != null) {
            this.result.put(this.childQName, this.builder.toString());
            this.childQName = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.parentQName.equals(qName)) {
            this.result = new HashMap<String, String>();
        } else if (this.result != null) {
            this.childQName = qName;
            this.builder.delete(0, this.builder.length());
        }
    }
}

