/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jinahya.ucloud.storage;

import com.googlecode.jinahya.ucloud.storage.ContentConsumer;
import com.googlecode.jinahya.ucloud.storage.ContentProducer;
import com.googlecode.jinahya.ucloud.storage.StorageAccount;
import com.googlecode.jinahya.ucloud.storage.StorageContainer;
import com.googlecode.jinahya.ucloud.storage.StorageObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcloudStorageClient {
    private static final String AUTH_URL = "https://api.ucloudbiz.olleh.com/storage/v1/auth";
    static final String UNKNOWN_CONTENT_TYPE = "application/octet-stream";
    static final long UNKNOWN_CONTENT_LENGTH = -1L;
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final Logger LOGGER = LoggerFactory.getLogger(UcloudStorageClient.class);
    private static final int RESPONSE_CODE_200_OK = 200;
    private static final int RESPONSE_CODE_201_CREATED = 201;
    private static final int RESPONSE_CODE_202_ACCEPTED = 202;
    private static final int RESPONSE_CODE_204_NO_CONTENT = 204;
    private static final int RESPONSE_CODE_403_FORBIDDEN = 403;
    private static final int RESPONSE_CODE_404_NOT_FOUND = 404;
    private static final int CHUNK_LENGTH = 4096;
    private static final int BUFFER_LENGTH = 4096;
    private static final String PATH_SEPARATOR = "/";
    private static final int MAXIMUM_ENCODED_CONTAINER_NAME_LENGTH = 256;
    private static final int MAXIMUM_ENCODED_OBJECT_NAME_LENGTH = 1024;
    private final String storageUser;
    private final String storagePass;
    private transient String storageUrl;
    private transient String authToken;
    private transient Integer connectTimeout;
    private transient Integer readTimeout;
    private transient int responseCode;
    private transient String responseMessage;
    private transient Map<String, List<String>> headerFields;

    private static long getContentLength(URLConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        long contentLength = connection.getContentLength();
        try {
            contentLength = (Long)URLConnection.class.getMethod("getContentLengthLong", new Class[0]).invoke((Object)connection, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return contentLength;
    }

    private static String utf8(Object string) {
        try {
            return URLEncoder.encode(String.valueOf(string), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("\"UTF-8\" is not supported?");
        }
    }

    private static String encodeContainerName(String containerName) {
        if (containerName == null) {
            throw new NullPointerException("containerName");
        }
        if ((containerName = containerName.trim()).isEmpty()) {
            throw new IllegalArgumentException("empty containerName");
        }
        if (containerName.contains(PATH_SEPARATOR)) {
            throw new IllegalArgumentException("containerName contains PATH_SEPARATOR(\"/\")");
        }
        if ((containerName = UcloudStorageClient.utf8(containerName)).length() > 256) {
            throw new IllegalArgumentException("encoded containerName's length(" + containerName.length() + " > (" + 256 + ")");
        }
        return containerName;
    }

    private static String encodeObjectName(String objectName) {
        if (objectName == null) {
            throw new NullPointerException("objectName");
        }
        if ((objectName = objectName.trim()).isEmpty()) {
            throw new IllegalArgumentException("empty objectName");
        }
        if ((objectName = UcloudStorageClient.utf8(objectName)).length() > 1024) {
            throw new IllegalArgumentException("encoded objectName's length(" + objectName.length() + "> (" + 1024 + ")");
        }
        return objectName;
    }

    private static String append(String base, Map<String, Object> params) {
        Map.Entry<String, Object> entry;
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (params == null || params.isEmpty()) {
            return base;
        }
        StringBuilder builder = new StringBuilder(base);
        Iterator<Map.Entry<String, Object>> i = params.entrySet().iterator();
        if (i.hasNext()) {
            entry = i.next();
            builder.append("?").append(UcloudStorageClient.utf8(entry.getKey())).append("=").append(UcloudStorageClient.utf8(entry.getValue()));
        }
        while (i.hasNext()) {
            entry = i.next();
            builder.append("&").append(UcloudStorageClient.utf8(entry.getKey())).append("=").append(UcloudStorageClient.utf8(entry.getValue()));
        }
        return builder.toString();
    }

    private static void copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        if (output == null) {
            throw new NullPointerException("null output");
        }
        if (buffer == null) {
            throw new NullPointerException("null buffer");
        }
        if (buffer.length == 0) {
            throw new IllegalArgumentException("zero-length buffer");
        }
        int read = -1;
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
        }
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        UcloudStorageClient.copy(input, output, new byte[4096]);
    }

    public UcloudStorageClient(String storageUser, String storagePass) {
        if (storageUser == null) {
            throw new NullPointerException("storageUser");
        }
        if (storagePass == null) {
            throw new NullPointerException("storagePass");
        }
        this.storageUser = storageUser;
        this.storagePass = storagePass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticate() throws IOException {
        LOGGER.debug("authenticate()");
        URL url = new URL(AUTH_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("X-Storage-User", this.storageUser);
        connection.setRequestProperty("X-Storage-Pass", this.storagePass);
        this.setTimeouts(connection);
        connection.connect();
        try {
            this.setResponses(connection);
            if (this.responseCode == 200) {
                this.storageUrl = connection.getHeaderField("X-Storage-URL");
                this.authToken = connection.getHeaderField("X-Auth-Token");
                boolean bl = true;
                return bl;
            }
        }
        finally {
            connection.disconnect();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageAccount readStorageAccount() throws IOException {
        LOGGER.debug("readStorageAccount()");
        if (!this.authenticate()) {
            return null;
        }
        String base = this.storageUrl;
        URL url = new URL(base);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("HEAD");
        connection.setRequestProperty("X-Auth-Token", this.authToken);
        connection.setRequestProperty("Accept", "application/xml");
        this.setTimeouts(connection);
        connection.connect();
        try {
            this.setResponses(connection);
            if (this.responseCode == 204) {
                StorageAccount storageAccount = new StorageAccount();
                storageAccount.setContainerCount(Long.parseLong(this.getFirstHeaderValue("X-Account-Container-Count")));
                storageAccount.setObjectCount(Long.parseLong(this.getFirstHeaderValue("X-Account-Object-Count")));
                storageAccount.setBytesUsed(Long.parseLong(this.getFirstHeaderValue("X-Account-Bytes-Used")));
                StorageAccount storageAccount2 = storageAccount;
                return storageAccount2;
            }
        }
        finally {
            connection.disconnect();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public boolean readStorageContainers(Map<String, Object> queryParameters, Collection<? super StorageContainer> storageContainers) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createStorageContainer(String containerName) throws IOException {
        LOGGER.debug("createStorageContainer({})", (Object)containerName);
        String encodedContainerName = UcloudStorageClient.encodeContainerName(containerName);
        if (!this.authenticate()) {
            return false;
        }
        String spec = this.storageUrl + PATH_SEPARATOR + encodedContainerName;
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("X-Auth-Token", this.authToken);
        this.setTimeouts(connection);
        connection.connect();
        try {
            this.setResponses(connection);
            if (this.responseCode == 201 || this.responseCode == 202) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            connection.disconnect();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageContainer readStorageContainer(String containerName) throws IOException {
        LOGGER.debug("readStorageContainer({})", (Object)containerName);
        String encodedContainerName = UcloudStorageClient.encodeContainerName(containerName);
        if (!this.authenticate()) {
            return null;
        }
        String base = this.storageUrl + PATH_SEPARATOR + encodedContainerName;
        URL url = new URL(base);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("HEAD");
        connection.setRequestProperty("X-Auth-Token", this.authToken);
        this.setTimeouts(connection);
        connection.connect();
        try {
            this.setResponses(connection);
            if (this.responseCode == 204) {
                StorageContainer storageContainer = new StorageContainer();
                storageContainer.setContainerName(containerName);
                storageContainer.setContainerName(containerName);
                storageContainer.setObjectCount(Long.parseLong(this.getFirstHeaderValue("X-Container-Object-Count")));
                storageContainer.setBytesUsed(Long.parseLong(this.getFirstHeaderValue("X-Container-Bytes-Used")));
                StorageContainer storageContainer2 = storageContainer;
                return storageContainer2;
            }
        }
        finally {
            connection.disconnect();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteStorageContainer(String containerName) throws IOException {
        LOGGER.debug("deleteStorageContainer({})", (Object)containerName);
        String encodedContainerName = UcloudStorageClient.encodeContainerName(containerName);
        if (!this.authenticate()) {
            return false;
        }
        String spec = this.storageUrl + PATH_SEPARATOR + encodedContainerName;
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("X-Auth-Token", this.authToken);
        this.setTimeouts(connection);
        connection.connect();
        try {
            this.setResponses(connection);
            if (this.responseCode == 204 || this.responseCode == 404) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            connection.disconnect();
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public boolean readStorageObjects(String containerName, Map<String, Object> queryParameters, Collection<? super StorageObject> storageObjects) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageObject readStorageObject(String containerName, String objectName) throws IOException {
        LOGGER.debug("readStorageObject({}, {})", (Object)containerName, (Object)objectName);
        String encodedContainerName = UcloudStorageClient.encodeContainerName(containerName);
        String encodedObjectName = UcloudStorageClient.encodeObjectName(objectName);
        if (!this.authenticate()) {
            return null;
        }
        String spec = this.storageUrl + PATH_SEPARATOR + encodedContainerName + PATH_SEPARATOR + encodedObjectName;
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("HEAD");
        connection.setRequestProperty("X-Auth-Token", this.authToken);
        this.setTimeouts(connection);
        connection.connect();
        try {
            this.setResponses(connection);
            if (this.responseCode == 200 || this.responseCode == 204) {
                StorageObject storageObject = new StorageObject();
                storageObject.setObjectName(objectName);
                storageObject.setLastModified(connection.getLastModified());
                storageObject.setEntityTag(this.getFirstHeaderValue("Etag"));
                storageObject.setContentType(connection.getContentType());
                storageObject.setContentLength(UcloudStorageClient.getContentLength(connection));
                storageObject.setLastModified(connection.getLastModified());
                StorageObject storageObject2 = storageObject;
                return storageObject2;
            }
        }
        finally {
            connection.disconnect();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteStorageObject(String containerName, String objectName) throws IOException {
        LOGGER.debug("deleteStorageObject({}, {})", (Object)containerName, (Object)objectName);
        String encodedContainerName = UcloudStorageClient.encodeContainerName(containerName);
        String encodedObjectName = UcloudStorageClient.encodeObjectName(objectName);
        if (!this.authenticate()) {
            return false;
        }
        String base = this.storageUrl + PATH_SEPARATOR + encodedContainerName + PATH_SEPARATOR + encodedObjectName;
        URL url = new URL(base);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("X-Auth-Token", this.authToken);
        this.setTimeouts(connection);
        connection.connect();
        try {
            this.setResponses(connection);
            if (this.responseCode == 204 || this.responseCode == 404) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            connection.disconnect();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStorageContent(String containerName, String objectName, ContentProducer contentProducer) throws IOException {
        LOGGER.debug("updateStorageContent({}, {}, {})", new Object[]{containerName, objectName, contentProducer});
        String encodedContainerName = UcloudStorageClient.encodeContainerName(containerName);
        String encodedObjectName = UcloudStorageClient.encodeObjectName(objectName);
        if (!this.createStorageContainer(containerName)) {
            return false;
        }
        String base = this.storageUrl + PATH_SEPARATOR + encodedContainerName + PATH_SEPARATOR + encodedObjectName;
        URL url = new URL(base);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("X-Auth-Token", this.authToken);
        String contentType = contentProducer.getContentType();
        if (contentType == null) {
            contentType = UNKNOWN_CONTENT_TYPE;
        }
        connection.setRequestProperty("Content-Type", contentType);
        long contentLength = contentProducer.getContentLength();
        if (contentLength > -1L) {
            connection.setRequestProperty("Content-Length", Long.toString(contentLength));
        } else {
            connection.setChunkedStreamingMode(4096);
        }
        this.setTimeouts(connection);
        connection.connect();
        try {
            OutputStream contentData = connection.getOutputStream();
            try {
                contentProducer.getContentData(contentData);
            }
            finally {
                contentData.close();
            }
            this.setResponses(connection);
            if (this.responseCode == 201) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            connection.disconnect();
        }
        return false;
    }

    public boolean updateStorageContent(String containerName, String objectName, final String contentType, final long contentLength, final InputStream contentData) throws IOException {
        LOGGER.debug("updateStorageContent({}, {}, {}, {}, {})", new Object[]{containerName, objectName, contentType, contentLength, contentData});
        if (contentData == null) {
            throw new NullPointerException("contentData");
        }
        ContentProducer contentProduer = new ContentProducer(){

            public String getContentType() {
                return contentType;
            }

            public long getContentLength() {
                return contentLength;
            }

            public void getContentData(OutputStream contentData_) throws IOException {
                UcloudStorageClient.copy(contentData, contentData_);
            }
        };
        return this.updateStorageContent(containerName, objectName, contentProduer);
    }

    public boolean updateStorageContent(String containerName, String objectName, String contentType, byte[] contentData) throws IOException {
        LOGGER.debug("updateStorageContent({}, {}, {}, {})", new Object[]{containerName, objectName, contentType, contentData});
        if (contentData == null) {
            throw new NullPointerException("contentData");
        }
        return this.updateStorageContent(containerName, objectName, contentType, contentData.length, new ByteArrayInputStream(contentData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readStorageContent(String containerName, String objectName, ContentConsumer contentConsumer) throws IOException {
        LOGGER.debug("readStorageContent({}, {}, {})", new Object[]{containerName, objectName, contentConsumer});
        String encodedContainerName = UcloudStorageClient.encodeContainerName(containerName);
        String encodedObjectName = UcloudStorageClient.encodeObjectName(objectName);
        if (contentConsumer == null) {
            throw new NullPointerException("contentConsumer");
        }
        if (!this.authenticate()) {
            return false;
        }
        String spec = this.storageUrl + PATH_SEPARATOR + encodedContainerName + PATH_SEPARATOR + encodedObjectName;
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("X-Auth-Token", this.authToken);
        this.setTimeouts(connection);
        connection.connect();
        try {
            this.setResponses(connection);
            if (this.responseCode == 200) {
                contentConsumer.setContentType(connection.getContentType());
                contentConsumer.setContentLength(UcloudStorageClient.getContentLength(connection));
                InputStream contentData = connection.getInputStream();
                try {
                    contentConsumer.setContentData(contentData);
                }
                finally {
                    contentData.close();
                }
            }
            if (this.responseCode == 200) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            connection.disconnect();
        }
        return false;
    }

    private void setTimeouts(URLConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("null connection");
        }
        if (this.connectTimeout != null) {
            connection.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout != null) {
            connection.setReadTimeout(this.readTimeout);
        }
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        if (connectTimeout != null && connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout.intValue(" + connectTimeout + ") < 0");
        }
        this.connectTimeout = connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        if (readTimeout != null && readTimeout < 0) {
            throw new IllegalArgumentException("readTimeout.intValue(" + readTimeout + ") < 0");
        }
        this.readTimeout = readTimeout;
    }

    private void setResponses(HttpURLConnection connection) throws IOException {
        LOGGER.debug("setResponse({})", (Object)connection);
        if (connection == null) {
            throw new IllegalArgumentException("null connection");
        }
        this.responseCode = connection.getResponseCode();
        LOGGER.debug("responseCode: {}", (Object)this.responseCode);
        this.responseMessage = connection.getResponseMessage();
        LOGGER.debug("responseMessage: {}", (Object)this.responseMessage);
        this.headerFields = connection.getHeaderFields();
        LOGGER.debug("headerFields: {}", this.headerFields);
    }

    public int getResponseCode() {
        LOGGER.debug("getResponseCode() -> {}", (Object)this.responseCode);
        return this.responseCode;
    }

    public String getResponseMessage() {
        LOGGER.debug("getResponseMessage() -> {}", (Object)this.responseMessage);
        return this.responseMessage;
    }

    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }

    public List<String> getHeaderValues(String headerName) {
        LOGGER.debug("getHeaderValues({})", (Object)headerName);
        if (headerName == null) {
            throw new NullPointerException("headerName");
        }
        if (this.headerFields == null) {
            throw new IllegalStateException("no header fields");
        }
        return this.headerFields.get(headerName);
    }

    public String getFirstHeaderValue(String headerName) {
        LOGGER.debug("getFirstHeaderValue({})", (Object)headerName);
        List<String> headerValues = this.getHeaderValues(headerName);
        if (headerValues == null || headerValues.isEmpty()) {
            return null;
        }
        return headerValues.get(0);
    }
}

