/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.juffrou.util.reflect;

import com.googlecode.juffrou.error.ReflectionException;
import com.googlecode.juffrou.util.reflect.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;

public class BeanWrapper {
    private Object instance;
    private final Class clazz;
    private Map<Type, Type> typeArgumentsMap;
    private Map<String, BeanFieldHandler> fields;
    private Map<String, BeanWrapper> nestesWrappers;

    public BeanWrapper(Object instance) {
        this.instance = instance;
        this.clazz = instance.getClass();
        this.init();
    }

    public BeanWrapper(Class clazz) {
        this.clazz = clazz;
        this.init();
        try {
            this.instance = clazz.newInstance();
        }
        catch (InstantiationException e) {
            this.instance = null;
        }
        catch (IllegalAccessException e) {
            this.instance = null;
        }
    }

    private void init() {
        this.typeArgumentsMap = ReflectionUtil.getTypeArgumentsMap(Class.class, this.clazz);
        this.fields = new HashMap<String, BeanFieldHandler>();
        this.initFieldInfo(this.clazz, this.fields);
        this.nestesWrappers = new HashMap<String, BeanWrapper>();
    }

    private void initFieldInfo(Class<?> clazz, Map<String, BeanFieldHandler> fs) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != Object.class) {
            this.initFieldInfo(superclass, fs);
        }
        for (Field f : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            fs.put(f.getName(), new BeanFieldHandler(f));
        }
    }

    public Object getBean() {
        return this.instance;
    }

    public void setBean(Object bean) {
        if (!this.clazz.equals(bean.getClass())) {
            throw new InvalidParameterException("Bean must be of type " + this.clazz.getSimpleName());
        }
        this.instance = bean;
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    public Map<String, BeanWrapper> getNestesWrappers() {
        return this.nestesWrappers;
    }

    public void reset() {
        for (BeanWrapper bw : this.nestesWrappers.values()) {
            bw.reset();
        }
        try {
            this.instance = this.clazz.newInstance();
        }
        catch (InstantiationException e) {
            this.instance = null;
        }
        catch (IllegalAccessException e) {
            this.instance = null;
        }
    }

    public boolean hasProperty(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.fields.containsKey(propertyName);
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
        return nestedWrapper.hasProperty(nestedProperty);
    }

    public Object getValue(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.getBeanFieldHandler(propertyName).getValue();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
        return nestedWrapper.getValue(nestedProperty);
    }

    public Class<?> getClazz(String propertyName) {
        return ReflectionUtil.getClass(this.getType(propertyName));
    }

    public Type getType(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.getBeanFieldHandler(propertyName).getType();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
        return nestedWrapper.getType(nestedProperty);
    }

    public Type[] getTypeArguments(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.getBeanFieldHandler(propertyName).getTypeArguments();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
        return nestedWrapper.getTypeArguments(nestedProperty);
    }

    public Field getField(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.getBeanFieldHandler(propertyName).getField();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
        return nestedWrapper.getField(nestedProperty);
    }

    public void setValueOfString(String propertyName, String value) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            BeanFieldHandler beanFieldHandler = this.getBeanFieldHandler(propertyName);
            Class paramType = (Class)beanFieldHandler.getType();
            try {
                if (paramType.equals(String.class)) {
                    beanFieldHandler.setValue(value);
                }
                Constructor constructor = paramType.getConstructor(String.class);
                Object convertedValue = constructor.newInstance(value);
                beanFieldHandler.setValue(convertedValue);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e);
            }
            catch (SecurityException e) {
                throw new ReflectionException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException(this.clazz.getName() + "." + propertyName + ": Cannot convert from String to " + paramType.getSimpleName() + ". Trying to convert " + value);
            }
            catch (InstantiationException e) {
                throw new ReflectionException(e);
            }
        } else {
            String thisProperty = propertyName.substring(0, nestedIndex);
            String nestedProperty = propertyName.substring(nestedIndex + 1);
            BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
            nestedWrapper.setValueOfString(nestedProperty, value);
        }
    }

    public void setValue(String propertyName, Object value) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            this.getBeanFieldHandler(propertyName).setValue(value);
        } else {
            String thisProperty = propertyName.substring(0, nestedIndex);
            String nestedProperty = propertyName.substring(nestedIndex + 1);
            BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
            nestedWrapper.setValue(nestedProperty, value);
        }
    }

    private BeanWrapper getNestedWrapper(String thisProperty) {
        BeanWrapper nestedWrapper = this.nestesWrappers.get(thisProperty);
        if (nestedWrapper == null) {
            Object value = this.getValue(thisProperty);
            if (value != null) {
                nestedWrapper = new BeanWrapper(value);
            } else {
                Class propertyType = (Class)this.getType(thisProperty);
                nestedWrapper = new BeanWrapper(propertyType);
                this.setValue(thisProperty, nestedWrapper.getBean());
            }
            this.nestesWrappers.put(thisProperty, nestedWrapper);
        }
        return nestedWrapper;
    }

    private BeanFieldHandler getBeanFieldHandler(String propertyName) {
        BeanFieldHandler bfh = this.fields.get(propertyName);
        if (bfh == null) {
            throw new ReflectionException("The class " + this.clazz.getName() + " does not have a field with name " + propertyName);
        }
        return bfh;
    }

    private class BeanFieldHandler {
        private final Field field;
        private final Type ftype;
        private final Type[] ftypeArguments;
        private Method getter = null;
        private Method setter = null;

        public BeanFieldHandler(Field field) {
            this.field = field;
            Type t = field.getGenericType();
            if (t instanceof TypeVariable) {
                t = (Type)BeanWrapper.this.typeArgumentsMap.get(t);
            }
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                this.ftypeArguments = pt.getActualTypeArguments();
            } else {
                this.ftypeArguments = null;
            }
            this.ftype = t;
        }

        public Field getField() {
            return this.field;
        }

        public Type getType() {
            return this.ftype;
        }

        public Type[] getTypeArguments() {
            return this.ftypeArguments;
        }

        public Object getValue() {
            try {
                if (this.getter == null) {
                    String name = this.field.getName();
                    String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                    this.getter = BeanWrapper.this.clazz.getMethod(methodName, null);
                }
                return this.getter.invoke(BeanWrapper.this.instance, null);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e);
            }
            catch (SecurityException e) {
                throw new ReflectionException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException("The class " + BeanWrapper.this.clazz.getSimpleName() + " does not have a getter method for the field " + this.field.getName());
            }
        }

        public void setValue(Object value) {
            try {
                if (this.setter == null) {
                    String name = this.field.getName();
                    String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
                    this.setter = BeanWrapper.this.clazz.getMethod(methodName, this.field.getType());
                }
                this.setter.invoke(BeanWrapper.this.instance, value);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e);
            }
            catch (SecurityException e) {
                throw new ReflectionException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException("The class " + BeanWrapper.this.clazz.getSimpleName() + " does not have a setter method for the field " + this.field.getName());
            }
        }

        public void setValueIfBeanField(Object value) {
            if (this.getter != null || this.setter != null) {
                try {
                    this.setValue(value);
                }
                catch (ReflectionException reflectionException) {
                    // empty catch block
                }
            }
        }
    }
}

