/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.juffrou.util.reflect;

import com.googlecode.juffrou.error.ReflectionException;
import com.googlecode.juffrou.util.reflect.BeanWrapperContext;
import com.googlecode.juffrou.util.reflect.ReflectionUtil;
import com.googlecode.juffrou.util.reflect.internal.BeanFieldHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Map;

public class BeanWrapper {
    private final BeanWrapperContext context;
    private Object instance;

    public BeanWrapper(BeanWrapperContext context) {
        this.context = context;
        this.instance = context.isEagerInstatiation() ? context.newBeanInstance() : null;
    }

    public BeanWrapper(BeanWrapperContext context, Object instance) {
        this.context = context;
        this.setBean(instance);
    }

    public BeanWrapper(Object instance) {
        this.instance = instance;
        this.context = new BeanWrapperContext(instance.getClass());
    }

    public BeanWrapper(Class clazz) {
        this.context = new BeanWrapperContext(clazz);
        this.instance = this.context.isEagerInstatiation() ? this.context.newBeanInstance() : null;
    }

    public BeanWrapperContext getContext() {
        return this.context;
    }

    public Object getBean() {
        return this.instance;
    }

    public void setBean(Object bean) {
        if (!this.context.getBeanClass().equals(bean.getClass())) {
            throw new InvalidParameterException("Bean must be of type " + this.context.getBeanClass().getSimpleName());
        }
        this.instance = bean;
    }

    public Class<?> getBeanClass() {
        return this.context.getBeanClass();
    }

    public Map<String, BeanWrapper> getNestedWrappers() {
        return this.context.getNestedWrappers();
    }

    public void reset() {
        for (BeanWrapper bw : this.context.getNestedWrappers().values()) {
            bw.reset();
        }
        this.instance = this.context.isEagerInstatiation() ? this.context.newBeanInstance() : null;
    }

    public boolean hasProperty(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.context.getFields().containsKey(propertyName);
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
        return nestedWrapper.hasProperty(nestedProperty);
    }

    public String[] getPropertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.addAll(this.context.getFields().keySet());
        return propertyNames.toArray(new String[0]);
    }

    public Object getValue(String propertyName) {
        if (this.instance == null) {
            return null;
        }
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.context.getBeanFieldHandler(propertyName).getValue(this);
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
        return nestedWrapper.getValue(nestedProperty);
    }

    public Class<?> getClazz(String propertyName) {
        return ReflectionUtil.getClass(this.getType(propertyName));
    }

    public Type getType(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.context.getBeanFieldHandler(propertyName).getType();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
        return nestedWrapper.getType(nestedProperty);
    }

    public Type[] getTypeArguments(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.context.getBeanFieldHandler(propertyName).getTypeArguments();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
        return nestedWrapper.getTypeArguments(nestedProperty);
    }

    public Field getField(String propertyName) {
        int nestedIndex = propertyName.indexOf(46);
        if (nestedIndex == -1) {
            return this.context.getBeanFieldHandler(propertyName).getField();
        }
        String thisProperty = propertyName.substring(0, nestedIndex);
        String nestedProperty = propertyName.substring(nestedIndex + 1);
        BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
        return nestedWrapper.getField(nestedProperty);
    }

    public void setValueOfString(String propertyName, String value) {
        int nestedIndex;
        if (this.instance == null) {
            this.instance = this.context.newBeanInstance();
        }
        if ((nestedIndex = propertyName.indexOf(46)) == -1) {
            BeanFieldHandler beanFieldHandler = this.context.getBeanFieldHandler(propertyName);
            Class paramType = (Class)beanFieldHandler.getType();
            try {
                if (paramType.equals(String.class)) {
                    beanFieldHandler.setValue(this, value);
                }
                Constructor constructor = paramType.getConstructor(String.class);
                Object convertedValue = constructor.newInstance(value);
                beanFieldHandler.setValue(this, convertedValue);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e);
            }
            catch (SecurityException e) {
                throw new ReflectionException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException(this.context.getBeanClass().getName() + "." + propertyName + ": Cannot convert from String to " + paramType.getSimpleName() + ". Trying to convert " + value);
            }
            catch (InstantiationException e) {
                throw new ReflectionException(e);
            }
        } else {
            String thisProperty = propertyName.substring(0, nestedIndex);
            String nestedProperty = propertyName.substring(nestedIndex + 1);
            BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
            nestedWrapper.setValueOfString(nestedProperty, value);
        }
    }

    public void setValue(String propertyName, Object value) {
        int nestedIndex;
        if (this.instance == null) {
            this.instance = this.context.newBeanInstance();
        }
        if ((nestedIndex = propertyName.indexOf(46)) == -1) {
            this.context.getBeanFieldHandler(propertyName).setValue(this, value);
        } else {
            String thisProperty = propertyName.substring(0, nestedIndex);
            String nestedProperty = propertyName.substring(nestedIndex + 1);
            BeanWrapper nestedWrapper = this.getNestedWrapper(thisProperty);
            nestedWrapper.setValue(nestedProperty, value);
        }
    }

    private BeanWrapper getNestedWrapper(String thisProperty) {
        BeanWrapper nestedWrapper = this.context.getNestedWrappers().get(thisProperty);
        if (nestedWrapper == null) {
            Object value = this.getValue(thisProperty);
            if (value != null) {
                nestedWrapper = new BeanWrapper(value);
            } else {
                Class propertyType = (Class)this.getType(thisProperty);
                nestedWrapper = new BeanWrapper(propertyType);
                this.setValue(thisProperty, nestedWrapper.getBean());
            }
            this.context.getNestedWrappers().put(thisProperty, nestedWrapper);
        }
        return nestedWrapper;
    }
}

