/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.juffrou.util.reflect;

import com.googlecode.juffrou.error.BeanInstanceCreatorException;
import com.googlecode.juffrou.error.ReflectionException;
import com.googlecode.juffrou.util.reflect.BeanInstanceCreator;
import com.googlecode.juffrou.util.reflect.BeanWrapper;
import com.googlecode.juffrou.util.reflect.ReflectionUtil;
import com.googlecode.juffrou.util.reflect.internal.BeanFieldHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class BeanWrapperContext {
    private final Class clazz;
    private final Map<Type, Type> typeArgumentsMap;
    private final Map<String, BeanFieldHandler> fields;
    private final Map<String, BeanWrapper> nestesWrappers;
    private BeanInstanceCreator beanInstanceCreator;
    private boolean eagerInstatiation;

    public BeanWrapperContext(Class clazz) {
        this.clazz = clazz;
        this.typeArgumentsMap = ReflectionUtil.getTypeArgumentsMap(Class.class, clazz);
        this.fields = new HashMap<String, BeanFieldHandler>();
        this.initFieldInfo(this.clazz, this.fields);
        this.nestesWrappers = new HashMap<String, BeanWrapper>();
        this.beanInstanceCreator = new DefaultBeanInstanceCreator();
        this.eagerInstatiation = false;
    }

    private void initFieldInfo(Class<?> clazz, Map<String, BeanFieldHandler> fs) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != Object.class) {
            this.initFieldInfo(superclass, fs);
        }
        for (Field f : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            fs.put(f.getName(), new BeanFieldHandler(this, f));
        }
    }

    public BeanFieldHandler getBeanFieldHandler(String propertyName) {
        BeanFieldHandler bfh = this.fields.get(propertyName);
        if (bfh == null) {
            throw new ReflectionException("The class " + this.clazz.getName() + " does not have a field with name " + propertyName);
        }
        return bfh;
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    public Object newBeanInstance() {
        try {
            return this.beanInstanceCreator.newBeanInstance();
        }
        catch (BeanInstanceCreatorException e) {
            throw new ReflectionException(e);
        }
    }

    public Map<String, BeanWrapper> getNestedWrappers() {
        return this.nestesWrappers;
    }

    public Map<String, BeanFieldHandler> getFields() {
        return this.fields;
    }

    public Map<Type, Type> getTypeArgumentsMap() {
        return this.typeArgumentsMap;
    }

    public void setBeanInstanceCreator(BeanInstanceCreator beanInstanceCreator) {
        this.beanInstanceCreator = beanInstanceCreator;
    }

    public boolean isEagerInstatiation() {
        return this.eagerInstatiation;
    }

    public void setEagerInstatiation(boolean eager) {
        this.eagerInstatiation = eager;
    }

    private class DefaultBeanInstanceCreator
    implements BeanInstanceCreator {
        private DefaultBeanInstanceCreator() {
        }

        @Override
        public Object newBeanInstance() throws BeanInstanceCreatorException {
            Object instance;
            try {
                instance = BeanWrapperContext.this.clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new BeanInstanceCreatorException(e);
            }
            catch (IllegalAccessException e) {
                throw new BeanInstanceCreatorException(e);
            }
            return instance;
        }
    }
}

