/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.googlecode.kevinarpe.papaya.function.ThrowingFunction;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAddressListType;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EmailMessageAddressListTypeTest {
    private MimeMessage mimeMessage;
    private InternetAddress[] inetAddrArr;

    @BeforeMethod
    public void beforeEachTestMethod() throws Exception {
        Properties props = new Properties();
        Session session = Session.getDefaultInstance((Properties)props);
        this.mimeMessage = new MimeMessage(session);
        this.inetAddrArr = new InternetAddress[]{new InternetAddress("kevinarpe@gmail.com", "Kevin Connor ARPE", StandardCharsets.UTF_8.name())};
    }

    @Test
    public void REPLY_TO_setValue_Pass() throws Exception {
        this._pass(EmailMessageAddressListType.REPLY_TO, (ThrowingFunction<MimeMessage, Address[]>)((ThrowingFunction)MimeMessage::getReplyTo));
    }

    @Test
    public void TO_setValue_Pass() throws Exception {
        this._pass(EmailMessageAddressListType.TO, (ThrowingFunction<MimeMessage, Address[]>)((ThrowingFunction)mm -> mm.getRecipients(Message.RecipientType.TO)));
    }

    @Test
    public void CC_setValue_Pass() throws Exception {
        this._pass(EmailMessageAddressListType.CC, (ThrowingFunction<MimeMessage, Address[]>)((ThrowingFunction)mm -> mm.getRecipients(Message.RecipientType.CC)));
    }

    @Test
    public void BCC_setValue_Pass() throws Exception {
        this._pass(EmailMessageAddressListType.BCC, (ThrowingFunction<MimeMessage, Address[]>)((ThrowingFunction)mm -> mm.getRecipients(Message.RecipientType.BCC)));
    }

    private void _pass(EmailMessageAddressListType addressListType, ThrowingFunction<MimeMessage, Address[]> getInetAddrArr) throws Exception {
        Assert.assertNull((Object)getInetAddrArr.apply((Object)this.mimeMessage));
        addressListType.setValue(this.mimeMessage, this.inetAddrArr);
        Assert.assertEquals((Object[])((Object[])getInetAddrArr.apply((Object)this.mimeMessage)), (Object[])this.inetAddrArr);
    }
}

