/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAddress;
import javax.mail.internet.InternetAddress;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EmailMessageAddressTest {
    @Test
    public void pass_fromEmailAddressOnly() throws Exception {
        String emailAddress = "kevinarpe@gmail.com";
        EmailMessageAddress ema = EmailMessageAddress.fromEmailAddressOnly((String)"kevinarpe@gmail.com");
        Assert.assertEquals((String)ema.emailAddress, (String)"kevinarpe@gmail.com");
        Assert.assertNull((Object)ema.nullableDisplayName);
        InternetAddress ia = ema.createInternetAddress();
        Assert.assertEquals((String)ia.getAddress(), (String)"kevinarpe@gmail.com");
        Assert.assertNull((Object)ia.getPersonal());
        Assert.assertNotEquals((Object)ema.hashCode(), (Object)0);
        EmailMessageAddress ema2 = EmailMessageAddress.fromEmailAddressOnly((String)"kevinarpe@gmail.com");
        Assert.assertTrue((boolean)ema.equals((Object)ema));
        Assert.assertTrue((boolean)ema.equals((Object)ema2));
        Assert.assertFalse((boolean)ema.equals(null));
        Assert.assertFalse((boolean)ema.equals((Object)"abc"));
        Assert.assertEquals((String)ema.toString(), (String)"kevinarpe@gmail.com");
    }

    @Test
    public void pass_fromEmailAddressAndDisplayName() throws Exception {
        String emailAddress = "kevinarpe@gmail.com";
        String displayName = "Kevin Connor ARPE";
        EmailMessageAddress ema = EmailMessageAddress.fromEmailAddressAndDisplayName((String)"kevinarpe@gmail.com", (String)"Kevin Connor ARPE");
        Assert.assertEquals((String)ema.emailAddress, (String)"kevinarpe@gmail.com");
        Assert.assertEquals((String)ema.nullableDisplayName, (String)"Kevin Connor ARPE");
        InternetAddress ia = ema.createInternetAddress();
        Assert.assertEquals((String)ia.getAddress(), (String)"kevinarpe@gmail.com");
        Assert.assertEquals((String)ia.getPersonal(), (String)"Kevin Connor ARPE");
        Assert.assertNotEquals((Object)ema.hashCode(), (Object)0);
        EmailMessageAddress ema2 = EmailMessageAddress.fromEmailAddressAndDisplayName((String)"kevinarpe@gmail.com", (String)"Kevin Connor ARPE");
        Assert.assertTrue((boolean)ema.equals((Object)ema));
        Assert.assertTrue((boolean)ema.equals((Object)ema2));
        Assert.assertFalse((boolean)ema.equals(null));
        Assert.assertFalse((boolean)ema.equals((Object)"abc"));
        Assert.assertEquals((String)ema.toString(), (String)String.format("%s <%s>", "Kevin Connor ARPE", "kevinarpe@gmail.com"));
    }
}

