/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.googlecode.kevinarpe.papaya.annotation.EmptyStringAllowed;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAttachment;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAttachmentType;
import com.googlecode.kevinarpe.papaya.java_mail.IsEmptyAllowed;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class EmailMessageAttachmentTest {
    @Test
    public void ctor_Pass() {
        new EmailMessageAttachment(EmailMessageAttachmentType.ATTACHMENT, "file_name.txt", "text/plain; charset=UTF-8", "blah".getBytes(StandardCharsets.UTF_8), IsEmptyAllowed.NO);
        new EmailMessageAttachment(EmailMessageAttachmentType.ATTACHMENT, "file_name.txt", "text/plain; charset=UTF-8", new byte[0], IsEmptyAllowed.YES);
        new EmailMessageAttachment(EmailMessageAttachmentType.INLINE, null, "text/plain; charset=UTF-8", "blah".getBytes(StandardCharsets.UTF_8), IsEmptyAllowed.NO);
        new EmailMessageAttachment(EmailMessageAttachmentType.INLINE, null, "text/plain; charset=UTF-8", new byte[0], IsEmptyAllowed.YES);
    }

    @DataProvider
    private static Object[][] _ctor_Fail_Data() {
        return new Object[][]{{EmailMessageAttachmentType.ATTACHMENT, null, "blah", IsEmptyAllowed.NO, NullPointerException.class}, {EmailMessageAttachmentType.ATTACHMENT, "", "blah", IsEmptyAllowed.NO, IllegalArgumentException.class}, {EmailMessageAttachmentType.ATTACHMENT, "  \t  ", "blah", IsEmptyAllowed.NO, IllegalArgumentException.class}, {EmailMessageAttachmentType.ATTACHMENT, "file_name.txt", "", IsEmptyAllowed.NO, IllegalArgumentException.class}, {EmailMessageAttachmentType.INLINE, "file_name.txt", "blah", IsEmptyAllowed.NO, IllegalArgumentException.class}, {EmailMessageAttachmentType.INLINE, "", "blah", IsEmptyAllowed.NO, IllegalArgumentException.class}, {EmailMessageAttachmentType.INLINE, null, "", IsEmptyAllowed.NO, IllegalArgumentException.class}};
    }

    @Test(dataProvider="_ctor_Fail_Data")
    public void ctor_Fail(EmailMessageAttachmentType attachmentType, @Nullable String nullableFileName, @EmptyStringAllowed String text, IsEmptyAllowed isEmptyAllowed, Class<?> exceptionClass) {
        boolean hasException = false;
        try {
            new EmailMessageAttachment(attachmentType, nullableFileName, "text/plain; charset=UTF-8", text.getBytes(StandardCharsets.UTF_8), isEmptyAllowed);
        }
        catch (Exception e) {
            if (exceptionClass.isInstance(e)) {
                hasException = true;
            }
            throw e;
        }
        Assert.assertTrue((boolean)hasException);
    }
}

