/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.google.common.base.Joiner;
import com.google.common.io.CharStreams;
import com.googlecode.kevinarpe.papaya.StringUtils;
import com.googlecode.kevinarpe.papaya.annotation.EmptyStringAllowed;
import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.argument.StringArgs;
import com.googlecode.kevinarpe.papaya.concurrent.ThreadLocalWithReset;
import com.googlecode.kevinarpe.papaya.concurrent.ThreadLocalsWithReset;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAttachment;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAttachmentTextNewLine;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAttachmentType;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBuilderImp;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageTextAttachmentBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.IsEmptyAllowed;
import com.googlecode.kevinarpe.papaya.java_mail.TextMimeSubType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.annotation.Nullable;

@FullyTested
public final class EmailMessageTextAttachmentBuilderImp
implements EmailMessageTextAttachmentBuilder {
    private final EmailMessageBuilder parentBuilder;
    @Nullable
    private EmailMessageAttachmentType nullableAttachmentType;
    @Nullable
    private String nullableAttachmentFileName;
    @Nullable
    private String nullableTextMimeSubType;
    private static final ThreadLocalWithReset<ArrayList<String>> threadLocalMissingList = ThreadLocalsWithReset.newInstanceForArrayList();

    public EmailMessageTextAttachmentBuilderImp(EmailMessageBuilder parentBuilder) {
        this.parentBuilder = (EmailMessageBuilder)ObjectArgs.checkNotNull((Object)parentBuilder, (String)"parentBuilder");
        this.nullableAttachmentType = null;
        this.nullableAttachmentFileName = null;
        this.nullableTextMimeSubType = null;
    }

    @Override
    public EmailMessageBuilder parent() {
        return this.parentBuilder;
    }

    @Override
    public EmailMessageTextAttachmentBuilder attachmentFileName(String attachmentFileName) {
        this.nullableAttachmentType = EmailMessageAttachmentType.ATTACHMENT;
        this.nullableAttachmentFileName = (String)StringArgs.checkNotEmptyOrWhitespace((CharSequence)attachmentFileName, (String)"attachmentFileName");
        return this;
    }

    @Override
    public EmailMessageTextAttachmentBuilder inline() {
        this.nullableAttachmentType = EmailMessageAttachmentType.INLINE;
        this.nullableAttachmentFileName = null;
        return this;
    }

    @Override
    public EmailMessageTextAttachmentBuilder textMimeSubType(TextMimeSubType textMimeSubType) {
        ObjectArgs.checkNotNull((Object)((Object)textMimeSubType), (String)"textMimeType");
        this.nullableTextMimeSubType = textMimeSubType.textMimeSubType;
        return this;
    }

    @Override
    public EmailMessageTextAttachmentBuilder customTextMimeSubType(String customTextMimeSubType) {
        this.nullableTextMimeSubType = (String)StringArgs.checkNotEmptyOrWhitespace((CharSequence)customTextMimeSubType, (String)"customTextMimeSubType");
        return this;
    }

    @Override
    public EmailMessageTextAttachmentBuilder attachTextFile(File filePath, Charset fileCharset, EmailMessageAttachmentTextNewLine newLine, IsEmptyAllowed isEmptyAllowed) throws Exception {
        this._assetAllSet();
        FileInputStream fis = new FileInputStream(filePath);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, fileCharset);
        String text = CharStreams.toString((Readable)isr);
        isr.close();
        this._attachText(text, newLine, isEmptyAllowed);
        return this;
    }

    @Override
    public EmailMessageTextAttachmentBuilder attachTextInputStream(InputStream inputStream, Charset inputStreamCharset, EmailMessageAttachmentTextNewLine newLine, IsEmptyAllowed isEmptyAllowed) throws Exception {
        this._assetAllSet();
        InputStreamReader isr = new InputStreamReader(inputStream, inputStreamCharset);
        String text = CharStreams.toString((Readable)isr);
        isr.close();
        this._attachText(text, newLine, isEmptyAllowed);
        return this;
    }

    @Override
    public EmailMessageTextAttachmentBuilder attachText(@EmptyStringAllowed String text, EmailMessageAttachmentTextNewLine newLine, IsEmptyAllowed isEmptyAllowed) {
        this._assetAllSet();
        this._attachText(text, newLine, isEmptyAllowed);
        return this;
    }

    private void _assetAllSet() {
        ArrayList missingList = (ArrayList)threadLocalMissingList.getAndReset();
        if (null == this.nullableAttachmentType) {
            missingList.add("attachment type");
        }
        if (EmailMessageAttachmentType.ATTACHMENT.equals((Object)this.nullableAttachmentType) && null == this.nullableAttachmentFileName) {
            missingList.add("file name");
        }
        if (null == this.nullableTextMimeSubType) {
            missingList.add("MIME text sub-type");
        }
        if (missingList.size() > 0) {
            throw new IllegalStateException("Missing: " + Joiner.on((String)", ").join((Iterable)missingList));
        }
    }

    private void _attachText(@EmptyStringAllowed String text, EmailMessageAttachmentTextNewLine newLine, IsEmptyAllowed isEmptyAllowed) {
        String adjText = this._adjNewLines(text, newLine, isEmptyAllowed);
        byte[] byteArr = adjText.getBytes(EmailMessageBuilderImp.DEFAULT_CHARSET);
        String mimeType = "text/" + this.nullableTextMimeSubType + "; charset=" + EmailMessageBuilderImp.DEFAULT_CHARSET.name();
        EmailMessageAttachment a = new EmailMessageAttachment(this.nullableAttachmentType, this.nullableAttachmentFileName, mimeType, byteArr, isEmptyAllowed);
        ArrayList<EmailMessageAttachment> attachmentList = this.parentBuilder.attachmentList();
        attachmentList.add(a);
    }

    private String _adjNewLines(@EmptyStringAllowed String text, EmailMessageAttachmentTextNewLine newLine, IsEmptyAllowed isEmptyAllowed) {
        if (IsEmptyAllowed.NO.equals((Object)isEmptyAllowed)) {
            StringArgs.checkNotEmpty((CharSequence)text, (String)"text");
        }
        switch (newLine) {
            case UNCHANGED: {
                return text;
            }
            case UNIX: {
                String x = text.replace(StringUtils.WINDOWS_NEW_LINE, StringUtils.UNIX_NEW_LINE);
                return x;
            }
            case WINDOWS: {
                String x = text.replace(StringUtils.WINDOWS_NEW_LINE, StringUtils.UNIX_NEW_LINE).replace(StringUtils.UNIX_NEW_LINE, StringUtils.WINDOWS_NEW_LINE);
                return x;
            }
        }
        throw new IllegalStateException("Internal error: Missing switch case for " + ((Object)((Object)newLine)).getClass().getSimpleName() + "." + newLine.name());
    }
}

