/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.googlecode.kevinarpe.papaya.argument.IntArgs;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.argument.StringArgs;
import com.googlecode.kevinarpe.papaya.java_mail.AlwaysTrustSSL;
import com.googlecode.kevinarpe.papaya.java_mail.JavaMailSession;
import com.googlecode.kevinarpe.papaya.java_mail.JavaMailSessionBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.JavaMailSessionFactory;
import com.googlecode.kevinarpe.papaya.java_mail.SmtpPort;
import java.util.Properties;
import javax.mail.Session;

public final class JavaMailSessionBuilderImp
implements JavaMailSessionBuilder {
    public static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    public static final String MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String MAIL_SMTP_SSL_TRUST = "mail.smtp.ssl.trust";
    public static final String MAIL_SMTP_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_USER = "mail.smtp.user";
    public static final String MAIL_SMTP_PASSWORD = "mail.smtp.password";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    private final Properties properties = new Properties();

    public JavaMailSessionBuilderImp() {
        this.properties.put(MAIL_SMTP_STARTTLS_ENABLE, "true");
    }

    @Override
    public JavaMailSessionBuilder host(String host, AlwaysTrustSSL alwaysTrustSSL) {
        StringArgs.checkNotEmptyOrWhitespace((CharSequence)host, (String)"host");
        ObjectArgs.checkNotNull((Object)((Object)alwaysTrustSSL), (String)"alwaysTrustSSL");
        this.properties.setProperty(MAIL_SMTP_HOST, host);
        if (AlwaysTrustSSL.YES.equals((Object)alwaysTrustSSL)) {
            this.properties.setProperty(MAIL_SMTP_SSL_TRUST, host);
        }
        return this;
    }

    @Override
    public JavaMailSessionBuilder port(SmtpPort smtpPort) {
        ObjectArgs.checkNotNull((Object)((Object)smtpPort), (String)"smtpPort");
        this.properties.setProperty(MAIL_SMTP_PORT, String.valueOf(smtpPort.port));
        return this;
    }

    @Override
    public JavaMailSessionBuilder customPort(int port) {
        IntArgs.checkMinValue((int)port, (int)1, (String)"port");
        this.properties.setProperty(MAIL_SMTP_PORT, String.valueOf(port));
        return this;
    }

    @Override
    public JavaMailSessionBuilder usernameAndPassword(String username, String password) {
        StringArgs.checkNotEmptyOrWhitespace((CharSequence)username, (String)"username");
        StringArgs.checkNotEmptyOrWhitespace((CharSequence)password, (String)"password");
        this.properties.setProperty(MAIL_SMTP_USER, username);
        this.properties.setProperty(MAIL_SMTP_PASSWORD, password);
        this.properties.setProperty(MAIL_SMTP_AUTH, "true");
        return this;
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    @Override
    public JavaMailSession build() {
        this._assertSet(MAIL_SMTP_HOST, "host");
        this._assertSet(MAIL_SMTP_PORT, "port");
        Session session = Session.getInstance((Properties)this.properties);
        JavaMailSession x = JavaMailSessionFactory.INSTANCE.newInstance(session);
        return x;
    }

    private void _assertSet(String propertyName, String attributeName) {
        String value = this.properties.getProperty(propertyName);
        if (null == value) {
            throw new IllegalStateException("Attribute is unset: " + attributeName);
        }
    }
}

