/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.googlecode.kevinarpe.papaya.annotation.Blocking;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBuilderFactory;
import com.googlecode.kevinarpe.papaya.java_mail.JavaMailSession;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;

public final class JavaMailSessionImp
implements JavaMailSession {
    private final Session session;
    private final EmailMessageBuilderFactory emailMessageBuilderFactory;

    public JavaMailSessionImp(Session session) {
        this(session, EmailMessageBuilderFactory.INSTANCE);
    }

    JavaMailSessionImp(Session session, EmailMessageBuilderFactory emailMessageBuilderFactory) {
        this.session = (Session)ObjectArgs.checkNotNull((Object)session, (String)"session");
        this.emailMessageBuilderFactory = (EmailMessageBuilderFactory)ObjectArgs.checkNotNull((Object)emailMessageBuilderFactory, (String)"emailMessageBuilderFactory");
    }

    @Override
    public EmailMessageBuilder emailMessageBuilder() {
        EmailMessageBuilder x = this.emailMessageBuilderFactory.newInstance(this);
        return x;
    }

    @Override
    public Session session() {
        return this.session;
    }

    @Override
    @Blocking
    public void sendMessage(Message message) throws Exception {
        Properties properties = this.session.getProperties();
        String username = properties.getProperty("mail.smtp.user");
        if (null == username) {
            Transport.send((Message)message);
        } else {
            String host = properties.getProperty("mail.smtp.host");
            String password = properties.getProperty("mail.smtp.password");
            Transport transport = this.session.getTransport("smtp");
            transport.connect(host, username, password);
            transport.sendMessage(message, message.getAllRecipients());
            transport.close();
        }
    }
}

