package com.googlecode.kevinarpe.papaya.java_mail;

/*-
 * #%L
 * This file is part of Papaya.
 * %%
 * Copyright (C) 2013 - 2020 Kevin Connor ARPE (kevinarpe@gmail.com)
 * %%
 * Papaya is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GPL Classpath Exception:
 * This project is subject to the "Classpath" exception as provided in
 * the LICENSE file that accompanied this code.
 * 
 * Papaya is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Papaya.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ArrayArgs;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.sun.mail.smtp.SMTPOutputStream;

import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

/**
 * @author Kevin Connor ARPE (kevinarpe@gmail.com)
 *
 * @see JavaMailSessionBuilderFactory#INSTANCE
 */
// Scope: Global singleton
@FullyTested
public final class JavaMailMessageServiceImp
implements JavaMailMessageService {

    public JavaMailMessageServiceImp() {
        // Empty
    }

    /** {@inheritDoc} */
    @Override
    public byte[]
    getMimeContentAsByteArr(Message message)
    throws Exception {

        ObjectArgs.checkNotNull(message, "message");
        final ByteArrayOutputStream baos = _createByteArrayOutputStream(message);
        // Ref: https://stackoverflow.com/a/46937410/257299
        final SMTPOutputStream smtpOutputStream = new SMTPOutputStream(baos);
        message.writeTo(smtpOutputStream);
        smtpOutputStream.close();
        final byte[] x = baos.toByteArray();
        return x;
    }

    private static ByteArrayOutputStream
    _createByteArrayOutputStream(Message message)
    throws Exception {

        final int size = message.getSize();
        if (size > 0) {

            final ByteArrayOutputStream x = new ByteArrayOutputStream(size);
            return x;
        }
        else {
            final ByteArrayOutputStream x = new ByteArrayOutputStream();
            return x;
        }
    }

    /** {@inheritDoc} */
    @Override
    public MimeMessage
    createMimeMessageFromByteArr(Session session, byte[] byteArr)
    throws Exception {

        ArrayArgs.checkNotEmpty(byteArr, "byteArr");
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArr);
        final MimeMessage x = new MimeMessage(session, byteArrayInputStream);
        return x;
    }
}
