/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.googlecode.kevinarpe.papaya.function.ThrowingFunction;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAddressType;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EmailMessageAddressTypeTest {
    private MimeMessage mimeMessage;
    private InternetAddress inetAddr;

    @BeforeMethod
    public void beforeEachTestMethod() throws Exception {
        Properties props = new Properties();
        Session session = Session.getDefaultInstance((Properties)props);
        this.mimeMessage = new MimeMessage(session);
        this.inetAddr = new InternetAddress("kevinarpe@gmail.com", "Kevin Connor ARPE", StandardCharsets.UTF_8.name());
    }

    @Test
    public void FROM_setValue_Pass() throws Exception {
        this._pass(EmailMessageAddressType.FROM, (ThrowingFunction<MimeMessage, Address>)((ThrowingFunction)mm -> {
            Address[] addrArr = mm.getFrom();
            if (null == addrArr) {
                return null;
            }
            Address x = addrArr[0];
            return x;
        }));
    }

    @Test
    public void SENDER_setValue_Pass() throws Exception {
        this._pass(EmailMessageAddressType.SENDER, (ThrowingFunction<MimeMessage, Address>)((ThrowingFunction)MimeMessage::getSender));
    }

    private void _pass(EmailMessageAddressType addressType, ThrowingFunction<MimeMessage, Address> getInetAddr) throws Exception {
        Assert.assertNull((Object)getInetAddr.apply((Object)this.mimeMessage));
        addressType.setValue(this.mimeMessage, this.inetAddr);
        Assert.assertEquals((Object)getInetAddr.apply((Object)this.mimeMessage), (Object)this.inetAddr);
    }
}

