/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.google.common.io.ByteStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.java_mail.AlwaysTrustSSL;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAddress;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAddressListType;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAddressType;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAttachmentTextNewLine;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAttachmentType;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBinaryAttachmentBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageTextAttachmentBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.IsEmptyAllowed;
import com.googlecode.kevinarpe.papaya.java_mail.JavaMailMessageService;
import com.googlecode.kevinarpe.papaya.java_mail.JavaMailSession;
import com.googlecode.kevinarpe.papaya.java_mail.JavaMailSessionBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.JavaMailSessionBuilderFactory;
import com.googlecode.kevinarpe.papaya.java_mail.SmtpPort;
import com.googlecode.kevinarpe.papaya.java_mail.TextMimeSubType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EmailMessageBuilderImpTest {
    private Wiser wiser;

    @BeforeMethod
    public void beforeEachTestMethod() {
        this.wiser = Wiser.create((SMTPServer.Builder)SMTPServer.port((int)0));
        this.wiser.start();
        int port = this.wiser.getServer().getPortAllocated();
        System.out.printf("SMTP server is now listening on port: %d%n", port);
    }

    @AfterMethod
    public void afterEachTestMethod() {
        this.wiser.stop();
        System.out.printf("SMTP server is now stopped%n", new Object[0]);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="^Missing: attachment type, MIME text sub-type$")
    public void EmailMessageTextAttachmentBuilderImp_attach_FailWhenUnset() throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.NO, UsernameAndPassword.NO);
        javaMailSession.emailMessageBuilder().builderForTextAttachment().attachText("blah", EmailMessageAttachmentTextNewLine.UNCHANGED, IsEmptyAllowed.NO);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="^Missing EmailMessageAddressType\\.FROM$")
    public void failWhenMissingFrom() throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.YES, UsernameAndPassword.NO);
        javaMailSession.emailMessageBuilder().build();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="^Failed to find any recipient addresses \\(To:, Cc:, Bcc:\\)$")
    public void failWhenZeroRecipients() throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.NO, UsernameAndPassword.NO);
        javaMailSession.emailMessageBuilder().address(EmailMessageAddressType.FROM, EmailMessageAddress.fromEmailAddressOnly((String)"blah@gmail.com")).build();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="^Missing subject$")
    public void failWhenMissingSubject() throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.YES, UsernameAndPassword.NO);
        EmailMessageBuilder b = javaMailSession.emailMessageBuilder().address(EmailMessageAddressType.FROM, EmailMessageAddress.fromEmailAddressOnly((String)"blah@gmail.com"));
        b.addressSet(EmailMessageAddressListType.TO).add(EmailMessageAddress.fromEmailAddressOnly((String)"blimey@gmail.com"));
        b.build();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="^Missing body text$")
    public void failWhenMissingBodyText() throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.NO, UsernameAndPassword.NO);
        EmailMessageBuilder b = javaMailSession.emailMessageBuilder().address(EmailMessageAddressType.FROM, EmailMessageAddress.fromEmailAddressOnly((String)"blah@gmail.com"));
        b.addressSet(EmailMessageAddressListType.TO).add(EmailMessageAddress.fromEmailAddressOnly((String)"blimey@gmail.com"));
        b.subject("subject");
        b.build();
    }

    @Test
    public void passWhenZeroAttachments() throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.YES, UsernameAndPassword.NO);
        EmailMessageAddress ema = EmailMessageAddress.fromEmailAddressOnly((String)"blah@gmail.com");
        EmailMessageBuilder b = javaMailSession.emailMessageBuilder().address(EmailMessageAddressType.FROM, ema);
        b.addressSet(EmailMessageAddressListType.TO).add(ema);
        b.subject("subject");
        b.body(TextMimeSubType.PLAIN, "body");
        _Data data = this._sendAndReceiveEmail(b);
        Assert.assertEquals((String)data.inMimeMessage.getFrom()[0].toString(), (String)ema.emailAddress);
        Assert.assertEquals((String)data.inMimeMessage.getRecipients(Message.RecipientType.TO)[0].toString(), (String)ema.emailAddress);
        Assert.assertEquals((String)data.inMimeMessage.getSubject(), (String)"subject");
        Assert.assertEquals((Object)((MimeMultipart)data.inMimeMessage.getContent()).getBodyPart(0).getContent(), (Object)"body");
    }

    @Test
    public void insecure_Pass() throws Exception {
        this._pass(UsernameAndPassword.NO);
    }

    @Test
    public void secure_Pass() throws Exception {
        this._pass(UsernameAndPassword.YES);
    }

    private void _pass(UsernameAndPassword usernameAndPassword) throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.NO, usernameAndPassword);
        EmailMessageAddress fromEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"from@gmail.com");
        EmailMessageAddress toEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"to@gmail.com");
        EmailMessageBuilder b = javaMailSession.emailMessageBuilder().subject("sample subject").body(TextMimeSubType.PLAIN, "body text").address(EmailMessageAddressType.FROM, fromEmailMessageAddress);
        b.addressSet(EmailMessageAddressListType.TO).add(toEmailMessageAddress);
        b.builderForTextAttachment().attachmentFileName("log.txt").textMimeSubType(TextMimeSubType.PLAIN).attachText(String.format("line 1%nline 2%nline 3%n", new Object[0]), EmailMessageAttachmentTextNewLine.WINDOWS, IsEmptyAllowed.NO);
        b.builderForTextAttachment().inline().textMimeSubType(TextMimeSubType.PLAIN).attachText("line4\r\nline5", EmailMessageAttachmentTextNewLine.UNIX, IsEmptyAllowed.NO);
        b.builderForBinaryAttachment().attachmentFileName("data.bin").mimeType("application/octet-stream").attachBinaryData("binary data".getBytes(StandardCharsets.UTF_8), IsEmptyAllowed.NO);
        b.builderForBinaryAttachment().inline().mimeType("application/octet-stream").attachBinaryData("binary data2".getBytes(StandardCharsets.UTF_8), IsEmptyAllowed.NO);
        _Data data = this._sendAndReceiveEmail(b);
        Assert.assertEquals((Object[])data.inMimeMessage.getFrom(), (Object[])data.outMimeMessage.getFrom());
        Assert.assertEquals((Object[])data.inMimeMessage.getRecipients(Message.RecipientType.TO), (Object[])data.outMimeMessage.getRecipients(Message.RecipientType.TO));
        Assert.assertEquals((String)data.inMimeMessage.getSubject(), (String)data.outMimeMessage.getSubject());
        MimeMultipart mimeMultipart = (MimeMultipart)data.outMimeMessage.getContent();
        MimeMultipart mimeMultipart2 = (MimeMultipart)data.inMimeMessage.getContent();
        Assert.assertEquals((int)mimeMultipart2.getCount(), (int)5);
        Assert.assertEquals((int)mimeMultipart2.getCount(), (int)mimeMultipart.getCount());
        BodyPart bodyPart = mimeMultipart.getBodyPart(0);
        BodyPart bodyPart2 = mimeMultipart2.getBodyPart(0);
        Assert.assertEquals((String)bodyPart2.getDisposition(), (String)bodyPart.getDisposition());
        Assert.assertEquals((String)bodyPart2.getFileName(), (String)bodyPart.getFileName());
        Assert.assertEquals((String)bodyPart2.getContentType(), (String)bodyPart.getContentType());
        Assert.assertEquals((String)((String)bodyPart2.getContent()), (String)"body text");
        Assert.assertEquals((String)((String)bodyPart2.getContent()), (String)((String)bodyPart.getContent()));
        BodyPart textAttachmentBodyPart = mimeMultipart.getBodyPart(1);
        BodyPart textAttachmentBodyPart2 = mimeMultipart2.getBodyPart(1);
        Assert.assertEquals((String)textAttachmentBodyPart2.getDisposition(), (String)"attachment");
        Assert.assertEquals((String)textAttachmentBodyPart2.getDisposition(), (String)textAttachmentBodyPart.getDisposition());
        Assert.assertEquals((String)textAttachmentBodyPart2.getFileName(), (String)"log.txt");
        Assert.assertEquals((String)textAttachmentBodyPart2.getFileName(), (String)textAttachmentBodyPart.getFileName());
        Assert.assertEquals((String)textAttachmentBodyPart2.getContentType(), (String)"text/plain; charset=UTF-8; name=log.txt");
        Assert.assertEquals((String)textAttachmentBodyPart2.getContentType(), (String)textAttachmentBodyPart.getContentType());
        Assert.assertEquals((String)((String)textAttachmentBodyPart2.getContent()), (String)"line 1\r\nline 2\r\nline 3\r\n");
        Assert.assertEquals((String)((String)textAttachmentBodyPart2.getContent()), (String)((String)textAttachmentBodyPart.getContent()));
        BodyPart inlineTextBodyPart = mimeMultipart.getBodyPart(2);
        BodyPart inlineTextBodyPart2 = mimeMultipart2.getBodyPart(2);
        Assert.assertEquals((String)inlineTextBodyPart2.getDisposition(), (String)"inline");
        Assert.assertEquals((String)inlineTextBodyPart2.getDisposition(), (String)inlineTextBodyPart.getDisposition());
        Assert.assertNull((Object)inlineTextBodyPart2.getFileName());
        Assert.assertEquals((String)inlineTextBodyPart2.getFileName(), (String)inlineTextBodyPart.getFileName());
        Assert.assertEquals((String)inlineTextBodyPart2.getContentType(), (String)"text/plain; charset=UTF-8");
        Assert.assertEquals((String)inlineTextBodyPart2.getContentType(), (String)inlineTextBodyPart.getContentType());
        Assert.assertEquals((String)((String)inlineTextBodyPart.getContent()), (String)"line4\nline5");
        Assert.assertEquals((String)((String)inlineTextBodyPart2.getContent()), (String)"line4\r\nline5");
        BodyPart binaryAttachmentBodyPart = mimeMultipart.getBodyPart(3);
        BodyPart binaryAttachmentBodyPart2 = mimeMultipart2.getBodyPart(3);
        Assert.assertEquals((String)binaryAttachmentBodyPart2.getDisposition(), (String)"attachment");
        Assert.assertEquals((String)binaryAttachmentBodyPart2.getDisposition(), (String)binaryAttachmentBodyPart.getDisposition());
        Assert.assertEquals((String)binaryAttachmentBodyPart2.getFileName(), (String)"data.bin");
        Assert.assertEquals((String)binaryAttachmentBodyPart2.getFileName(), (String)binaryAttachmentBodyPart.getFileName());
        Assert.assertEquals((String)binaryAttachmentBodyPart2.getContentType(), (String)"application/octet-stream; name=data.bin");
        Assert.assertEquals((String)binaryAttachmentBodyPart2.getContentType(), (String)binaryAttachmentBodyPart.getContentType());
        InputStream is = (InputStream)binaryAttachmentBodyPart2.getContent();
        byte[] byteArr = ByteStreams.toByteArray((InputStream)is);
        String s = new String(byteArr, StandardCharsets.UTF_8);
        Assert.assertEquals((String)s, (String)"binary data");
        BodyPart inlineBinaryBodyPart = mimeMultipart.getBodyPart(4);
        BodyPart inlineBinaryBodyPart2 = mimeMultipart2.getBodyPart(4);
        Assert.assertEquals((String)inlineBinaryBodyPart2.getDisposition(), (String)"inline");
        Assert.assertEquals((String)inlineBinaryBodyPart2.getDisposition(), (String)inlineBinaryBodyPart.getDisposition());
        Assert.assertNull((Object)inlineBinaryBodyPart2.getFileName());
        Assert.assertEquals((String)inlineBinaryBodyPart2.getFileName(), (String)inlineBinaryBodyPart.getFileName());
        Assert.assertEquals((String)inlineBinaryBodyPart2.getContentType(), (String)"application/octet-stream");
        Assert.assertEquals((String)inlineBinaryBodyPart2.getContentType(), (String)inlineBinaryBodyPart.getContentType());
        InputStream is2 = (InputStream)inlineBinaryBodyPart2.getContent();
        byte[] byteArr2 = ByteStreams.toByteArray((InputStream)is2);
        String s2 = new String(byteArr2, StandardCharsets.UTF_8);
        Assert.assertEquals((String)s2, (String)"binary data2");
    }

    private JavaMailSession _createJavaMailSession(AlwaysTrustSSL alwaysTrustSSL, UsernameAndPassword usernameAndPassword) {
        int port = this.wiser.getServer().getPortAllocated();
        System.out.printf("%s.%s: SMTP server port: %d%n", ((Object)((Object)usernameAndPassword)).getClass().getSimpleName(), usernameAndPassword.name(), port);
        JavaMailSessionBuilder javaMailSessionBuilder = JavaMailSessionBuilderFactory.INSTANCE.newInstance().host("localhost", alwaysTrustSSL).port(SmtpPort.MODERN_SECURE).customPort(port);
        if (UsernameAndPassword.YES.equals((Object)usernameAndPassword)) {
            javaMailSessionBuilder.usernameAndPassword("username", "password");
        }
        Assert.assertFalse((boolean)javaMailSessionBuilder.properties().isEmpty());
        JavaMailSession x = javaMailSessionBuilder.build();
        return x;
    }

    private _Data _sendAndReceiveEmail(EmailMessageBuilder b) throws Exception {
        MimeMessage mimeMessage = b.build();
        b.javaMailSession().sendMessage((Message)mimeMessage);
        List wiserMessageList = this.wiser.getMessages();
        Assert.assertEquals((int)wiserMessageList.size(), (int)1);
        WiserMessage wiserMessage = (WiserMessage)wiserMessageList.get(0);
        _Data x = new _Data(mimeMessage, wiserMessage);
        return x;
    }

    @Test
    public void EmailMessageTextAttachmentBuilderImp_attachTextFile_Pass() throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.YES, UsernameAndPassword.NO);
        EmailMessageAddress fromEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"from@gmail.com");
        EmailMessageAddress toEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"to@gmail.com");
        String subject = "sample subject";
        String bodyText = "body text";
        EmailMessageBuilder b = javaMailSession.emailMessageBuilder().subject("sample subject").body(TextMimeSubType.PLAIN, "body text").address(EmailMessageAddressType.FROM, fromEmailMessageAddress);
        b.addressSet(EmailMessageAddressListType.TO).add(toEmailMessageAddress);
        b.headers().put((Object)"X-Random", (Object)"12345");
        File filePath = File.createTempFile("EmailMessageTextAttachmentBuilderImp_attachTextFile_Pass", ".txt");
        filePath.deleteOnExit();
        File filePath2 = File.createTempFile("EmailMessageTextAttachmentBuilderImp_attachTextFile_Pass2", ".txt");
        filePath2.deleteOnExit();
        File filePath3 = File.createTempFile("EmailMessageTextAttachmentBuilderImp_attachTextFile_Pass3", ".txt");
        filePath3.deleteOnExit();
        String text = String.format("line 1%nline 2%nline 3%n", new Object[0]);
        Files.asCharSink((File)filePath, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)text);
        String attachmentFileName = "log.txt";
        b.builderForTextAttachment().attachmentFileName("log.txt").textMimeSubType(TextMimeSubType.PLAIN).attachTextFile(filePath, StandardCharsets.UTF_8, EmailMessageAttachmentTextNewLine.WINDOWS, IsEmptyAllowed.NO);
        String html = String.format("<html>%n...%n</html>%n", new Object[0]);
        Files.asCharSink((File)filePath2, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)html);
        b.builderForTextAttachment().inline().textMimeSubType(TextMimeSubType.HTML).attachTextFile(filePath2, StandardCharsets.UTF_8, EmailMessageAttachmentTextNewLine.UNCHANGED, IsEmptyAllowed.NO);
        Files.asCharSink((File)filePath3, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"");
        b.builderForTextAttachment().inline().textMimeSubType(TextMimeSubType.HTML).attachTextFile(filePath3, StandardCharsets.UTF_8, EmailMessageAttachmentTextNewLine.UNCHANGED, IsEmptyAllowed.YES);
        _Data data = this._sendAndReceiveEmail(b);
        Assert.assertEquals((Object[])data.inMimeMessage.getHeader("X-Random"), (Object[])new String[]{"12345"});
        this._assertTextAttachment(data, 1, EmailMessageAttachmentType.ATTACHMENT, "log.txt", "text/plain; charset=UTF-8", "line 1\r\nline 2\r\nline 3\r\n");
        this._assertTextAttachment(data, 2, EmailMessageAttachmentType.INLINE, null, "text/html; charset=UTF-8", "<html>\r\n...\r\n</html>\r\n");
        this._assertTextAttachment(data, 3, EmailMessageAttachmentType.INLINE, null, "text/html; charset=UTF-8", "");
    }

    @Test
    public void EmailMessageTextAttachmentBuilderImp_attachTextInputStream_Pass() throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.NO, UsernameAndPassword.YES);
        EmailMessageAddress fromEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"from@gmail.com");
        EmailMessageAddress ccEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"cc@gmail.com");
        String subject = "sample subject";
        String bodyText = "body text";
        EmailMessageBuilder b = javaMailSession.emailMessageBuilder().subject("sample subject").body(TextMimeSubType.PLAIN, "body text").address(EmailMessageAddressType.FROM, fromEmailMessageAddress);
        b.addressSet(EmailMessageAddressListType.CC).add(ccEmailMessageAddress);
        File filePath = File.createTempFile("EmailMessageTextAttachmentBuilderImp_attachTextFile_Pass", ".txt");
        filePath.deleteOnExit();
        File filePath2 = File.createTempFile("EmailMessageTextAttachmentBuilderImp_attachTextFile_Pass2", ".txt");
        filePath2.deleteOnExit();
        File filePath3 = File.createTempFile("EmailMessageTextAttachmentBuilderImp_attachTextFile_Pass3", ".txt");
        filePath3.deleteOnExit();
        String text = String.format("line 1%nline 2%nline 3%n", new Object[0]);
        Files.asCharSink((File)filePath, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)text);
        String attachmentFileName = "log.txt";
        EmailMessageTextAttachmentBuilder b2 = b.builderForTextAttachment().attachmentFileName("log.txt").customTextMimeSubType(TextMimeSubType.PLAIN.textMimeSubType).attachTextInputStream((InputStream)new FileInputStream(filePath), StandardCharsets.UTF_8, EmailMessageAttachmentTextNewLine.WINDOWS, IsEmptyAllowed.NO);
        Assert.assertSame((Object)b2.parent(), (Object)b);
        String html = String.format("<html>%n...%n</html>%n", new Object[0]);
        Files.asCharSink((File)filePath2, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)html);
        b.builderForTextAttachment().inline().textMimeSubType(TextMimeSubType.HTML).attachTextInputStream((InputStream)new FileInputStream(filePath2), StandardCharsets.UTF_8, EmailMessageAttachmentTextNewLine.UNCHANGED, IsEmptyAllowed.NO);
        Files.asCharSink((File)filePath3, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"");
        b.builderForTextAttachment().inline().textMimeSubType(TextMimeSubType.HTML).attachTextInputStream((InputStream)new FileInputStream(filePath3), StandardCharsets.UTF_8, EmailMessageAttachmentTextNewLine.UNCHANGED, IsEmptyAllowed.YES);
        _Data data = this._sendAndReceiveEmail(b);
        this._assertTextAttachment(data, 1, EmailMessageAttachmentType.ATTACHMENT, "log.txt", "text/plain; charset=UTF-8", "line 1\r\nline 2\r\nline 3\r\n");
        this._assertTextAttachment(data, 2, EmailMessageAttachmentType.INLINE, null, "text/html; charset=UTF-8", "<html>\r\n...\r\n</html>\r\n");
        this._assertTextAttachment(data, 3, EmailMessageAttachmentType.INLINE, null, "text/html; charset=UTF-8", "");
    }

    @Test
    public void EmailMessageBinaryAttachmentBuilderImp_attachMessage_Pass() throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.YES, UsernameAndPassword.NO);
        EmailMessageAddress fromEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"from@gmail.com");
        EmailMessageAddress bccEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"bcc@gmail.com");
        String subject = "sample subject";
        String bodyText = "body text";
        EmailMessageBuilder b = javaMailSession.emailMessageBuilder().subject("sample subject").body(TextMimeSubType.PLAIN, "body text").address(EmailMessageAddressType.FROM, fromEmailMessageAddress);
        b.addressSet(EmailMessageAddressListType.BCC).add(bccEmailMessageAddress);
        MimeMessage attachedMimeMessage = new MimeMessage(javaMailSession.session());
        attachedMimeMessage.setSubject("another subject");
        attachedMimeMessage.setText("body text");
        String attachedMimeMessageStr = new String(JavaMailMessageService.INSTANCE.getMimeContentAsByteArr((Message)attachedMimeMessage), StandardCharsets.UTF_8);
        String attachmentFileName = "convo.eml";
        b.builderForBinaryAttachment().attachmentFileName("convo.eml").mimeType("application/octet-stream").attachMessage((Message)attachedMimeMessage);
        MimeMessage inlineMimeMessage = new MimeMessage(javaMailSession.session());
        inlineMimeMessage.setSubject("another subject2");
        inlineMimeMessage.setText("inline body text", StandardCharsets.UTF_8.name(), "plain");
        String inlineMimeMessageStr = new String(JavaMailMessageService.INSTANCE.getMimeContentAsByteArr((Message)inlineMimeMessage), StandardCharsets.UTF_8);
        b.builderForBinaryAttachment().inline().mimeType("application/octet-stream").attachMessage((Message)inlineMimeMessage);
        _Data data = this._sendAndReceiveEmail(b);
        this._assertBinaryAttachment(data, 1, EmailMessageAttachmentType.ATTACHMENT, "convo.eml", "application/octet-stream", attachedMimeMessageStr);
        this._assertBinaryAttachment(data, 2, EmailMessageAttachmentType.INLINE, null, "application/octet-stream", inlineMimeMessageStr);
    }

    @Test
    public void EmailMessageBinaryAttachmentBuilderImp_attachBinaryFile_Pass() throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.NO, UsernameAndPassword.YES);
        EmailMessageAddress fromEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"from@gmail.com");
        EmailMessageAddress toEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"to@gmail.com");
        String subject = "sample subject";
        String bodyText = "body text";
        EmailMessageBuilder b = javaMailSession.emailMessageBuilder().subject("sample subject").body(TextMimeSubType.PLAIN, "body text").address(EmailMessageAddressType.FROM, fromEmailMessageAddress);
        b.addressSet(EmailMessageAddressListType.TO).add(toEmailMessageAddress);
        MimeMessage attachedMimeMessage = new MimeMessage(javaMailSession.session());
        attachedMimeMessage.setSubject("another subject");
        attachedMimeMessage.setText("body text");
        byte[] attachedMimeMessageByteArr = JavaMailMessageService.INSTANCE.getMimeContentAsByteArr((Message)attachedMimeMessage);
        String attachedMimeMessageStr = new String(attachedMimeMessageByteArr, StandardCharsets.UTF_8);
        File filePath = File.createTempFile("EmailMessageBinaryAttachmentBuilderImp_attachBinaryFile_Pass", ".bin");
        filePath.deleteOnExit();
        File filePath2 = File.createTempFile("EmailMessageBinaryAttachmentBuilderImp_attachBinaryFile_Pass2", ".bin");
        filePath2.deleteOnExit();
        File filePath3 = File.createTempFile("EmailMessageBinaryAttachmentBuilderImp_attachBinaryFile_Pass3", ".bin");
        filePath3.deleteOnExit();
        Files.asByteSink((File)filePath, (FileWriteMode[])new FileWriteMode[0]).write(attachedMimeMessageByteArr);
        String attachmentFileName = "convo.eml";
        EmailMessageBinaryAttachmentBuilder b2 = b.builderForBinaryAttachment().attachmentFileName("convo.eml").mimeType("application/octet-stream").attachBinaryFile(filePath, IsEmptyAllowed.NO);
        Assert.assertSame((Object)b2.parent(), (Object)b);
        MimeMessage inlineMimeMessage = new MimeMessage(javaMailSession.session());
        inlineMimeMessage.setSubject("another subject2");
        inlineMimeMessage.setText("inline body text", StandardCharsets.UTF_8.name(), "plain");
        byte[] inlineMimeMessageByteArr = JavaMailMessageService.INSTANCE.getMimeContentAsByteArr((Message)inlineMimeMessage);
        String inlineMimeMessageStr = new String(inlineMimeMessageByteArr, StandardCharsets.UTF_8);
        Files.asByteSink((File)filePath2, (FileWriteMode[])new FileWriteMode[0]).write(inlineMimeMessageByteArr);
        b.builderForBinaryAttachment().inline().mimeType("application/octet-stream").attachBinaryFile(filePath2, IsEmptyAllowed.NO);
        Files.asByteSink((File)filePath3, (FileWriteMode[])new FileWriteMode[0]).write(new byte[0]);
        b.builderForBinaryAttachment().inline().mimeType("application/octet-stream").attachBinaryFile(filePath3, IsEmptyAllowed.YES);
        _Data data = this._sendAndReceiveEmail(b);
        this._assertBinaryAttachment(data, 1, EmailMessageAttachmentType.ATTACHMENT, "convo.eml", "application/octet-stream", attachedMimeMessageStr);
        this._assertBinaryAttachment(data, 2, EmailMessageAttachmentType.INLINE, null, "application/octet-stream", inlineMimeMessageStr);
        this._assertBinaryAttachment(data, 3, EmailMessageAttachmentType.INLINE, null, "application/octet-stream", "");
    }

    @Test
    public void EmailMessageBinaryAttachmentBuilderImp_attachBinaryInputStream_Pass() throws Exception {
        JavaMailSession javaMailSession = this._createJavaMailSession(AlwaysTrustSSL.YES, UsernameAndPassword.YES);
        EmailMessageAddress fromEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"from@gmail.com");
        EmailMessageAddress toEmailMessageAddress = EmailMessageAddress.fromEmailAddressOnly((String)"to@gmail.com");
        String subject = "sample subject";
        String bodyText = "body text";
        EmailMessageBuilder b = javaMailSession.emailMessageBuilder().subject("sample subject").body(TextMimeSubType.PLAIN, "body text").address(EmailMessageAddressType.FROM, fromEmailMessageAddress);
        b.addressSet(EmailMessageAddressListType.TO).add(toEmailMessageAddress);
        MimeMessage attachedMimeMessage = new MimeMessage(javaMailSession.session());
        attachedMimeMessage.setSubject("another subject");
        attachedMimeMessage.setText("body text");
        byte[] attachedMimeMessageByteArr = JavaMailMessageService.INSTANCE.getMimeContentAsByteArr((Message)attachedMimeMessage);
        String attachedMimeMessageStr = new String(attachedMimeMessageByteArr, StandardCharsets.UTF_8);
        File filePath = File.createTempFile("EmailMessageBinaryAttachmentBuilderImp_attachBinaryInputStream_Pass", ".bin");
        filePath.deleteOnExit();
        File filePath2 = File.createTempFile("EmailMessageBinaryAttachmentBuilderImp_attachBinaryInputStream_Pass2", ".bin");
        filePath2.deleteOnExit();
        File filePath3 = File.createTempFile("EmailMessageBinaryAttachmentBuilderImp_attachBinaryInputStream_Pass3", ".bin");
        filePath3.deleteOnExit();
        Files.asByteSink((File)filePath, (FileWriteMode[])new FileWriteMode[0]).write(attachedMimeMessageByteArr);
        String attachmentFileName = "convo.eml";
        EmailMessageBinaryAttachmentBuilder b2 = b.builderForBinaryAttachment().attachmentFileName("convo.eml").mimeType("application/octet-stream").attachBinaryInputStream((InputStream)new FileInputStream(filePath), IsEmptyAllowed.NO);
        Assert.assertSame((Object)b2.parent(), (Object)b);
        MimeMessage inlineMimeMessage = new MimeMessage(javaMailSession.session());
        inlineMimeMessage.setSubject("another subject2");
        inlineMimeMessage.setText("inline body text", StandardCharsets.UTF_8.name(), "plain");
        byte[] inlineMimeMessageByteArr = JavaMailMessageService.INSTANCE.getMimeContentAsByteArr((Message)inlineMimeMessage);
        String inlineMimeMessageStr = new String(inlineMimeMessageByteArr, StandardCharsets.UTF_8);
        Files.asByteSink((File)filePath2, (FileWriteMode[])new FileWriteMode[0]).write(inlineMimeMessageByteArr);
        b.builderForBinaryAttachment().inline().mimeType("application/octet-stream").attachBinaryInputStream((InputStream)new FileInputStream(filePath2), IsEmptyAllowed.NO);
        Files.asByteSink((File)filePath3, (FileWriteMode[])new FileWriteMode[0]).write(new byte[0]);
        b.builderForBinaryAttachment().inline().mimeType("application/octet-stream").attachBinaryInputStream((InputStream)new FileInputStream(filePath3), IsEmptyAllowed.YES);
        _Data data = this._sendAndReceiveEmail(b);
        this._assertBinaryAttachment(data, 1, EmailMessageAttachmentType.ATTACHMENT, "convo.eml", "application/octet-stream", attachedMimeMessageStr);
        this._assertBinaryAttachment(data, 2, EmailMessageAttachmentType.INLINE, null, "application/octet-stream", inlineMimeMessageStr);
        this._assertBinaryAttachment(data, 3, EmailMessageAttachmentType.INLINE, null, "application/octet-stream", "");
    }

    private void _assertTextAttachment(_Data data, int bodyPartIndex, EmailMessageAttachmentType attachment, @Nullable String nullableAttachmentFileName, String mimeType, String text) throws Exception {
        MimeMultipart outMimeMultipart = (MimeMultipart)data.outMimeMessage.getContent();
        MimeMultipart inMimeMultipart = (MimeMultipart)data.inMimeMessage.getContent();
        BodyPart outTextAttachmentBodyPart = outMimeMultipart.getBodyPart(bodyPartIndex);
        BodyPart inTextAttachmentBodyPart = inMimeMultipart.getBodyPart(bodyPartIndex);
        Assert.assertEquals((String)inTextAttachmentBodyPart.getDisposition(), (String)attachment.disposition);
        Assert.assertEquals((String)inTextAttachmentBodyPart.getDisposition(), (String)outTextAttachmentBodyPart.getDisposition());
        if (null == nullableAttachmentFileName) {
            Assert.assertNull((Object)inTextAttachmentBodyPart.getFileName());
        } else {
            Assert.assertEquals((String)inTextAttachmentBodyPart.getFileName(), (String)nullableAttachmentFileName);
        }
        Assert.assertEquals((String)inTextAttachmentBodyPart.getFileName(), (String)outTextAttachmentBodyPart.getFileName());
        String contentType = mimeType + (null == nullableAttachmentFileName ? "" : "; name=" + nullableAttachmentFileName);
        Assert.assertEquals((String)inTextAttachmentBodyPart.getContentType(), (String)contentType);
        Assert.assertEquals((String)inTextAttachmentBodyPart.getContentType(), (String)outTextAttachmentBodyPart.getContentType());
        Assert.assertEquals((String)((String)inTextAttachmentBodyPart.getContent()), (String)text);
    }

    private void _assertBinaryAttachment(_Data data, int bodyPartIndex, EmailMessageAttachmentType attachment, @Nullable String nullableAttachmentFileName, String mimeType, String text) throws Exception {
        MimeMultipart outMimeMultipart = (MimeMultipart)data.outMimeMessage.getContent();
        MimeMultipart inMimeMultipart = (MimeMultipart)data.inMimeMessage.getContent();
        BodyPart outTextAttachmentBodyPart = outMimeMultipart.getBodyPart(bodyPartIndex);
        BodyPart inTextAttachmentBodyPart = inMimeMultipart.getBodyPart(bodyPartIndex);
        Assert.assertEquals((String)inTextAttachmentBodyPart.getDisposition(), (String)attachment.disposition);
        Assert.assertEquals((String)inTextAttachmentBodyPart.getDisposition(), (String)outTextAttachmentBodyPart.getDisposition());
        if (null == nullableAttachmentFileName) {
            Assert.assertNull((Object)inTextAttachmentBodyPart.getFileName());
        } else {
            Assert.assertEquals((String)inTextAttachmentBodyPart.getFileName(), (String)nullableAttachmentFileName);
        }
        Assert.assertEquals((String)inTextAttachmentBodyPart.getFileName(), (String)outTextAttachmentBodyPart.getFileName());
        String contentType = mimeType + (null == nullableAttachmentFileName ? "" : "; name=" + nullableAttachmentFileName);
        Assert.assertEquals((String)inTextAttachmentBodyPart.getContentType(), (String)contentType);
        Assert.assertEquals((String)inTextAttachmentBodyPart.getContentType(), (String)outTextAttachmentBodyPart.getContentType());
        InputStream is = (InputStream)inTextAttachmentBodyPart.getContent();
        byte[] byteArr = ByteStreams.toByteArray((InputStream)is);
        String s = new String(byteArr, StandardCharsets.UTF_8);
        Assert.assertEquals((String)s, (String)text);
    }

    private static final class _Data {
        public final MimeMessage outMimeMessage;
        public final byte[] outMimeMessageByteArr;
        public final String outMimeMessageStr;
        public final WiserMessage inWiserMessage;
        public final MimeMessage inMimeMessage;
        public final byte[] inMimeMessageByteArr;
        public final String inMimeMessageStr;

        private _Data(MimeMessage outMimeMessage, WiserMessage inWiserMessage) throws Exception {
            this.outMimeMessage = (MimeMessage)ObjectArgs.checkNotNull((Object)outMimeMessage, (String)"outMimeMessage");
            this.outMimeMessageByteArr = JavaMailMessageService.INSTANCE.getMimeContentAsByteArr((Message)outMimeMessage);
            this.outMimeMessageStr = new String(this.outMimeMessageByteArr, StandardCharsets.UTF_8);
            this.inWiserMessage = (WiserMessage)ObjectArgs.checkNotNull((Object)inWiserMessage, (String)"inWiserMessage");
            this.inMimeMessageByteArr = inWiserMessage.getData();
            this.inMimeMessageStr = new String(this.inMimeMessageByteArr, StandardCharsets.UTF_8);
            this.inMimeMessage = JavaMailMessageService.INSTANCE.createMimeMessageFromByteArr(outMimeMessage.getSession(), this.inMimeMessageByteArr);
        }
    }

    private static enum UsernameAndPassword {
        YES,
        NO;

    }
}

