/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.StringArgs;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBuilderImp;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.mail.internet.InternetAddress;

@FullyTested
public final class EmailMessageAddress {
    public final String emailAddress;
    @Nullable
    public final String nullableDisplayName;

    public static EmailMessageAddress fromEmailAddressOnly(String emailAddress) {
        String nullableDisplayName = null;
        EmailMessageAddress x = new EmailMessageAddress(emailAddress, nullableDisplayName);
        return x;
    }

    public static EmailMessageAddress fromEmailAddressAndDisplayName(String emailAddress, String displayName) {
        EmailMessageAddress x = new EmailMessageAddress(emailAddress, displayName);
        return x;
    }

    private EmailMessageAddress(String emailAddress, @Nullable String nullableDisplayName) {
        this.emailAddress = (String)StringArgs.checkNotEmptyOrWhitespace((CharSequence)emailAddress, (String)"emailAddress");
        if (null != nullableDisplayName) {
            StringArgs.checkNotEmptyOrWhitespace((CharSequence)nullableDisplayName, (String)"nullableDisplayName");
        }
        this.nullableDisplayName = nullableDisplayName;
    }

    public InternetAddress createInternetAddress() throws Exception {
        InternetAddress x = new InternetAddress(this.emailAddress, this.nullableDisplayName, EmailMessageBuilderImp.DEFAULT_CHARSET.name());
        return x;
    }

    public int hashCode() {
        int x = Objects.hash(this.emailAddress, this.nullableDisplayName);
        return x;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().isInstance(obj)) {
            return false;
        }
        EmailMessageAddress other = (EmailMessageAddress)this.getClass().cast(obj);
        boolean x = this.emailAddress.equals(other.emailAddress) && Objects.equals(this.nullableDisplayName, other.nullableDisplayName);
        return x;
    }

    public String toString() {
        if (null == this.nullableDisplayName) {
            return this.emailAddress;
        }
        String x = this.nullableDisplayName + " <" + this.emailAddress + ">";
        return x;
    }
}

