/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.googlecode.kevinarpe.papaya.annotation.EmptyContainerAllowed;
import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

@FullyTested
public enum EmailMessageAddressListType {
    REPLY_TO{

        @Override
        public void setValue(MimeMessage m, @Nullable @EmptyContainerAllowed InternetAddress[] addrArr) throws Exception {
            m.setReplyTo((Address[])addrArr);
        }
    }
    ,
    TO(Message.RecipientType.TO){

        @Override
        public void setValue(MimeMessage m, @Nullable @EmptyContainerAllowed InternetAddress[] addrArr) throws Exception {
            m.setRecipients(Message.RecipientType.TO, (Address[])addrArr);
        }
    }
    ,
    CC(Message.RecipientType.CC){

        @Override
        public void setValue(MimeMessage m, @Nullable @EmptyContainerAllowed InternetAddress[] addrArr) throws Exception {
            m.setRecipients(Message.RecipientType.CC, (Address[])addrArr);
        }
    }
    ,
    BCC(Message.RecipientType.BCC){

        @Override
        public void setValue(MimeMessage m, @Nullable @EmptyContainerAllowed InternetAddress[] addrArr) throws Exception {
            m.setRecipients(Message.RecipientType.BCC, (Address[])addrArr);
        }
    };

    @Nullable
    public final Message.RecipientType nullableRecipientType;

    private EmailMessageAddressListType(Message.RecipientType recipientType) {
        this.nullableRecipientType = (Message.RecipientType)ObjectArgs.checkNotNull((Object)recipientType, (String)"recipientType");
    }

    private EmailMessageAddressListType() {
        this.nullableRecipientType = null;
    }

    public abstract void setValue(MimeMessage var1, @Nullable @EmptyContainerAllowed InternetAddress[] var2) throws Exception;
}

