/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.googlecode.kevinarpe.papaya.annotation.EmptyContainerAllowed;
import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ArrayArgs;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.argument.StringArgs;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAttachmentType;
import com.googlecode.kevinarpe.papaya.java_mail.IsEmptyAllowed;
import javax.annotation.Nullable;

@FullyTested
public final class EmailMessageAttachment {
    public final EmailMessageAttachmentType attachmentType;
    @Nullable
    public String nullableFileName;
    public final String mimeType;
    @EmptyContainerAllowed
    public final byte[] byteArr;

    public EmailMessageAttachment(EmailMessageAttachmentType attachmentType, @Nullable String nullableFileName, String mimeType, @EmptyContainerAllowed byte[] byteArr, IsEmptyAllowed isEmptyAllowed) {
        EmailMessageAttachment._checkAttachmentTypeAndFileName(attachmentType, nullableFileName);
        this.attachmentType = attachmentType;
        this.nullableFileName = nullableFileName;
        this.mimeType = (String)StringArgs.checkNotEmptyOrWhitespace((CharSequence)mimeType, (String)"mimeType");
        ObjectArgs.checkNotNull((Object)((Object)isEmptyAllowed), (String)"isEmptyAllowed");
        if (IsEmptyAllowed.NO.equals((Object)isEmptyAllowed)) {
            ArrayArgs.checkNotEmpty((byte[])byteArr, (String)"byteArr");
        }
        this.byteArr = (byte[])ObjectArgs.checkNotNull((Object)byteArr, (String)"byteArr");
    }

    private static void _checkAttachmentTypeAndFileName(EmailMessageAttachmentType attachmentType, @Nullable String nullableFileName) {
        ObjectArgs.checkNotNull((Object)((Object)attachmentType), (String)"attachmentType");
        switch (attachmentType) {
            case ATTACHMENT: {
                StringArgs.checkNotEmptyOrWhitespace((CharSequence)nullableFileName, (String)"nullableFileName");
                break;
            }
            case INLINE: {
                ObjectArgs.checkIsNull((Object)nullableFileName, (String)"nullableFileName");
                break;
            }
            default: {
                throw new IllegalStateException("Internal error: Missing switch case for " + ((Object)((Object)attachmentType)).getClass().getSimpleName() + "." + attachmentType.name());
            }
        }
    }
}

