/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.google.common.io.ByteStreams;
import com.googlecode.kevinarpe.papaya.annotation.EmptyContainerAllowed;
import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.argument.StringArgs;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAttachment;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAttachmentType;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBinaryAttachmentBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.IsEmptyAllowed;
import com.googlecode.kevinarpe.papaya.java_mail.JavaMailMessageService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.mail.Message;

@FullyTested
public final class EmailMessageBinaryAttachmentBuilderImp
implements EmailMessageBinaryAttachmentBuilder {
    private final EmailMessageBuilder parentBuilder;
    private final JavaMailMessageService javaMailMessageService;
    @Nullable
    private EmailMessageAttachmentType nullableAttachmentType;
    @Nullable
    private String nullableFileName;
    @Nullable
    private String nullableMimeType;

    public EmailMessageBinaryAttachmentBuilderImp(EmailMessageBuilder parentBuilder) {
        this(parentBuilder, JavaMailMessageService.INSTANCE);
    }

    EmailMessageBinaryAttachmentBuilderImp(EmailMessageBuilder parentBuilder, JavaMailMessageService javaMailMessageService) {
        this.parentBuilder = (EmailMessageBuilder)ObjectArgs.checkNotNull((Object)parentBuilder, (String)"parentBuilder");
        this.javaMailMessageService = (JavaMailMessageService)ObjectArgs.checkNotNull((Object)javaMailMessageService, (String)"javaMailMessageService");
        this.nullableAttachmentType = null;
        this.nullableFileName = null;
        this.nullableMimeType = null;
    }

    @Override
    public EmailMessageBuilder parent() {
        return this.parentBuilder;
    }

    @Override
    public EmailMessageBinaryAttachmentBuilder attachmentFileName(String attachmentFileName) {
        this.nullableAttachmentType = EmailMessageAttachmentType.ATTACHMENT;
        this.nullableFileName = (String)StringArgs.checkNotEmptyOrWhitespace((CharSequence)attachmentFileName, (String)"attachmentFileName");
        return this;
    }

    @Override
    public EmailMessageBinaryAttachmentBuilder inline() {
        this.nullableAttachmentType = EmailMessageAttachmentType.INLINE;
        this.nullableFileName = null;
        return this;
    }

    @Override
    public EmailMessageBinaryAttachmentBuilder mimeType(String mimeType) {
        this.nullableMimeType = (String)StringArgs.checkNotEmptyOrWhitespace((CharSequence)mimeType, (String)"mimeType");
        return this;
    }

    @Override
    public EmailMessageBinaryAttachmentBuilder attachMessage(Message message) throws Exception {
        byte[] byteArr = this.javaMailMessageService.getMimeContentAsByteArr(message);
        this._attachBinaryData(byteArr, IsEmptyAllowed.NO);
        return this;
    }

    @Override
    public EmailMessageBinaryAttachmentBuilder attachBinaryFile(File filePath, IsEmptyAllowed isEmptyAllowed) throws Exception {
        FileInputStream fis = new FileInputStream(filePath);
        byte[] byteArr = ByteStreams.toByteArray((InputStream)fis);
        fis.close();
        this._attachBinaryData(byteArr, isEmptyAllowed);
        return this;
    }

    @Override
    public EmailMessageBinaryAttachmentBuilder attachBinaryInputStream(InputStream inputStream, IsEmptyAllowed isEmptyAllowed) throws Exception {
        byte[] byteArr = ByteStreams.toByteArray((InputStream)inputStream);
        inputStream.close();
        this._attachBinaryData(byteArr, isEmptyAllowed);
        return this;
    }

    @Override
    public EmailMessageBinaryAttachmentBuilder attachBinaryData(@EmptyContainerAllowed byte[] byteArr, IsEmptyAllowed isEmptyAllowed) {
        this._attachBinaryData(byteArr, isEmptyAllowed);
        return this;
    }

    private void _attachBinaryData(@EmptyContainerAllowed byte[] byteArr, IsEmptyAllowed isEmptyAllowed) {
        EmailMessageAttachment a = new EmailMessageAttachment(this.nullableAttachmentType, this.nullableFileName, this.nullableMimeType, byteArr, isEmptyAllowed);
        ArrayList<EmailMessageAttachment> attachmentList = this.parentBuilder.attachmentList();
        attachmentList.add(a);
    }
}

