/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.google.common.collect.LinkedHashMultimap;
import com.googlecode.kevinarpe.papaya.annotation.EmptyContainerAllowed;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.argument.StringArgs;
import com.googlecode.kevinarpe.papaya.container.AreNullValuesAllowed;
import com.googlecode.kevinarpe.papaya.container.FullEnumMap;
import com.googlecode.kevinarpe.papaya.container.ImmutableFullEnumMap;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAddress;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAddressListType;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAddressType;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageAttachment;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBinaryAttachmentBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBinaryAttachmentBuilderFactory;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageTextAttachmentBuilder;
import com.googlecode.kevinarpe.papaya.java_mail.EmailMessageTextAttachmentBuilderFactory;
import com.googlecode.kevinarpe.papaya.java_mail.JavaMailSession;
import com.googlecode.kevinarpe.papaya.java_mail.TextMimeSubType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.Nullable;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public final class EmailMessageBuilderImp
implements EmailMessageBuilder {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final JavaMailSession javaMailSession;
    private final EmailMessageTextAttachmentBuilderFactory textAttachmentBuilderFactory;
    private final EmailMessageBinaryAttachmentBuilderFactory binaryAttachmentBuilderFactory;
    private Charset charset;
    private final FullEnumMap<EmailMessageAddressType, Optional<EmailMessageAddress>> addressTypeMap;
    private final ImmutableFullEnumMap<EmailMessageAddressListType, LinkedHashSet<EmailMessageAddress>> addressListTypeMap;
    @Nullable
    @EmptyContainerAllowed
    private LinkedHashMultimap<String, String> nullableHeaderLinkedHashMultimap;
    @Nullable
    private String nullableSubject;
    @Nullable
    private TextMimeSubType nullableBodyTextMimeSubType;
    @Nullable
    private String nullableBodyText;
    @Nullable
    @EmptyContainerAllowed
    private ArrayList<EmailMessageAttachment> nullableAttachmentList;

    public EmailMessageBuilderImp(JavaMailSession javaMailSession) {
        this(javaMailSession, EmailMessageTextAttachmentBuilderFactory.INSTANCE, EmailMessageBinaryAttachmentBuilderFactory.INSTANCE);
    }

    EmailMessageBuilderImp(JavaMailSession javaMailSession, EmailMessageTextAttachmentBuilderFactory textAttachmentBuilderFactory, EmailMessageBinaryAttachmentBuilderFactory binaryAttachmentBuilderFactory) {
        this.javaMailSession = (JavaMailSession)ObjectArgs.checkNotNull((Object)javaMailSession, (String)"javaMailSession");
        this.textAttachmentBuilderFactory = (EmailMessageTextAttachmentBuilderFactory)ObjectArgs.checkNotNull((Object)textAttachmentBuilderFactory, (String)"textAttachmentBuilderFactory");
        this.binaryAttachmentBuilderFactory = (EmailMessageBinaryAttachmentBuilderFactory)ObjectArgs.checkNotNull((Object)binaryAttachmentBuilderFactory, (String)"binaryAttachmentBuilderFactory");
        this.charset = DEFAULT_CHARSET;
        this.addressTypeMap = FullEnumMap.ofKeys(EmailMessageAddressType.class, (AreNullValuesAllowed)AreNullValuesAllowed.NO, any -> Optional.empty());
        this.addressListTypeMap = ImmutableFullEnumMap.ofKeys(EmailMessageAddressListType.class, any -> new LinkedHashSet());
        this.nullableHeaderLinkedHashMultimap = null;
        this.nullableSubject = null;
        this.nullableBodyTextMimeSubType = null;
        this.nullableBodyText = null;
        this.nullableAttachmentList = null;
    }

    @Override
    public JavaMailSession javaMailSession() {
        return this.javaMailSession;
    }

    @Override
    public EmailMessageBuilder address(EmailMessageAddressType addressType, @Nullable EmailMessageAddress nullableAddress) {
        this.addressTypeMap.put((Object)addressType, Optional.ofNullable(nullableAddress));
        return this;
    }

    @Override
    @EmptyContainerAllowed
    public LinkedHashSet<EmailMessageAddress> addressSet(EmailMessageAddressListType addressListType) {
        LinkedHashSet x = (LinkedHashSet)this.addressListTypeMap.getByEnum((Enum)addressListType);
        return x;
    }

    @Override
    @EmptyContainerAllowed
    public LinkedHashMultimap<String, String> headers() {
        if (null == this.nullableHeaderLinkedHashMultimap) {
            this.nullableHeaderLinkedHashMultimap = LinkedHashMultimap.create();
        }
        return this.nullableHeaderLinkedHashMultimap;
    }

    @Override
    public EmailMessageBuilder subject(String subject) {
        this.nullableSubject = (String)StringArgs.checkNotEmptyOrWhitespace((CharSequence)subject, (String)"subject");
        return this;
    }

    @Override
    public EmailMessageBuilder body(TextMimeSubType textMimeSubType, String text) {
        this.nullableBodyTextMimeSubType = (TextMimeSubType)((Object)ObjectArgs.checkNotNull((Object)((Object)textMimeSubType), (String)"textMimeType"));
        this.nullableBodyText = (String)StringArgs.checkNotEmptyOrWhitespace((CharSequence)text, (String)"text");
        return this;
    }

    @Override
    public EmailMessageTextAttachmentBuilder builderForTextAttachment() {
        EmailMessageTextAttachmentBuilder x = this.textAttachmentBuilderFactory.newInstance(this);
        return x;
    }

    @Override
    public EmailMessageBinaryAttachmentBuilder builderForBinaryAttachment() {
        EmailMessageBinaryAttachmentBuilder x = this.binaryAttachmentBuilderFactory.newInstance(this);
        return x;
    }

    @Override
    @EmptyContainerAllowed
    public ArrayList<EmailMessageAttachment> attachmentList() {
        if (null == this.nullableAttachmentList) {
            this.nullableAttachmentList = new ArrayList();
        }
        return this.nullableAttachmentList;
    }

    @Override
    public MimeMessage build() throws Exception {
        Session session = this.javaMailSession.session();
        MimeMessage m = new MimeMessage(session);
        this._setAddresses(m);
        this._setAddresses2(m);
        this._setHeaders(m);
        this._setSubject(m);
        MimeMultipart mimeMultipart = new MimeMultipart();
        this._setBody(mimeMultipart);
        this._addAttachments(mimeMultipart);
        m.setContent((Multipart)mimeMultipart);
        return m;
    }

    private void _setAddresses(MimeMessage m) throws Exception {
        this._assertHasRequiredAddress();
        for (EmailMessageAddressType addressType : EmailMessageAddressType.values()) {
            Optional optionalAddress = (Optional)this.addressTypeMap.getByEnum((Enum)addressType);
            if (!optionalAddress.isPresent()) continue;
            EmailMessageAddress addr = (EmailMessageAddress)optionalAddress.get();
            InternetAddress inetAddr = addr.createInternetAddress();
            addressType.setValue(m, inetAddr);
        }
    }

    private void _assertHasRequiredAddress() {
        for (EmailMessageAddressType addressType : EmailMessageAddressType.values()) {
            Optional optionalAddress;
            if (!addressType.isRequired || (optionalAddress = (Optional)this.addressTypeMap.getByEnum((Enum)addressType)).isPresent()) continue;
            throw new IllegalStateException("Missing " + EmailMessageAddressType.class.getSimpleName() + "." + addressType.name());
        }
    }

    private void _setAddresses2(MimeMessage m) throws Exception {
        this._assertRecipientExists();
        for (EmailMessageAddressListType addressListType : EmailMessageAddressListType.values()) {
            LinkedHashSet set = (LinkedHashSet)this.addressListTypeMap.getByEnum((Enum)addressListType);
            if (set.size() <= 0) continue;
            InternetAddress[] inetAddrArr = this._toInetAddrArr(set);
            addressListType.setValue(m, inetAddrArr);
        }
    }

    private void _assertRecipientExists() {
        for (EmailMessageAddressListType addressListType : EmailMessageAddressListType.values()) {
            LinkedHashSet addressSet;
            if (null == addressListType.nullableRecipientType || (addressSet = (LinkedHashSet)this.addressListTypeMap.getByEnum((Enum)addressListType)).size() <= 0) continue;
            return;
        }
        throw new IllegalStateException("Failed to find any recipient addresses (To:, Cc:, Bcc:)");
    }

    private InternetAddress[] _toInetAddrArr(LinkedHashSet<EmailMessageAddress> set) throws Exception {
        InternetAddress[] inetAddrArr = new InternetAddress[set.size()];
        int i = 0;
        for (EmailMessageAddress addr : set) {
            InternetAddress inetAddr;
            inetAddrArr[i] = inetAddr = addr.createInternetAddress();
            ++i;
        }
        return inetAddrArr;
    }

    private void _setSubject(MimeMessage m) throws Exception {
        if (null == this.nullableSubject) {
            throw new IllegalStateException("Missing subject");
        }
        m.setSubject(this.nullableSubject, this.charset.name());
    }

    private void _setHeaders(MimeMessage m) throws Exception {
        if (null == this.nullableHeaderLinkedHashMultimap || this.nullableHeaderLinkedHashMultimap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.nullableHeaderLinkedHashMultimap.entries()) {
            m.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void _setBody(MimeMultipart mimeMultipart) throws Exception {
        if (null == this.nullableBodyTextMimeSubType || null == this.nullableBodyText) {
            throw new IllegalStateException("Missing body text");
        }
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(this.nullableBodyText, this.charset.name(), this.nullableBodyTextMimeSubType.textMimeSubType);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
    }

    private void _addAttachments(MimeMultipart mimeMultipart) throws Exception {
        if (null == this.nullableAttachmentList || this.nullableAttachmentList.isEmpty()) {
            return;
        }
        for (EmailMessageAttachment attachment : this.nullableAttachmentList) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDisposition(attachment.attachmentType.disposition);
            if (null != attachment.nullableFileName) {
                mimeBodyPart.setFileName(attachment.nullableFileName);
            }
            ByteArrayDataSource ds = new ByteArrayDataSource(attachment.byteArr, attachment.mimeType);
            DataHandler dh = new DataHandler((DataSource)ds);
            mimeBodyPart.setDataHandler(dh);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        }
    }
}

