/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.java_mail;

import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ArrayArgs;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.java_mail.JavaMailMessageService;
import com.sun.mail.smtp.SMTPOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

@FullyTested
public final class JavaMailMessageServiceImp
implements JavaMailMessageService {
    @Override
    public byte[] getMimeContentAsByteArr(Message message) throws Exception {
        ObjectArgs.checkNotNull((Object)message, (String)"message");
        ByteArrayOutputStream baos = JavaMailMessageServiceImp._createByteArrayOutputStream(message);
        SMTPOutputStream smtpOutputStream = new SMTPOutputStream((OutputStream)baos);
        message.writeTo((OutputStream)smtpOutputStream);
        smtpOutputStream.close();
        byte[] x = baos.toByteArray();
        return x;
    }

    private static ByteArrayOutputStream _createByteArrayOutputStream(Message message) throws Exception {
        int size = message.getSize();
        if (size > 0) {
            ByteArrayOutputStream x = new ByteArrayOutputStream(size);
            return x;
        }
        ByteArrayOutputStream x = new ByteArrayOutputStream();
        return x;
    }

    @Override
    public MimeMessage createMimeMessageFromByteArr(Session session, byte[] byteArr) throws Exception {
        ArrayArgs.checkNotEmpty((byte[])byteArr, (String)"byteArr");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArr);
        MimeMessage x = new MimeMessage(session, (InputStream)byteArrayInputStream);
        return x;
    }
}

