/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.jdk.properties;

import com.google.common.testing.EqualsTester;
import com.googlecode.kevinarpe.papaya.jdk.properties.JdkProperty;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class JdkPropertyTest {
    private void _assertKeyAndValue(JdkProperty classUnderTest, String key, String value) {
        Assert.assertEquals((String)classUnderTest.getKey(), (String)key);
        Assert.assertEquals((String)classUnderTest.getValue(), (String)value);
    }

    @Test
    public void ctor_Pass() {
        this._assertKeyAndValue(new JdkProperty("abc", "def"), "abc", "def");
        this._assertKeyAndValue(new JdkProperty(null, null), null, null);
    }

    @DataProvider
    private static Object[][] _setKeyOrValue_Pass_Data() {
        return new Object[][]{{"abc", "def", "ghi"}, {"abc", null, "ghi"}, {null, "def", "ghi"}, {"abc", "abc", "ghi"}, {"abc", "def", null}, {"abc", null, null}, {null, "def", null}, {"abc", "abc", null}};
    }

    @Test(dataProvider="_setKeyOrValue_Pass_Data")
    public void setKey_Pass(String key1, String key2, String value) {
        JdkProperty classUnderTest = new JdkProperty(key1, value);
        this._assertKeyAndValue(classUnderTest, key1, value);
        classUnderTest.setKey(key2);
        this._assertKeyAndValue(classUnderTest, key2, value);
    }

    @Test(dataProvider="_setKeyOrValue_Pass_Data")
    public void setValue_Pass(String key, String value1, String value2) {
        JdkProperty classUnderTest = new JdkProperty(key, value1);
        this._assertKeyAndValue(classUnderTest, key, value1);
        classUnderTest.setValue(value2);
        this._assertKeyAndValue(classUnderTest, key, value2);
    }

    @Test
    public void hashCodeAndEquals_Pass() {
        EqualsTester equalsTester = new EqualsTester();
        equalsTester.addEqualityGroup(new Object[]{new JdkProperty("abc", "def"), new JdkProperty("abc", "def")});
        equalsTester.addEqualityGroup(new Object[]{new JdkProperty("abc", "ghi"), new JdkProperty("abc", "ghi")});
        equalsTester.addEqualityGroup(new Object[]{new JdkProperty("ghi", "def"), new JdkProperty("ghi", "def")});
        equalsTester.addEqualityGroup(new Object[]{new JdkProperty(null, null), new JdkProperty(null, null)});
        equalsTester.testEquals();
    }
}

