/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.argument;

import com.googlecode.kevinarpe.papaya.argument.DateTimeArgs;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DateTimeArgsTest {
    @DataProvider
    public static Object[][] checkValueInsideRange_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt.minusDays(2), dt.plusDays(1)}, {dt, dt.minusDays(2), dt}, {dt, dt.minusDays(1), dt}, {dt, dt.minusDays(1), dt.plusDays(1)}, {dt, dt, dt}, {dt, dt, dt.plusDays(1)}};
    }

    @Test(dataProvider="checkValueInsideRange_Pass_Data")
    public void checkValueInsideRange_Pass(DateTime dt, DateTime minValue, DateTime maxValue) {
        Assert.assertTrue((dt == DateTimeArgs.checkValueInsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, (String)"dt") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkValueInsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkValueInsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkValueInsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, (String)"   ") ? 1 : 0) != 0);
    }

    @DataProvider
    public static Object[][] checkValueRange_FailWithNulls_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{null, dt, dt}, {dt, null, dt}, {dt, dt, null}, {null, null, dt}, {null, dt, null}, {dt, null, null}, {null, null, null}};
    }

    @Test(dataProvider="checkValueRange_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkValueInsideRange_FailWithNulls(DateTime dt, DateTime minValue, DateTime maxValue) {
        DateTimeArgs.checkValueInsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, (String)"dt");
    }

    @DataProvider
    public static Object[][] checkValueInsideRange_FailWithInvalidInput_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt.minusDays(2), dt.minusDays(1)}, {dt, dt.minusDays(1), dt.minusDays(1)}, {dt, dt.plusDays(1), dt.plusDays(1)}, {dt, dt.plusDays(1), dt}, {dt, dt.minusDays(2), dt.minusDays(3)}, {dt, dt.minusDays(3), dt.minusDays(2)}, {dt.minusDays(2), dt, dt.minusDays(1)}, {dt.minusDays(2), dt.minusDays(1), dt.minusDays(1)}, {dt.minusDays(2), dt.minusDays(3), dt.minusDays(3)}, {dt.minusDays(2), dt.minusDays(2), dt.minusDays(3)}, {dt.minusDays(2), dt, dt.plusDays(1)}, {dt.minusDays(2), dt.plusDays(1), dt}};
    }

    @Test(dataProvider="checkValueInsideRange_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkValueInsideRange_FailWithInvalidInput(DateTime dt, DateTime minValue, DateTime maxValue) {
        DateTimeArgs.checkValueInsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, (String)"dt");
    }

    @DataProvider
    public static Object[][] checkValueOutsideRange_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt.minusDays(2), dt.minusDays(1)}, {dt, dt.minusDays(1), dt.minusDays(1)}, {dt, dt.plusDays(1), dt.plusDays(1)}, {dt, dt.minusDays(3), dt.minusDays(2)}};
    }

    @Test(dataProvider="checkValueOutsideRange_Pass_Data")
    public void checkValueOutsideRange_Pass(DateTime dt, DateTime minValue, DateTime maxValue) {
        Assert.assertTrue((dt == DateTimeArgs.checkValueOutsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, (String)"dt") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkValueOutsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkValueOutsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkValueOutsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValueRange_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkValueOutsideRange_FailWithNulls(DateTime dt, DateTime minValue, DateTime maxValue) {
        DateTimeArgs.checkValueOutsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, (String)"dt");
    }

    @DataProvider
    public static Object[][] checkValueOutsideRange_FailWithInvalidInput_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt.minusDays(2), dt.plusDays(1)}, {dt, dt.minusDays(2), dt}, {dt, dt.minusDays(1), dt}, {dt, dt.minusDays(1), dt.plusDays(1)}, {dt, dt, dt}, {dt, dt, dt.plusDays(1)}, {dt.minusDays(2), dt, dt.minusDays(1)}, {dt.minusDays(2), dt.minusDays(2), dt.minusDays(3)}, {dt.minusDays(2), dt.plusDays(1), dt}};
    }

    @Test(dataProvider="checkValueOutsideRange_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkValueOutsideRange_FailWithInvalidInput(DateTime dt, DateTime minValue, DateTime maxValue) {
        DateTimeArgs.checkValueOutsideRange((DateTime)dt, (DateTime)minValue, (DateTime)maxValue, (String)"dt");
    }

    @DataProvider
    public static Object[][] checkMinValue_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt.minusDays(2)}, {dt, dt.minusDays(1)}, {dt, dt}, {dt.minusDays(2), dt.minusDays(2)}, {dt.minusDays(2), dt.minusDays(3)}, {dt.minusDays(2), dt.minusDays(4)}};
    }

    @Test(dataProvider="checkMinValue_Pass_Data")
    public void checkMinValue_Pass(DateTime dt, DateTime minValue) {
        Assert.assertTrue((dt == DateTimeArgs.checkMinValue((DateTime)dt, (DateTime)minValue, (String)"dt") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkMinValue((DateTime)dt, (DateTime)minValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkMinValue((DateTime)dt, (DateTime)minValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkMinValue((DateTime)dt, (DateTime)minValue, (String)"   ") ? 1 : 0) != 0);
    }

    @DataProvider
    public static Object[][] checkValue_FailWithNulls_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{null, dt}, {dt, null}, {null, null}};
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkMinValue_FailWithNulls(DateTime dt, DateTime minValue) {
        DateTimeArgs.checkMinValue((DateTime)dt, (DateTime)minValue, (String)"dt");
    }

    @DataProvider
    public static Object[][] checkMinValue_FailWithInvalidInput_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt.plusDays(1)}, {dt, dt.plusDays(2)}, {dt.minusDays(2), dt.minusDays(1)}, {dt.minusDays(2), dt}};
    }

    @Test(dataProvider="checkMinValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkMinValue_FailWithInvalidInput(DateTime dt, DateTime minValue) {
        DateTimeArgs.checkMinValue((DateTime)dt, (DateTime)minValue, (String)"dt");
    }

    @DataProvider
    public static Object[][] checkMaxValue_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt}, {dt, dt.plusDays(1)}, {dt, dt.plusDays(2)}, {dt.minusDays(2), dt.minusDays(2)}, {dt.minusDays(2), dt.minusDays(1)}, {dt.minusDays(2), dt}};
    }

    @Test(dataProvider="checkMaxValue_Pass_Data")
    public void checkMaxValue_Pass(DateTime dt, DateTime maxValue) {
        Assert.assertTrue((dt == DateTimeArgs.checkMaxValue((DateTime)dt, (DateTime)maxValue, (String)"dt") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkMaxValue((DateTime)dt, (DateTime)maxValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkMaxValue((DateTime)dt, (DateTime)maxValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkMaxValue((DateTime)dt, (DateTime)maxValue, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkMaxValue_FailWithNulls(DateTime dt, DateTime maxValue) {
        DateTimeArgs.checkMaxValue((DateTime)dt, (DateTime)maxValue, (String)"dt");
    }

    @DataProvider
    public static Object[][] checkMaxValue_FailWithInvalidInput_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt.minusDays(1)}, {dt, dt.minusDays(2)}, {dt.minusDays(2), dt.minusDays(3)}, {dt.minusDays(2), dt.minusDays(4)}};
    }

    @Test(dataProvider="checkMaxValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkMaxValue_FailWithInvalidInput(DateTime dt, DateTime maxValue) {
        DateTimeArgs.checkMaxValue((DateTime)dt, (DateTime)maxValue, (String)"dt");
    }

    @DataProvider
    public static Object[][] checkExactValue_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt}, {dt.minusDays(1), dt.minusDays(1)}, {dt.minusDays(2), dt.minusDays(2)}};
    }

    @Test(dataProvider="checkExactValue_Pass_Data")
    public void checkExactValue_Pass(DateTime dt, DateTime value) {
        Assert.assertTrue((dt == DateTimeArgs.checkExactValue((DateTime)dt, (DateTime)value, (String)"dt") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkExactValue((DateTime)dt, (DateTime)value, null) ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkExactValue((DateTime)dt, (DateTime)value, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkExactValue((DateTime)dt, (DateTime)value, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkExactValue_FailWithNulls(DateTime dt, DateTime value) {
        DateTimeArgs.checkExactValue((DateTime)dt, (DateTime)value, (String)"dt");
    }

    @DataProvider
    public static Object[][] checkExactValue_FailWithInvalidInput_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt.minusDays(1)}, {dt, dt.minusDays(2)}, {dt.minusDays(2), dt.minusDays(3)}, {dt.minusDays(2), dt.minusDays(4)}};
    }

    @Test(dataProvider="checkExactValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkExactValue_FailWithInvalidInput(DateTime dt, DateTime value) {
        DateTimeArgs.checkExactValue((DateTime)dt, (DateTime)value, (String)"dt");
    }

    @DataProvider
    public static Object[][] checkNotExactValue_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt.minusDays(1)}, {dt, dt.minusDays(2)}, {dt.minusDays(2), dt.minusDays(3)}, {dt.minusDays(2), dt.minusDays(4)}};
    }

    @Test(dataProvider="checkNotExactValue_Pass_Data")
    public void checkNotExactValue_Pass(DateTime dt, DateTime value) {
        Assert.assertTrue((dt == DateTimeArgs.checkNotExactValue((DateTime)dt, (DateTime)value, (String)"dt") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkNotExactValue((DateTime)dt, (DateTime)value, null) ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkNotExactValue((DateTime)dt, (DateTime)value, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dt == DateTimeArgs.checkNotExactValue((DateTime)dt, (DateTime)value, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkNotExactValue_FailWithNulls(DateTime dt, DateTime value) {
        DateTimeArgs.checkNotExactValue((DateTime)dt, (DateTime)value, (String)"dt");
    }

    @DataProvider
    public static Object[][] checkNotExactValue_FailWithInvalidInput_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{dt, dt}, {dt.minusDays(1), dt.minusDays(1)}, {dt.minusDays(2), dt.minusDays(2)}};
    }

    @Test(dataProvider="checkNotExactValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkNotExactValue_FailWithInvalidInput(DateTime dt, DateTime value) {
        DateTimeArgs.checkNotExactValue((DateTime)dt, (DateTime)value, (String)"dt");
    }
}

