/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.argument;

import com.googlecode.kevinarpe.papaya.argument.DateTimeArrayArgs;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DateTimeArrayArgsTest {
    @DataProvider
    public static Object[][] checkValueInsideRange_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{new DateTime[]{dt}, dt.minusDays(2), dt.plusDays(1)}, {new DateTime[]{dt}, dt.minusDays(2), dt}, {new DateTime[]{dt}, dt.minusDays(1), dt}, {new DateTime[]{dt}, dt.minusDays(1), dt.plusDays(1)}, {new DateTime[]{dt}, dt, dt}, {new DateTime[]{dt}, dt, dt.plusDays(1)}};
    }

    @Test(dataProvider="checkValueInsideRange_Pass_Data")
    public void checkValueInsideRange_Pass(DateTime[] dtArr, DateTime minValue, DateTime maxValue) {
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkValueInsideRange((DateTime[])dtArr, (DateTime)minValue, (DateTime)maxValue, (String)"dtArr") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkValueInsideRange((DateTime[])dtArr, (DateTime)minValue, (DateTime)maxValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkValueInsideRange((DateTime[])dtArr, (DateTime)minValue, (DateTime)maxValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkValueInsideRange((DateTime[])dtArr, (DateTime)minValue, (DateTime)maxValue, (String)"   ") ? 1 : 0) != 0);
    }

    @DataProvider
    public static Object[][] checkValueRange_FailWithNulls_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{null, dt, dt}, {new DateTime[]{null}, dt, dt}, {new DateTime[]{null, dt}, dt, dt}, {new DateTime[]{dt, null}, dt, dt}, {new DateTime[]{dt}, null, dt}, {new DateTime[]{dt}, dt, null}, {null, null, dt}, {new DateTime[]{null}, null, dt}, {new DateTime[]{null, dt}, null, dt}, {new DateTime[]{dt, null}, null, dt}, {null, dt, null}, {new DateTime[]{null}, dt, null}, {new DateTime[]{null, dt}, dt, null}, {new DateTime[]{dt, null}, dt, null}, {new DateTime[]{dt}, null, null}, {null, null, null}, {new DateTime[]{null}, null, null}, {new DateTime[]{null, dt}, null, null}, {new DateTime[]{dt, null}, null, null}};
    }

    @Test(dataProvider="checkValueRange_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkValueInsideRange_FailWithNulls(DateTime[] dtArr, DateTime minValue, DateTime maxValue) {
        DateTimeArrayArgs.checkValueInsideRange((DateTime[])dtArr, (DateTime)minValue, (DateTime)maxValue, (String)"dtArr");
    }

    @DataProvider
    public static Object[][] checkValueInsideRange_FailWithInvalidInput_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{new DateTime[]{dt}, dt.minusDays(2), dt.minusDays(1)}, {new DateTime[]{dt}, dt.minusDays(1), dt.minusDays(1)}, {new DateTime[]{dt}, dt.plusDays(1), dt.plusDays(1)}, {new DateTime[]{dt}, dt.plusDays(1), dt}, {new DateTime[]{dt}, dt.minusDays(2), dt.minusDays(3)}, {new DateTime[]{dt}, dt.minusDays(3), dt.minusDays(2)}, {new DateTime[]{dt.minusDays(2)}, dt, dt.minusDays(1)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(1), dt.minusDays(1)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(3), dt.minusDays(3)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(2), dt.minusDays(3)}, {new DateTime[]{dt.minusDays(2)}, dt, dt.plusDays(1)}, {new DateTime[]{dt.minusDays(2)}, dt.plusDays(1), dt}};
    }

    @Test(dataProvider="checkValueInsideRange_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkValueInsideRange_FailWithInvalidInput(DateTime[] dtArr, DateTime minValue, DateTime maxValue) {
        DateTimeArrayArgs.checkValueInsideRange((DateTime[])dtArr, (DateTime)minValue, (DateTime)maxValue, (String)"dtArr");
    }

    @DataProvider
    public static Object[][] checkValueOutsideRange_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{new DateTime[]{dt}, dt.minusDays(2), dt.minusDays(1)}, {new DateTime[]{dt}, dt.minusDays(1), dt.minusDays(1)}, {new DateTime[]{dt}, dt.plusDays(1), dt.plusDays(1)}, {new DateTime[]{dt}, dt.minusDays(3), dt.minusDays(2)}};
    }

    @Test(dataProvider="checkValueOutsideRange_Pass_Data")
    public void checkValueOutsideRange_Pass(DateTime[] dtArr, DateTime minValue, DateTime maxValue) {
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkValueOutsideRange((DateTime[])dtArr, (DateTime)minValue, (DateTime)maxValue, (String)"dtArr") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkValueOutsideRange((DateTime[])dtArr, (DateTime)minValue, (DateTime)maxValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkValueOutsideRange((DateTime[])dtArr, (DateTime)minValue, (DateTime)maxValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkValueOutsideRange((DateTime[])dtArr, (DateTime)minValue, (DateTime)maxValue, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValueRange_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkValueOutsideRange_FailWithNulls(DateTime[] dtArr, DateTime minValue, DateTime maxValue) {
        DateTimeArrayArgs.checkValueOutsideRange((DateTime[])dtArr, (DateTime)minValue, (DateTime)maxValue, (String)"dtArr");
    }

    @DataProvider
    public static Object[][] checkMinValue_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{new DateTime[]{dt}, dt.minusDays(2)}, {new DateTime[]{dt}, dt.minusDays(1)}, {new DateTime[]{dt}, dt}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(2)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(3)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(4)}};
    }

    @Test(dataProvider="checkMinValue_Pass_Data")
    public void checkMinValue_Pass(DateTime[] dtArr, DateTime minValue) {
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkMinValue((DateTime[])dtArr, (DateTime)minValue, (String)"dtArr") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkMinValue((DateTime[])dtArr, (DateTime)minValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkMinValue((DateTime[])dtArr, (DateTime)minValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkMinValue((DateTime[])dtArr, (DateTime)minValue, (String)"   ") ? 1 : 0) != 0);
    }

    @DataProvider
    public static Object[][] checkValue_FailWithNulls_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{null, dt}, {new DateTime[]{null}, dt}, {new DateTime[]{null, dt}, dt}, {new DateTime[]{dt, null}, dt}, {new DateTime[]{dt}, null}, {null, null}, {new DateTime[]{null}, null}, {new DateTime[]{null, dt}, null}, {new DateTime[]{dt, null}, null}};
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkMinValue_FailWithNulls(DateTime[] dtArr, DateTime minValue) {
        DateTimeArrayArgs.checkMinValue((DateTime[])dtArr, (DateTime)minValue, (String)"dtArr");
    }

    @DataProvider
    public static Object[][] checkMinValue_FailWithInvalidInput_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{new DateTime[]{dt}, dt.plusDays(1)}, {new DateTime[]{dt}, dt.plusDays(2)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(1)}, {new DateTime[]{dt.minusDays(2)}, dt}};
    }

    @Test(dataProvider="checkMinValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkMinValue_FailWithInvalidInput(DateTime[] dtArr, DateTime minValue) {
        DateTimeArrayArgs.checkMinValue((DateTime[])dtArr, (DateTime)minValue, (String)"dtArr");
    }

    @DataProvider
    public static Object[][] checkMaxValue_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{new DateTime[]{dt}, dt}, {new DateTime[]{dt}, dt.plusDays(1)}, {new DateTime[]{dt}, dt.plusDays(2)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(2)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(1)}, {new DateTime[]{dt.minusDays(2)}, dt}};
    }

    @Test(dataProvider="checkMaxValue_Pass_Data")
    public void checkMaxValue_Pass(DateTime[] dtArr, DateTime maxValue) {
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkMaxValue((DateTime[])dtArr, (DateTime)maxValue, (String)"dtArr") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkMaxValue((DateTime[])dtArr, (DateTime)maxValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkMaxValue((DateTime[])dtArr, (DateTime)maxValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkMaxValue((DateTime[])dtArr, (DateTime)maxValue, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkMaxValue_FailWithNulls(DateTime[] dtArr, DateTime maxValue) {
        DateTimeArrayArgs.checkMaxValue((DateTime[])dtArr, (DateTime)maxValue, (String)"dtArr");
    }

    @DataProvider
    public static Object[][] checkMaxValue_FailWithInvalidInput_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{new DateTime[]{dt}, dt.minusDays(1)}, {new DateTime[]{dt}, dt.minusDays(2)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(3)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(4)}};
    }

    @Test(dataProvider="checkMaxValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkMaxValue_FailWithInvalidInput(DateTime[] dtArr, DateTime maxValue) {
        DateTimeArrayArgs.checkMaxValue((DateTime[])dtArr, (DateTime)maxValue, (String)"dtArr");
    }

    @DataProvider
    public static Object[][] checkExactValue_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{new DateTime[]{dt}, dt}, {new DateTime[]{dt.minusDays(1)}, dt.minusDays(1)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(2)}};
    }

    @Test(dataProvider="checkExactValue_Pass_Data")
    public void checkExactValue_Pass(DateTime[] dtArr, DateTime value) {
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkExactValue((DateTime[])dtArr, (DateTime)value, (String)"dtArr") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkExactValue((DateTime[])dtArr, (DateTime)value, null) ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkExactValue((DateTime[])dtArr, (DateTime)value, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkExactValue((DateTime[])dtArr, (DateTime)value, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkExactValue_FailWithNulls(DateTime[] dtArr, DateTime value) {
        DateTimeArrayArgs.checkExactValue((DateTime[])dtArr, (DateTime)value, (String)"dtArr");
    }

    @DataProvider
    public static Object[][] checkExactValue_FailWithInvalidInput_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{new DateTime[]{dt}, dt.minusDays(1)}, {new DateTime[]{dt}, dt.minusDays(2)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(3)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(4)}};
    }

    @Test(dataProvider="checkExactValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkExactValue_FailWithInvalidInput(DateTime[] dtArr, DateTime value) {
        DateTimeArrayArgs.checkExactValue((DateTime[])dtArr, (DateTime)value, (String)"dtArr");
    }

    @DataProvider
    public static Object[][] checkNotExactValue_Pass_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{new DateTime[]{dt}, dt.minusDays(1)}, {new DateTime[]{dt}, dt.minusDays(2)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(3)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(4)}};
    }

    @Test(dataProvider="checkNotExactValue_Pass_Data")
    public void checkNotExactValue_Pass(DateTime[] dtArr, DateTime value) {
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkNotExactValue((DateTime[])dtArr, (DateTime)value, (String)"dtArr") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkNotExactValue((DateTime[])dtArr, (DateTime)value, null) ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkNotExactValue((DateTime[])dtArr, (DateTime)value, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((dtArr == DateTimeArrayArgs.checkNotExactValue((DateTime[])dtArr, (DateTime)value, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkNotExactValue_FailWithNulls(DateTime[] dtArr, DateTime value) {
        DateTimeArrayArgs.checkNotExactValue((DateTime[])dtArr, (DateTime)value, (String)"dtArr");
    }

    @DataProvider
    public static Object[][] checkNotExactValue_FailWithInvalidInput_Data() {
        DateTime dt = new DateTime();
        return new Object[][]{{new DateTime[]{dt}, dt}, {new DateTime[]{dt.minusDays(1)}, dt.minusDays(1)}, {new DateTime[]{dt.minusDays(2)}, dt.minusDays(2)}};
    }

    @Test(dataProvider="checkNotExactValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkNotExactValue_FailWithInvalidInput(DateTime[] dtArr, DateTime value) {
        DateTimeArrayArgs.checkNotExactValue((DateTime[])dtArr, (DateTime)value, (String)"dtArr");
    }
}

