/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.argument;

import com.googlecode.kevinarpe.papaya.argument.DateTimeArrayArgsTest;
import com.googlecode.kevinarpe.papaya.argument.DateTimeIterableArgs;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DateTimeIterableArgsTest {
    @DataProvider
    public static Object[][] checkValueInsideRange_Pass_Data() {
        return DateTimeArrayArgsTest.checkValueInsideRange_Pass_Data();
    }

    @Test(dataProvider="checkValueInsideRange_Pass_Data")
    public void checkValueInsideRange_Pass(DateTime[] dtArr, DateTime minValue, DateTime maxValue) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        Assert.assertTrue((list == DateTimeIterableArgs.checkValueInsideRange(list, (DateTime)minValue, (DateTime)maxValue, (String)"list") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkValueInsideRange(list, (DateTime)minValue, (DateTime)maxValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkValueInsideRange(list, (DateTime)minValue, (DateTime)maxValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkValueInsideRange(list, (DateTime)minValue, (DateTime)maxValue, (String)"   ") ? 1 : 0) != 0);
    }

    @DataProvider
    public static Object[][] checkValueRange_FailWithNulls_Data() {
        return DateTimeArrayArgsTest.checkValueRange_FailWithNulls_Data();
    }

    @Test(dataProvider="checkValueRange_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkValueInsideRange_FailWithNulls(DateTime[] dtArr, DateTime minValue, DateTime maxValue) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        DateTimeIterableArgs.checkValueInsideRange(list, (DateTime)minValue, (DateTime)maxValue, (String)"list");
    }

    @DataProvider
    public static Object[][] checkValueInsideRange_FailWithInvalidInput_Data() {
        return DateTimeArrayArgsTest.checkValueInsideRange_FailWithInvalidInput_Data();
    }

    @Test(dataProvider="checkValueInsideRange_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkValueInsideRange_FailWithInvalidInput(DateTime[] dtArr, DateTime minValue, DateTime maxValue) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        DateTimeIterableArgs.checkValueInsideRange(list, (DateTime)minValue, (DateTime)maxValue, (String)"list");
    }

    @DataProvider
    public static Object[][] checkValueOutsideRange_Pass_Data() {
        return DateTimeArrayArgsTest.checkValueOutsideRange_Pass_Data();
    }

    @Test(dataProvider="checkValueOutsideRange_Pass_Data")
    public void checkValueOutsideRange_Pass(DateTime[] dtArr, DateTime minValue, DateTime maxValue) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        Assert.assertTrue((list == DateTimeIterableArgs.checkValueOutsideRange(list, (DateTime)minValue, (DateTime)maxValue, (String)"list") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkValueOutsideRange(list, (DateTime)minValue, (DateTime)maxValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkValueOutsideRange(list, (DateTime)minValue, (DateTime)maxValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkValueOutsideRange(list, (DateTime)minValue, (DateTime)maxValue, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValueRange_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkValueOutsideRange_FailWithNulls(DateTime[] dtArr, DateTime minValue, DateTime maxValue) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        DateTimeIterableArgs.checkValueOutsideRange(list, (DateTime)minValue, (DateTime)maxValue, (String)"list");
    }

    @DataProvider
    public static Object[][] checkMinValue_Pass_Data() {
        return DateTimeArrayArgsTest.checkMinValue_Pass_Data();
    }

    @Test(dataProvider="checkMinValue_Pass_Data")
    public void checkMinValue_Pass(DateTime[] dtArr, DateTime minValue) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        Assert.assertTrue((list == DateTimeIterableArgs.checkMinValue(list, (DateTime)minValue, (String)"list") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkMinValue(list, (DateTime)minValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkMinValue(list, (DateTime)minValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkMinValue(list, (DateTime)minValue, (String)"   ") ? 1 : 0) != 0);
    }

    @DataProvider
    public static Object[][] checkValue_FailWithNulls_Data() {
        return DateTimeArrayArgsTest.checkValue_FailWithNulls_Data();
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkMinValue_FailWithNulls(DateTime[] dtArr, DateTime minValue) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        DateTimeIterableArgs.checkMinValue(list, (DateTime)minValue, (String)"list");
    }

    @DataProvider
    public static Object[][] checkMinValue_FailWithInvalidInput_Data() {
        return DateTimeArrayArgsTest.checkMinValue_FailWithInvalidInput_Data();
    }

    @Test(dataProvider="checkMinValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkMinValue_FailWithInvalidInput(DateTime[] dtArr, DateTime minValue) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        DateTimeIterableArgs.checkMinValue(list, (DateTime)minValue, (String)"list");
    }

    @DataProvider
    public static Object[][] checkMaxValue_Pass_Data() {
        return DateTimeArrayArgsTest.checkMaxValue_Pass_Data();
    }

    @Test(dataProvider="checkMaxValue_Pass_Data")
    public void checkMaxValue_Pass(DateTime[] dtArr, DateTime maxValue) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        Assert.assertTrue((list == DateTimeIterableArgs.checkMaxValue(list, (DateTime)maxValue, (String)"list") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkMaxValue(list, (DateTime)maxValue, null) ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkMaxValue(list, (DateTime)maxValue, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkMaxValue(list, (DateTime)maxValue, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkMaxValue_FailWithNulls(DateTime[] dtArr, DateTime maxValue) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        DateTimeIterableArgs.checkMaxValue(list, (DateTime)maxValue, (String)"list");
    }

    @DataProvider
    public static Object[][] checkMaxValue_FailWithInvalidInput_Data() {
        return DateTimeArrayArgsTest.checkMaxValue_FailWithInvalidInput_Data();
    }

    @Test(dataProvider="checkMaxValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkMaxValue_FailWithInvalidInput(DateTime[] dtArr, DateTime maxValue) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        DateTimeIterableArgs.checkMaxValue(list, (DateTime)maxValue, (String)"list");
    }

    @DataProvider
    public static Object[][] checkExactValue_Pass_Data() {
        return DateTimeArrayArgsTest.checkExactValue_Pass_Data();
    }

    @Test(dataProvider="checkExactValue_Pass_Data")
    public void checkExactValue_Pass(DateTime[] dtArr, DateTime value) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        Assert.assertTrue((list == DateTimeIterableArgs.checkExactValue(list, (DateTime)value, (String)"list") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkExactValue(list, (DateTime)value, null) ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkExactValue(list, (DateTime)value, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkExactValue(list, (DateTime)value, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkExactValue_FailWithNulls(DateTime[] dtArr, DateTime value) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        DateTimeIterableArgs.checkExactValue(list, (DateTime)value, (String)"list");
    }

    @DataProvider
    public static Object[][] checkExactValue_FailWithInvalidInput_Data() {
        return DateTimeArrayArgsTest.checkExactValue_FailWithInvalidInput_Data();
    }

    @Test(dataProvider="checkExactValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkExactValue_FailWithInvalidInput(DateTime[] dtArr, DateTime value) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        DateTimeIterableArgs.checkExactValue(list, (DateTime)value, (String)"list");
    }

    @DataProvider
    public static Object[][] checkNotExactValue_Pass_Data() {
        return DateTimeArrayArgsTest.checkNotExactValue_Pass_Data();
    }

    @Test(dataProvider="checkNotExactValue_Pass_Data")
    public void checkNotExactValue_Pass(DateTime[] dtArr, DateTime value) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        Assert.assertTrue((list == DateTimeIterableArgs.checkNotExactValue(list, (DateTime)value, (String)"list") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkNotExactValue(list, (DateTime)value, null) ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkNotExactValue(list, (DateTime)value, (String)"") ? 1 : 0) != 0);
        Assert.assertTrue((list == DateTimeIterableArgs.checkNotExactValue(list, (DateTime)value, (String)"   ") ? 1 : 0) != 0);
    }

    @Test(dataProvider="checkValue_FailWithNulls_Data", expectedExceptions={NullPointerException.class})
    public void checkNotExactValue_FailWithNulls(DateTime[] dtArr, DateTime value) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        DateTimeIterableArgs.checkNotExactValue(list, (DateTime)value, (String)"list");
    }

    @DataProvider
    public static Object[][] checkNotExactValue_FailWithInvalidInput_Data() {
        return DateTimeArrayArgsTest.checkNotExactValue_FailWithInvalidInput_Data();
    }

    @Test(dataProvider="checkNotExactValue_FailWithInvalidInput_Data", expectedExceptions={IllegalArgumentException.class})
    public void checkNotExactValue_FailWithInvalidInput(DateTime[] dtArr, DateTime value) {
        List<DateTime> list = dtArr == null ? null : Arrays.asList(dtArr);
        DateTimeIterableArgs.checkNotExactValue(list, (DateTime)value, (String)"list");
    }
}

