/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.jooq;

import com.googlecode.kevinarpe.papaya.exception.ThrowableToStringServiceFactory;
import com.googlecode.kevinarpe.papaya.jooq.DatabaseConnectionShutdownHookServiceImp;
import com.googlecode.kevinarpe.papaya.logging.slf4j.LoggerService;
import com.googlecode.kevinarpe.papaya.logging.slf4j.LoggerServiceImpl;
import com.googlecode.kevinarpe.papaya.string.MessageFormatter;
import com.googlecode.kevinarpe.papaya.string.ThrowingMessageFormatterImpl;
import java.sql.Connection;
import java.sql.SQLException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DatabaseConnectionShutdownHookServiceImpTest {
    @Mock
    private Runtime mockRuntime;
    @Mock
    private Connection mockConnection;
    private DatabaseConnectionShutdownHookServiceImp classUnderTest;

    @BeforeMethod
    public void beforeEachTestMethod() {
        MockitoAnnotations.openMocks((Object)this);
        LoggerServiceImpl loggerService = new LoggerServiceImpl(ThrowableToStringServiceFactory.DEFAULT_IMPL, (MessageFormatter)ThrowingMessageFormatterImpl.INSTANCE);
        this.classUnderTest = new DatabaseConnectionShutdownHookServiceImp(this.mockRuntime, (LoggerService)loggerService);
    }

    @Test
    public void addShutdownHook_Pass() {
        this.classUnderTest.addShutdownHook("description", this.mockConnection);
        ((Runtime)Mockito.verify((Object)this.mockRuntime)).addShutdownHook((Thread)Mockito.any());
    }

    @Test
    public void createThread_Pass() throws Exception {
        Thread thread = this.classUnderTest.createThread("description", this.mockConnection);
        thread.start();
        thread.join();
        ((Connection)Mockito.verify((Object)this.mockConnection)).close();
    }

    @Test
    public void createThread_FailWhenConnectionCloseThrows() throws Exception {
        SQLException exception = new SQLException("blah");
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mockConnection)).close();
        final Throwable[] throwableRef = new Throwable[]{null};
        Thread thread = this.classUnderTest.createThread("description", this.mockConnection);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                throwableRef[0] = e;
            }
        });
        thread.start();
        thread.join();
        Assert.assertSame((Object)throwableRef[0].getCause(), (Object)exception);
    }
}

