/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.jooq;

import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.argument.StringArgs;
import com.googlecode.kevinarpe.papaya.jooq.DatabaseConnectionShutdownHookService;
import com.googlecode.kevinarpe.papaya.logging.slf4j.IncludeStackTrace;
import com.googlecode.kevinarpe.papaya.logging.slf4j.LoggerLevel;
import com.googlecode.kevinarpe.papaya.logging.slf4j.LoggerService;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FullyTested
public final class DatabaseConnectionShutdownHookServiceImp
implements DatabaseConnectionShutdownHookService {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseConnectionShutdownHookServiceImp.class);
    private final Runtime runtime;
    private final LoggerService loggerService;

    public DatabaseConnectionShutdownHookServiceImp(LoggerService loggerService) {
        this(Runtime.getRuntime(), loggerService);
    }

    DatabaseConnectionShutdownHookServiceImp(Runtime runtime, LoggerService loggerService) {
        this.runtime = (Runtime)ObjectArgs.checkNotNull((Object)runtime, (String)"runtime");
        this.loggerService = (LoggerService)ObjectArgs.checkNotNull((Object)loggerService, (String)"loggerService");
    }

    @Override
    public void addShutdownHook(String description, Connection dbConn) {
        StringArgs.checkNotEmptyOrWhitespace((CharSequence)description, (String)"description");
        ObjectArgs.checkNotNull((Object)dbConn, (String)"dbConn");
        Thread thread = this.createThread(description, dbConn);
        this.runtime.addShutdownHook(thread);
    }

    Thread createThread(String description, Connection dbConn) {
        Thread thread = new Thread(() -> this._close(description, dbConn));
        thread.setName("shutdown-hook::db-conn");
        return thread;
    }

    private void _close(String description, Connection dbConn) {
        this.loggerService.formatThenLog(logger, LoggerLevel.INFO, "Database [%s]: Begin shutdown hook thread for database connection...", new Object[]{description});
        this._close0(description, dbConn);
        this.loggerService.formatThenLog(logger, LoggerLevel.INFO, "Database [%s]: Database connection closed", new Object[]{description});
    }

    private void _close0(String description, Connection dbConn) {
        try {
            dbConn.close();
        }
        catch (Exception e) {
            this.loggerService.formatThenLogThrowable(logger, LoggerLevel.ERROR, IncludeStackTrace.UNIQUE_ONLY, (Throwable)e, "Database [%s]: %s: Failed to close database connection", new Object[]{description, "Unexpected error"});
            throw new IllegalStateException(e);
        }
    }
}

