/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.jooq;

import com.google.common.collect.ImmutableList;
import com.googlecode.kevinarpe.papaya.annotation.Blocking;
import com.googlecode.kevinarpe.papaya.annotation.EmptyContainerAllowed;
import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.exception.ExceptionThrower;
import com.googlecode.kevinarpe.papaya.function.count.AtMostCountMatcher;
import com.googlecode.kevinarpe.papaya.function.count.CountMatcher;
import com.googlecode.kevinarpe.papaya.function.count.ExactlyCountMatcher;
import com.googlecode.kevinarpe.papaya.jooq.JooqDatabaseConnection;
import com.googlecode.kevinarpe.papaya.jooq.JooqDatabaseQueryService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.jooq.Delete;
import org.jooq.Insert;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Update;

@FullyTested
@ThreadSafe
public final class JooqDatabaseQueryServiceImp
implements JooqDatabaseQueryService {
    private final ExceptionThrower exceptionThrower;

    public JooqDatabaseQueryServiceImp(ExceptionThrower exceptionThrower) {
        this.exceptionThrower = (ExceptionThrower)ObjectArgs.checkNotNull((Object)exceptionThrower, (String)"exceptionThrower");
    }

    @Override
    @Blocking
    @EmptyContainerAllowed
    public <TRecord extends Record, TResultQuery extends ResultQuery<TRecord>> Result<TRecord> selectRowList(JooqDatabaseConnection dbConn, TResultQuery selectQuery, CountMatcher rowCountMatcher) throws Exception {
        Result<TRecord> result = this._selectRowList(dbConn, selectQuery);
        int rowCount = result.size();
        this._checkRowCount(_QueryType.SELECT, (Query)selectQuery, rowCountMatcher, rowCount);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    @EmptyContainerAllowed
    private <TRecord extends Record, TResultQuery extends ResultQuery<TRecord>> Result<TRecord> _selectRowList(JooqDatabaseConnection dbConn, TResultQuery selectQuery) throws Exception {
        try {
            JooqDatabaseConnection jooqDatabaseConnection = dbConn;
            synchronized (jooqDatabaseConnection) {
                Result x = selectQuery.fetch();
                return x;
            }
        }
        catch (Exception e) {
            throw this.exceptionThrower.throwChainedCheckedException(Exception.class, (Throwable)e, "Failed to execute SELECT query:%n%s", new Object[]{selectQuery});
        }
    }

    private void _checkRowCount(_QueryType queryType, Query query, CountMatcher rowCountMatcher, int rowCount) throws Exception {
        if (!rowCountMatcher.isMatch(rowCount)) {
            throw this.exceptionThrower.throwCheckedException(Exception.class, "Expected %s row(s), but found %d row(s):%n%s Query:%n%s%n", new Object[]{rowCountMatcher, rowCount, queryType.name(), query});
        }
    }

    @Override
    @Blocking
    public <TRecord extends Record, TResultQuery extends ResultQuery<TRecord>> TRecord selectRow(JooqDatabaseConnection dbConn, TResultQuery selectQuery) throws Exception {
        Result<TRecord> result = this.selectRowList(dbConn, selectQuery, (CountMatcher)ExactlyCountMatcher.ONE);
        Record x = (Record)result.get(0);
        return (TRecord)x;
    }

    @Override
    @Nullable
    @Blocking
    public <TRecord extends Record, TResultQuery extends ResultQuery<TRecord>> TRecord trySelectRow(JooqDatabaseConnection dbConn, TResultQuery selectQuery) throws Exception {
        Result<TRecord> result = this.selectRowList(dbConn, selectQuery, (CountMatcher)AtMostCountMatcher.ONE);
        int rowCount = result.size();
        switch (rowCount) {
            case 0: {
                return null;
            }
            case 1: {
                Record x = (Record)result.get(0);
                return (TRecord)x;
            }
        }
        throw this.exceptionThrower.throwCheckedException(Exception.class, "Unreachable code: %d", new Object[]{rowCount});
    }

    @Override
    @Blocking
    @EmptyContainerAllowed
    public <TValue, TResultQuery extends ResultQuery<Record1<TValue>>> ImmutableList<TValue> selectValueList(JooqDatabaseConnection dbConn, TResultQuery selectQuery, CountMatcher rowCountMatcher) throws Exception {
        Result result = this.selectRowList(dbConn, selectQuery, rowCountMatcher);
        int size = result.size();
        ImmutableList.Builder b = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            Record1 rec = (Record1)result.get(i);
            Object value = rec.value1();
            b.add(value);
        }
        ImmutableList x = b.build();
        return x;
    }

    @Override
    @Blocking
    public <TValue, TResultQuery extends ResultQuery<Record1<TValue>>> TValue selectValue(JooqDatabaseConnection dbConn, TResultQuery selectQuery) throws Exception {
        Record1 rec = (Record1)this.selectRow(dbConn, selectQuery);
        Object x = rec.value1();
        return (TValue)x;
    }

    @Override
    @Nullable
    @Blocking
    public <TValue, TResultQuery extends ResultQuery<Record1<TValue>>> TValue trySelectValue(JooqDatabaseConnection dbConn, TResultQuery selectQuery) throws Exception {
        Record1 rec = (Record1)this.trySelectRow(dbConn, selectQuery);
        if (null == rec) {
            return null;
        }
        Object x = rec.value1();
        return (TValue)x;
    }

    @Override
    @Blocking
    public void insertRows(JooqDatabaseConnection dbConn, Insert<? extends Record> insertQuery, CountMatcher rowCountMatcher) throws Exception {
        int rowCount = this._execute(dbConn, _QueryType.INSERT, (Query)insertQuery);
        this._checkRowCount(_QueryType.INSERT, (Query)insertQuery, rowCountMatcher, rowCount);
    }

    @Override
    @Blocking
    public void insertOneRow(JooqDatabaseConnection dbConn, Insert<? extends Record> insertQuery) throws Exception {
        int rowCount = this._execute(dbConn, _QueryType.INSERT, (Query)insertQuery);
        this._checkRowCount(_QueryType.INSERT, (Query)insertQuery, (CountMatcher)ExactlyCountMatcher.ONE, rowCount);
    }

    @Override
    @Blocking
    public void updateRows(JooqDatabaseConnection dbConn, Update<? extends Record> updateQuery, CountMatcher rowCountMatcher) throws Exception {
        int rowCount = this._execute(dbConn, _QueryType.UPDATE, (Query)updateQuery);
        this._checkRowCount(_QueryType.UPDATE, (Query)updateQuery, rowCountMatcher, rowCount);
    }

    @Override
    @Blocking
    public void updateOneRow(JooqDatabaseConnection dbConn, Update<? extends Record> updateQuery) throws Exception {
        this.updateRows(dbConn, updateQuery, (CountMatcher)ExactlyCountMatcher.ONE);
    }

    @Override
    @Blocking
    public void deleteRows(JooqDatabaseConnection dbConn, Delete<? extends Record> deleteQuery, CountMatcher rowCountMatcher) throws Exception {
        int rowCount = this._execute(dbConn, _QueryType.DELETE, (Query)deleteQuery);
        this._checkRowCount(_QueryType.DELETE, (Query)deleteQuery, rowCountMatcher, rowCount);
    }

    @Override
    @Blocking
    public void deleteOneRow(JooqDatabaseConnection dbConn, Delete<? extends Record> deleteQuery) throws Exception {
        this.deleteRows(dbConn, deleteQuery, (CountMatcher)ExactlyCountMatcher.ONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _execute(JooqDatabaseConnection dbConn, _QueryType queryType, Query query) throws Exception {
        try {
            JooqDatabaseConnection jooqDatabaseConnection = dbConn;
            synchronized (jooqDatabaseConnection) {
                int x = query.execute();
                return x;
            }
        }
        catch (Exception e) {
            throw this.exceptionThrower.throwChainedCheckedException(Exception.class, (Throwable)e, "Failed to execute %s query:%n%s", new Object[]{queryType.name(), query});
        }
    }

    private static enum _QueryType {
        SELECT,
        INSERT,
        UPDATE,
        DELETE;

    }
}

