/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.logging.slf4j;

import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.logging.slf4j.SLF4JLevelLogger;
import com.googlecode.kevinarpe.papaya.logging.slf4j.SLF4JLogLevel;
import org.slf4j.Logger;
import org.slf4j.Marker;

@FullyTested
final class SLF4JLevelLoggerInfo
implements SLF4JLevelLogger {
    private final Logger _logger;

    public SLF4JLevelLoggerInfo(Logger logger) {
        this._logger = (Logger)ObjectArgs.checkNotNull((Object)logger, (String)"logger");
    }

    @Override
    public SLF4JLogLevel getLogLevel() {
        return SLF4JLogLevel.INFO;
    }

    @Override
    public boolean isEnabled() {
        boolean b = this._logger.isInfoEnabled();
        return b;
    }

    @Override
    public void log(String msg) {
        this._logger.info(msg);
    }

    @Override
    public void log(String format, Object arg) {
        this._logger.info(format, arg);
    }

    @Override
    public void log(String format, Object arg1, Object arg2) {
        this._logger.info(format, arg1, arg2);
    }

    @Override
    public void log(String format, Object ... argArr) {
        this._logger.info(format, argArr);
    }

    @Override
    public void log(String msg, Throwable t) {
        this._logger.info(msg, t);
    }

    @Override
    public boolean isEnabled(Marker marker) {
        ObjectArgs.checkNotNull((Object)marker, (String)"marker");
        boolean b = this._logger.isInfoEnabled(marker);
        return b;
    }

    @Override
    public void log(Marker marker, String msg) {
        ObjectArgs.checkNotNull((Object)marker, (String)"marker");
        this._logger.info(marker, msg);
    }

    @Override
    public void log(Marker marker, String format, Object arg) {
        ObjectArgs.checkNotNull((Object)marker, (String)"marker");
        this._logger.info(marker, format, arg);
    }

    @Override
    public void log(Marker marker, String format, Object arg1, Object arg2) {
        ObjectArgs.checkNotNull((Object)marker, (String)"marker");
        this._logger.info(marker, format, arg1, arg2);
    }

    @Override
    public void log(Marker marker, String format, Object ... argArr) {
        ObjectArgs.checkNotNull((Object)marker, (String)"marker");
        this._logger.info(marker, format, argArr);
    }

    @Override
    public void log(Marker marker, String msg, Throwable t) {
        ObjectArgs.checkNotNull((Object)marker, (String)"marker");
        this._logger.info(marker, msg, t);
    }
}

