/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.logging.slf4j;

import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.logging.slf4j.ISLF4JLevelLoggerUtils;
import com.googlecode.kevinarpe.papaya.logging.slf4j.SLF4JLevelLogger;
import com.googlecode.kevinarpe.papaya.logging.slf4j.SLF4JLevelLoggerOff;
import com.googlecode.kevinarpe.papaya.logging.slf4j.SLF4JLogLevel;
import com.googlecode.kevinarpe.papaya.object.StatelessObject;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FullyTested
public final class SLF4JLevelLoggerUtils
extends StatelessObject
implements ISLF4JLevelLoggerUtils {
    public static final SLF4JLevelLoggerUtils INSTANCE = new SLF4JLevelLoggerUtils();

    @Override
    public SLF4JLevelLogger newInstance(SLF4JLogLevel logLevel, Class<?> clazz) {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        SLF4JLevelLogger x = this.newInstance(loggerFactory, logLevel, clazz);
        return x;
    }

    @Override
    public SLF4JLevelLogger newInstance(ILoggerFactory loggerFactory, SLF4JLogLevel logLevel, Class<?> clazz) {
        ObjectArgs.checkNotNull((Object)loggerFactory, (String)"loggerFactory");
        ObjectArgs.checkNotNull((Object)((Object)logLevel), (String)"logLevel");
        ObjectArgs.checkNotNull(clazz, (String)"clazz");
        if (SLF4JLogLevel.OFF == logLevel) {
            return SLF4JLevelLoggerOff.INSTANCE;
        }
        String className = clazz.getName();
        Logger logger = loggerFactory.getLogger(className);
        SLF4JLevelLogger levelLogger = logLevel.newLevelLogger(logger);
        return levelLogger;
    }
}

