/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.logging.slf4j;

import com.googlecode.kevinarpe.papaya.logging.slf4j.SLF4JLevelLoggerTrace;
import com.googlecode.kevinarpe.papaya.logging.slf4j.SLF4JLogLevel;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SLF4JLevelLoggerTraceTest {
    private static final String MSG_OR_FORMAT = "MSG_OR_FORMAT";
    private static final Object ARG1 = new Object();
    private static final Object ARG2 = new Object();
    private static final Object ARG3 = new Object();
    private static final Throwable THROWABLE = new Throwable();
    private Logger mockLogger;
    private Marker mockMarker;

    @BeforeMethod
    public void beforeEachMethod() {
        this.mockLogger = (Logger)Mockito.mock(Logger.class);
        this.mockMarker = (Marker)Mockito.mock(Marker.class);
    }

    @Test
    public void ctor_Pass() {
        new SLF4JLevelLoggerTrace(this.mockLogger);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void ctor_FailWithNull() {
        new SLF4JLevelLoggerTrace((Logger)null);
    }

    @Test
    public void getLogLevel_Pass() {
        Assert.assertEquals((Object)new SLF4JLevelLoggerTrace(this.mockLogger).getLogLevel(), (Object)SLF4JLogLevel.TRACE);
    }

    @Test
    public void isEnabled_Pass() {
        for (boolean b : new boolean[]{true, false}) {
            Mockito.when((Object)this.mockLogger.isTraceEnabled()).thenReturn((Object)b);
            Assert.assertEquals((boolean)new SLF4JLevelLoggerTrace(this.mockLogger).isEnabled(), (boolean)b);
        }
    }

    @Test
    public void logString_Pass() {
        new SLF4JLevelLoggerTrace(this.mockLogger).log(MSG_OR_FORMAT);
        ((Logger)Mockito.verify((Object)this.mockLogger)).trace(MSG_OR_FORMAT);
    }

    @Test
    public void logStringObject_Pass() {
        new SLF4JLevelLoggerTrace(this.mockLogger).log(MSG_OR_FORMAT, ARG1);
        ((Logger)Mockito.verify((Object)this.mockLogger)).trace(MSG_OR_FORMAT, ARG1);
    }

    @Test
    public void logStringObjectObject_Pass() {
        new SLF4JLevelLoggerTrace(this.mockLogger).log(MSG_OR_FORMAT, ARG1, ARG2);
        ((Logger)Mockito.verify((Object)this.mockLogger)).trace(MSG_OR_FORMAT, ARG1, ARG2);
    }

    @Test
    public void logStringObjectArr_Pass() {
        new SLF4JLevelLoggerTrace(this.mockLogger).log(MSG_OR_FORMAT, new Object[]{ARG1, ARG2, ARG3});
        ((Logger)Mockito.verify((Object)this.mockLogger)).trace(MSG_OR_FORMAT, new Object[]{ARG1, ARG2, ARG3});
    }

    @Test
    public void logStringThrowable_Pass() {
        new SLF4JLevelLoggerTrace(this.mockLogger).log(MSG_OR_FORMAT, THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockLogger)).trace(MSG_OR_FORMAT, THROWABLE);
    }

    @Test
    public void isEnabledMarker_Pass() {
        for (boolean b : new boolean[]{true, false}) {
            Mockito.when((Object)this.mockLogger.isTraceEnabled(this.mockMarker)).thenReturn((Object)b);
            Assert.assertEquals((boolean)new SLF4JLevelLoggerTrace(this.mockLogger).isEnabled(this.mockMarker), (boolean)b);
        }
    }

    @Test
    public void logMarkerString_Pass() {
        new SLF4JLevelLoggerTrace(this.mockLogger).log(this.mockMarker, MSG_OR_FORMAT);
        ((Logger)Mockito.verify((Object)this.mockLogger)).trace(this.mockMarker, MSG_OR_FORMAT);
    }

    @Test
    public void logMarkerStringObject_Pass() {
        new SLF4JLevelLoggerTrace(this.mockLogger).log(this.mockMarker, MSG_OR_FORMAT, ARG1);
        ((Logger)Mockito.verify((Object)this.mockLogger)).trace(this.mockMarker, MSG_OR_FORMAT, ARG1);
    }

    @Test
    public void logMarkerStringObjectObject_Pass() {
        new SLF4JLevelLoggerTrace(this.mockLogger).log(this.mockMarker, MSG_OR_FORMAT, ARG1, ARG2);
        ((Logger)Mockito.verify((Object)this.mockLogger)).trace(this.mockMarker, MSG_OR_FORMAT, ARG1, ARG2);
    }

    @Test
    public void logMarkerStringObjectArr_Pass() {
        new SLF4JLevelLoggerTrace(this.mockLogger).log(this.mockMarker, MSG_OR_FORMAT, new Object[]{ARG1, ARG2, ARG3});
        ((Logger)Mockito.verify((Object)this.mockLogger)).trace(this.mockMarker, MSG_OR_FORMAT, new Object[]{ARG1, ARG2, ARG3});
    }

    @Test
    public void logMarkerStringThrowable_Pass() {
        new SLF4JLevelLoggerTrace(this.mockLogger).log(this.mockMarker, MSG_OR_FORMAT, THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockLogger)).trace(this.mockMarker, MSG_OR_FORMAT, THROWABLE);
    }
}

