/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.logging.slf4j;

import com.googlecode.kevinarpe.papaya.annotation.EmptyStringAllowed;
import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.argument.StringArgs;
import com.googlecode.kevinarpe.papaya.exception.ThrowableToStringService;
import com.googlecode.kevinarpe.papaya.exception.ThrowableToStringServiceFactory;
import com.googlecode.kevinarpe.papaya.exception.ThrowableUtils;
import com.googlecode.kevinarpe.papaya.logging.slf4j.IncludeStackTrace;
import com.googlecode.kevinarpe.papaya.logging.slf4j.LoggerLevel;
import com.googlecode.kevinarpe.papaya.logging.slf4j.LoggerService;
import com.googlecode.kevinarpe.papaya.string.MessageFormatter;
import org.slf4j.Logger;

@FullyTested
public final class LoggerServiceImpl
implements LoggerService {
    static final String SLF4J_FORMAT = "{}: {}";
    private final ThrowableToStringService throwableToStringService;
    private final MessageFormatter messageFormatter;

    public LoggerServiceImpl(ThrowableToStringServiceFactory throwableToStringServiceFactory, MessageFormatter messageFormatter) {
        ObjectArgs.checkNotNull((Object)throwableToStringServiceFactory, (String)"throwableToStringServiceFactory");
        this.throwableToStringService = throwableToStringServiceFactory.newInstance();
        this.messageFormatter = (MessageFormatter)ObjectArgs.checkNotNull((Object)messageFormatter, (String)"messageFormatter");
    }

    @Override
    public void log(Logger logger, LoggerLevel loggerLevel, String message) {
        StringArgs.checkNotEmptyOrWhitespace((CharSequence)message, (String)"message");
        switch (loggerLevel) {
            case INFO: {
                logger.info(message);
                break;
            }
            case ERROR: {
                logger.error(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case TRACE: {
                logger.trace(message);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable code: Unknown " + ((Object)((Object)loggerLevel)).getClass().getSimpleName() + ": " + loggerLevel.name());
            }
        }
    }

    @Override
    public void formatThenLog(Logger logger, LoggerLevel loggerLevel, @EmptyStringAllowed String format, Object ... argArr) {
        String msg = this.messageFormatter.format(format, argArr);
        this.log(logger, loggerLevel, msg);
    }

    @Override
    public void logThrowable(Logger logger, LoggerLevel loggerLevel, IncludeStackTrace includeStackTrace, String message, Throwable throwable) {
        StringArgs.checkNotEmptyOrWhitespace((CharSequence)message, (String)"message");
        String s = this._throwableToString(throwable, includeStackTrace);
        switch (loggerLevel) {
            case INFO: {
                logger.info(SLF4J_FORMAT, (Object)message, (Object)s);
                break;
            }
            case ERROR: {
                logger.error(SLF4J_FORMAT, (Object)message, (Object)s);
                break;
            }
            case DEBUG: {
                logger.debug(SLF4J_FORMAT, (Object)message, (Object)s);
                break;
            }
            case TRACE: {
                logger.trace(SLF4J_FORMAT, (Object)message, (Object)s);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable code: Unknown " + ((Object)((Object)loggerLevel)).getClass().getSimpleName() + ": " + loggerLevel.name());
            }
        }
    }

    @Override
    public void formatThenLogThrowable(Logger logger, LoggerLevel loggerLevel, IncludeStackTrace includeStackTrace, Throwable throwable, @EmptyStringAllowed String format, Object ... argArr) {
        String msg = this.messageFormatter.format(format, argArr);
        this.logThrowable(logger, loggerLevel, includeStackTrace, msg, throwable);
    }

    private String _throwableToString(Throwable throwable, IncludeStackTrace includeStackTrace) {
        switch (includeStackTrace) {
            case YES: {
                String x = ThrowableUtils.toStringWithStackTrace((Throwable)throwable);
                return x;
            }
            case UNIQUE_ONLY: {
                String x = this.throwableToStringService.toStringWithUniqueStackTrace(throwable);
                return x;
            }
        }
        throw new IllegalStateException("Unreachable code: Unknown " + ((Object)((Object)includeStackTrace)).getClass().getSimpleName() + ": " + includeStackTrace.name());
    }
}

