/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.logging.slf4j;

import com.googlecode.kevinarpe.papaya.annotation.ReadOnlyContainer;
import com.googlecode.kevinarpe.papaya.exception.ThrowableToStringService;
import com.googlecode.kevinarpe.papaya.exception.ThrowableToStringServiceFactory;
import com.googlecode.kevinarpe.papaya.logging.slf4j.IncludeStackTrace;
import com.googlecode.kevinarpe.papaya.logging.slf4j.LoggerLevel;
import com.googlecode.kevinarpe.papaya.logging.slf4j.LoggerServiceImpl;
import com.googlecode.kevinarpe.papaya.string.MessageFormatter;
import com.googlecode.kevinarpe.papaya.string.MessageFormatterImpl;
import java.util.List;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class LoggerServiceImplTest {
    @ReadOnlyContainer
    private static final LoggerLevel[] LOGGER_LEVEL_ARR = LoggerLevel.values();
    public static final IncludeStackTrace[] INCLUDE_STACK_TRACE_ARR = IncludeStackTrace.values();
    @Mock
    private ThrowableToStringService mockThrowableToStringService;
    @Mock
    private MessageFormatter mockMessageFormatter;
    @Mock
    private Logger mockLogger;
    private LoggerServiceImpl classUnderTestWithMocks;
    private LoggerServiceImpl classUnderTest;

    @BeforeMethod
    public void beforeEachTest() {
        MockitoAnnotations.initMocks((Object)this);
        ThrowableToStringServiceFactory throwableToStringServiceFactory = () -> this.mockThrowableToStringService;
        this.classUnderTestWithMocks = new LoggerServiceImpl(throwableToStringServiceFactory, this.mockMessageFormatter);
        this.classUnderTest = new LoggerServiceImpl(ThrowableToStringServiceFactory.DEFAULT_IMPL, (MessageFormatter)MessageFormatterImpl.INSTANCE);
    }

    @Test
    public void log_Pass() {
        block6: for (LoggerLevel loggerLevel : LOGGER_LEVEL_ARR) {
            this.classUnderTestWithMocks.log(this.mockLogger, loggerLevel, loggerLevel.name());
            switch (loggerLevel) {
                case INFO: {
                    ((Logger)Mockito.verify((Object)this.mockLogger)).info(loggerLevel.name());
                    continue block6;
                }
                case ERROR: {
                    ((Logger)Mockito.verify((Object)this.mockLogger)).error(loggerLevel.name());
                    continue block6;
                }
                case DEBUG: {
                    ((Logger)Mockito.verify((Object)this.mockLogger)).debug(loggerLevel.name());
                    continue block6;
                }
                case TRACE: {
                    ((Logger)Mockito.verify((Object)this.mockLogger)).trace(loggerLevel.name());
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Unreachable code");
                }
            }
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger});
    }

    @DataProvider
    private static Object[][] _log_FailWhenInvalidMessage_Data() {
        return new Object[][]{{null, NullPointerException.class}, {"", IllegalArgumentException.class}, {"   ", IllegalArgumentException.class}, {"\t", IllegalArgumentException.class}, {"\n", IllegalArgumentException.class}};
    }

    @Test(dataProvider="_log_FailWhenInvalidMessage_Data")
    public void log_FailWhenInvalidMessage(String message, Class<? extends Exception> exceptionClass) {
        for (LoggerLevel loggerLevel : LOGGER_LEVEL_ARR) {
            Exception e0 = null;
            try {
                this.classUnderTestWithMocks.log(this.mockLogger, loggerLevel, message);
            }
            catch (Exception e) {
                e0 = e;
            }
            if (null == e0) {
                throw new IllegalStateException("Unreachable code");
            }
            if (exceptionClass.isInstance(e0)) continue;
            throw new IllegalStateException("Unreachable code");
        }
    }

    @Test
    public void formatThenLog_Pass() {
        for (LoggerLevel loggerLevel : LOGGER_LEVEL_ARR) {
            String expectedMessage = String.format("[%s]", loggerLevel.name());
            Mockito.when((Object)this.mockMessageFormatter.format("[%s]", new Object[]{loggerLevel.name()})).thenReturn((Object)expectedMessage);
            this.classUnderTestWithMocks.formatThenLog(this.mockLogger, loggerLevel, "[%s]", new Object[]{loggerLevel.name()});
            switch (loggerLevel) {
                case INFO: {
                    ((Logger)Mockito.verify((Object)this.mockLogger)).info(expectedMessage);
                    break;
                }
                case ERROR: {
                    ((Logger)Mockito.verify((Object)this.mockLogger)).error(expectedMessage);
                    break;
                }
                case DEBUG: {
                    ((Logger)Mockito.verify((Object)this.mockLogger)).debug(expectedMessage);
                    break;
                }
                case TRACE: {
                    ((Logger)Mockito.verify((Object)this.mockLogger)).trace(expectedMessage);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unreachable code");
                }
            }
            ((MessageFormatter)Mockito.verify((Object)this.mockMessageFormatter)).format("[%s]", new Object[]{loggerLevel.name()});
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger, this.mockMessageFormatter});
    }

    @Test(dataProvider="_log_FailWhenInvalidMessage_Data")
    public void formatThenLog_FailWhenInvalidMessage(String message, Class<? extends Exception> exceptionClass) {
        for (LoggerLevel loggerLevel : LOGGER_LEVEL_ARR) {
            Mockito.when((Object)this.mockMessageFormatter.format("[%s]", new Object[]{loggerLevel.name()})).thenReturn((Object)message);
            Exception e0 = null;
            try {
                this.classUnderTestWithMocks.formatThenLog(this.mockLogger, loggerLevel, "[%s]", new Object[]{loggerLevel.name()});
            }
            catch (Exception e) {
                e0 = e;
            }
            if (null == e0) {
                throw new IllegalStateException("Unreachable code");
            }
            if (!exceptionClass.isInstance(e0)) {
                throw new IllegalStateException("Unreachable code");
            }
            ((MessageFormatter)Mockito.verify((Object)this.mockMessageFormatter)).format("[%s]", new Object[]{loggerLevel.name()});
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockMessageFormatter});
    }

    @Test
    public void logThrowable() {
        String unique = "UNIQUE";
        Mockito.when((Object)this.mockThrowableToStringService.toStringWithUniqueStackTrace((Throwable)Mockito.any())).thenReturn((Object)"UNIQUE");
        Exception e0 = new Exception();
        for (LoggerLevel loggerLevel : LOGGER_LEVEL_ARR) {
            block13: for (IncludeStackTrace includeStackTrace : INCLUDE_STACK_TRACE_ARR) {
                System.out.println(loggerLevel.name() + "/" + includeStackTrace.name());
                try {
                    throw e0;
                }
                catch (Exception e) {
                    this.classUnderTestWithMocks.logThrowable(this.mockLogger, loggerLevel, includeStackTrace, (Throwable)e, loggerLevel.name());
                    ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(String.class);
                    switch (loggerLevel) {
                        case INFO: {
                            ((Logger)Mockito.verify((Object)this.mockLogger, (VerificationMode)Mockito.atLeastOnce())).info((String)Mockito.eq((Object)"{}: {}"), Mockito.eq((Object)loggerLevel.name()), argumentCaptor.capture());
                            break;
                        }
                        case ERROR: {
                            ((Logger)Mockito.verify((Object)this.mockLogger, (VerificationMode)Mockito.atLeastOnce())).error((String)Mockito.eq((Object)"{}: {}"), Mockito.eq((Object)loggerLevel.name()), argumentCaptor.capture());
                            break;
                        }
                        case DEBUG: {
                            ((Logger)Mockito.verify((Object)this.mockLogger, (VerificationMode)Mockito.atLeastOnce())).debug((String)Mockito.eq((Object)"{}: {}"), Mockito.eq((Object)loggerLevel.name()), argumentCaptor.capture());
                            break;
                        }
                        case TRACE: {
                            ((Logger)Mockito.verify((Object)this.mockLogger, (VerificationMode)Mockito.atLeastOnce())).trace((String)Mockito.eq((Object)"{}: {}"), Mockito.eq((Object)loggerLevel.name()), argumentCaptor.capture());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable code");
                        }
                    }
                    List messageList = argumentCaptor.getAllValues();
                    String message = (String)messageList.get(messageList.size() - 1);
                    switch (includeStackTrace) {
                        case YES: {
                            this._assertStringContains(message, this.getClass().getSimpleName());
                            continue block13;
                        }
                        case UNIQUE_ONLY: {
                            this._assertStringContains(message, "UNIQUE");
                            continue block13;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable code");
                        }
                    }
                }
            }
        }
    }

    @Test(dataProvider="_log_FailWhenInvalidMessage_Data")
    public void logThrowable_FailWhenInvalidMessage(String message, Class<? extends Exception> exceptionClass) {
        Exception e0 = new Exception();
        for (LoggerLevel loggerLevel : LOGGER_LEVEL_ARR) {
            for (IncludeStackTrace includeStackTrace : INCLUDE_STACK_TRACE_ARR) {
                try {
                    throw e0;
                }
                catch (Exception e) {
                    Exception e1 = null;
                    try {
                        this.classUnderTestWithMocks.logThrowable(this.mockLogger, loggerLevel, includeStackTrace, (Throwable)e, message);
                    }
                    catch (Exception e2) {
                        e1 = e2;
                    }
                    if (null == e1) {
                        throw new IllegalStateException("Unreachable code");
                    }
                    if (exceptionClass.isInstance(e1)) continue;
                    throw new IllegalStateException("Unreachable code");
                }
            }
        }
    }

    @Test
    public void formatThenLogThrowable_Pass() {
        String unique = "UNIQUE";
        Mockito.when((Object)this.mockThrowableToStringService.toStringWithUniqueStackTrace((Throwable)Mockito.any())).thenReturn((Object)"UNIQUE");
        Exception e0 = new Exception();
        for (LoggerLevel loggerLevel : LOGGER_LEVEL_ARR) {
            block13: for (IncludeStackTrace includeStackTrace : INCLUDE_STACK_TRACE_ARR) {
                String expectedMessage = String.format("[%s/%s]", loggerLevel.name(), includeStackTrace.name());
                Mockito.when((Object)this.mockMessageFormatter.format("[%s/%s]", new Object[]{loggerLevel.name(), includeStackTrace.name()})).thenReturn((Object)expectedMessage);
                System.out.println(loggerLevel.name() + "/" + includeStackTrace.name());
                try {
                    throw e0;
                }
                catch (Exception e) {
                    this.classUnderTestWithMocks.formatThenLogThrowable(this.mockLogger, loggerLevel, includeStackTrace, (Throwable)e, "[%s/%s]", new Object[]{loggerLevel.name(), includeStackTrace.name()});
                    ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(String.class);
                    switch (loggerLevel) {
                        case INFO: {
                            ((Logger)Mockito.verify((Object)this.mockLogger, (VerificationMode)Mockito.atLeastOnce())).info((String)Mockito.eq((Object)"{}: {}"), Mockito.eq((Object)expectedMessage), argumentCaptor.capture());
                            break;
                        }
                        case ERROR: {
                            ((Logger)Mockito.verify((Object)this.mockLogger, (VerificationMode)Mockito.atLeastOnce())).error((String)Mockito.eq((Object)"{}: {}"), Mockito.eq((Object)expectedMessage), argumentCaptor.capture());
                            break;
                        }
                        case DEBUG: {
                            ((Logger)Mockito.verify((Object)this.mockLogger, (VerificationMode)Mockito.atLeastOnce())).debug((String)Mockito.eq((Object)"{}: {}"), Mockito.eq((Object)expectedMessage), argumentCaptor.capture());
                            break;
                        }
                        case TRACE: {
                            ((Logger)Mockito.verify((Object)this.mockLogger, (VerificationMode)Mockito.atLeastOnce())).trace((String)Mockito.eq((Object)"{}: {}"), Mockito.eq((Object)expectedMessage), argumentCaptor.capture());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable code");
                        }
                    }
                    ((MessageFormatter)Mockito.verify((Object)this.mockMessageFormatter)).format("[%s/%s]", new Object[]{loggerLevel.name(), includeStackTrace.name()});
                    List messageList = argumentCaptor.getAllValues();
                    String message = (String)messageList.get(messageList.size() - 1);
                    switch (includeStackTrace) {
                        case YES: {
                            this._assertStringContains(message, this.getClass().getSimpleName());
                            continue block13;
                        }
                        case UNIQUE_ONLY: {
                            this._assertStringContains(message, "UNIQUE");
                            continue block13;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable code");
                        }
                    }
                }
            }
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockLogger, this.mockMessageFormatter});
    }

    @Test(dataProvider="_log_FailWhenInvalidMessage_Data")
    public void formatThenLogThrowable_FailWhenInvalidMessage(String message, Class<? extends Exception> exceptionClass) {
        Exception e0 = new Exception();
        for (LoggerLevel loggerLevel : LOGGER_LEVEL_ARR) {
            for (IncludeStackTrace includeStackTrace : INCLUDE_STACK_TRACE_ARR) {
                Mockito.when((Object)this.mockMessageFormatter.format("[%s/%s]", new Object[]{loggerLevel.name(), includeStackTrace.name()})).thenReturn((Object)message);
                try {
                    throw e0;
                }
                catch (Exception e) {
                    Exception e1 = null;
                    try {
                        this.classUnderTestWithMocks.formatThenLogThrowable(this.mockLogger, loggerLevel, includeStackTrace, (Throwable)e, "[%s/%s]", new Object[]{loggerLevel.name(), includeStackTrace.name()});
                    }
                    catch (Exception e2) {
                        e1 = e2;
                    }
                    if (null == e1) {
                        throw new IllegalStateException("Unreachable code");
                    }
                    if (exceptionClass.isInstance(e1)) continue;
                    throw new IllegalStateException("Unreachable code");
                }
            }
        }
    }

    private void _assertStringContains(String haystack, String needle) {
        Assert.assertTrue((boolean)haystack.contains(needle), (String)(haystack + ".contains(" + needle + ")"));
    }
}

