/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.testing;

import com.googlecode.kevinarpe.papaya.testing.SourceFileToClassHelperImpl;
import java.io.File;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SourceFileToClassHelperImplTest {
    private static final File THIS_SOURCE_FILE_PATH = new File(String.format("%s/%s.java", UUID.randomUUID().toString(), SourceFileToClassHelperImplTest.class.getName().replace('.', '/')));
    private SourceFileToClassHelperImpl classUnderTest;

    @BeforeMethod
    public void beforeEachTestMethod() {
        this.classUnderTest = new SourceFileToClassHelperImpl();
    }

    @Test
    public void getClass_Pass() throws ClassNotFoundException {
        Class thisClass = this.classUnderTest.getClass(THIS_SOURCE_FILE_PATH);
        Assert.assertSame((Object)thisClass, SourceFileToClassHelperImplTest.class);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void getClass_FailWithNull() throws ClassNotFoundException {
        this.classUnderTest.getClass((File)null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void getClass_FailWithBadFileSuffix() throws ClassNotFoundException {
        this.classUnderTest.getClass(new File(UUID.randomUUID().toString()));
    }

    @DataProvider
    private static Object[][] _getClass_FailWithClassNotFoundException_Data() {
        return new Object[][]{{new File(UUID.randomUUID().toString() + ".java")}, {new File(UUID.randomUUID().toString(), UUID.randomUUID().toString() + ".java")}};
    }

    @Test(dataProvider="_getClass_FailWithClassNotFoundException_Data", expectedExceptions={ClassNotFoundException.class})
    public void getClass_FailWithClassNotFoundException(File path) throws ClassNotFoundException {
        this.classUnderTest.getClass(path);
    }
}

