/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.testing;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.googlecode.kevinarpe.papaya.exception.ClassNotFoundRuntimeException;
import com.googlecode.kevinarpe.papaya.exception.PathRuntimeException;
import com.googlecode.kevinarpe.papaya.filesystem.PathFilter;
import com.googlecode.kevinarpe.papaya.filesystem.TraversePathDepthPolicy;
import com.googlecode.kevinarpe.papaya.filesystem.TraversePathIterable;
import com.googlecode.kevinarpe.papaya.filesystem.TraversePathIterableFactory;
import com.googlecode.kevinarpe.papaya.filesystem.TraversePathIterator;
import com.googlecode.kevinarpe.papaya.logging.slf4j.SLF4JLogLevel;
import com.googlecode.kevinarpe.papaya.testing.SourceFileToClassHelper;
import com.googlecode.kevinarpe.papaya.testing.TestClassFinder;
import com.googlecode.kevinarpe.papaya.testing.TestClassFinderImpl;
import com.googlecode.kevinarpe.papaya.testing.TestClassFinderUtils;
import com.googlecode.kevinarpe.papaya.testing.logging.AnyLoggingEventAttributeValuePredicate;
import com.googlecode.kevinarpe.papaya.testing.logging.ILoggingEventAttribute;
import com.googlecode.kevinarpe.papaya.testing.logging.slf4j.SLF4JLoggingEventAttribute;
import com.googlecode.kevinarpe.papaya.testing.logging.slf4j.SLF4JMockLogger;
import com.googlecode.kevinarpe.papaya.testing.logging.slf4j.SLF4JMockLoggerFactory;
import com.googlecode.kevinarpe.papaya.testing.logging.slf4j.SLF4JMockLoggerUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.ILoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestClassFinderImplTest {
    private TraversePathIterableFactory mockTraversePathIterableFactory;
    private TraversePathIterable mockTraversePathIterable;
    private TraversePathIterator mockTraversePathIterator;
    private TestClassFinderImpl.IteratePathFilterFactory mockIteratePathFilterFactory;
    private PathFilter mockPathFilter;
    private SourceFileToClassHelper mockSourceFileToClassHelper;
    private SLF4JMockLoggerFactory mockLoggerFactory;
    private TestClassFinderImpl classUnderTestWithoutMocks;
    private TestClassFinderImpl classUnderTestWithMocks;

    @BeforeMethod
    public void beforeEachTest() {
        this.mockTraversePathIterableFactory = (TraversePathIterableFactory)Mockito.mock(TraversePathIterableFactory.class);
        this.mockTraversePathIterable = (TraversePathIterable)Mockito.mock(TraversePathIterable.class);
        this.mockTraversePathIterator = (TraversePathIterator)Mockito.mock(TraversePathIterator.class);
        this.mockIteratePathFilterFactory = (TestClassFinderImpl.IteratePathFilterFactory)Mockito.mock(TestClassFinderImpl.IteratePathFilterFactory.class);
        this.mockPathFilter = (PathFilter)Mockito.mock(PathFilter.class);
        this.mockSourceFileToClassHelper = (SourceFileToClassHelper)Mockito.mock(SourceFileToClassHelper.class);
        this.mockLoggerFactory = SLF4JMockLoggerUtils.INSTANCE.newFactoryInstance();
        this.classUnderTestWithoutMocks = new TestClassFinderImpl();
        this.classUnderTestWithMocks = new TestClassFinderImpl(this.mockTraversePathIterableFactory, this.mockIteratePathFilterFactory, this.mockSourceFileToClassHelper, (ILoggerFactory)this.mockLoggerFactory);
    }

    public static void assertAttrEquals(TestClassFinder testClassFinder, File rootDirPath, List<Pattern> includeByFilePathPatternList, List<Pattern> excludeByFilePathPatternList) {
        Assert.assertEquals((Object)testClassFinder.withRootDirPath(), (Object)rootDirPath);
        Assert.assertEquals((Collection)testClassFinder.withIncludePatterns(), includeByFilePathPatternList);
        Assert.assertEquals((Collection)testClassFinder.withExcludePatterns(), excludeByFilePathPatternList);
    }

    @Test
    public void ctor_Pass() {
        TestClassFinderImplTest.assertAttrEquals((TestClassFinder)this.classUnderTestWithoutMocks, TestClassFinderUtils.DEFAULT_ROOT_DIR_PATH, TestClassFinderUtils.DEFAULT_INCLUDE_PATTERN_LIST, TestClassFinderUtils.DEFAULT_EXCLUDE_PATTERN_LIST);
    }

    @Test
    public void withRootDirPath_Pass() {
        File oldPath = this.classUnderTestWithoutMocks.withRootDirPath();
        File newPath = new File(UUID.randomUUID().toString());
        this.classUnderTestWithoutMocks = this.classUnderTestWithoutMocks.withRootDirPath(newPath);
        TestClassFinderImplTest.assertAttrEquals((TestClassFinder)this.classUnderTestWithoutMocks, newPath, TestClassFinderUtils.DEFAULT_INCLUDE_PATTERN_LIST, TestClassFinderUtils.DEFAULT_EXCLUDE_PATTERN_LIST);
        this.classUnderTestWithoutMocks = this.classUnderTestWithoutMocks.withRootDirPath(oldPath);
        TestClassFinderImplTest.assertAttrEquals((TestClassFinder)this.classUnderTestWithoutMocks, oldPath, TestClassFinderUtils.DEFAULT_INCLUDE_PATTERN_LIST, TestClassFinderUtils.DEFAULT_EXCLUDE_PATTERN_LIST);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void withRootDirPath_FailWithNull() {
        this.classUnderTestWithoutMocks.withRootDirPath((File)null);
    }

    @Test
    public void includePatterns_Pass() {
        Pattern newPattern = Pattern.compile(UUID.randomUUID().toString());
        Pattern newPattern2 = Pattern.compile(UUID.randomUUID().toString());
        this.classUnderTestWithoutMocks = this.classUnderTestWithoutMocks.withIncludePatterns(newPattern, new Pattern[0]);
        TestClassFinderImplTest.assertAttrEquals((TestClassFinder)this.classUnderTestWithoutMocks, TestClassFinderUtils.DEFAULT_ROOT_DIR_PATH, Arrays.asList(newPattern), TestClassFinderUtils.DEFAULT_EXCLUDE_PATTERN_LIST);
        this.classUnderTestWithoutMocks = this.classUnderTestWithoutMocks.withIncludePatterns(newPattern, new Pattern[]{newPattern2});
        TestClassFinderImplTest.assertAttrEquals((TestClassFinder)this.classUnderTestWithoutMocks, TestClassFinderUtils.DEFAULT_ROOT_DIR_PATH, Arrays.asList(newPattern, newPattern2), TestClassFinderUtils.DEFAULT_EXCLUDE_PATTERN_LIST);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void includePatterns_FailWithNull() {
        this.classUnderTestWithoutMocks.withIncludePatterns((Pattern)null, new Pattern[0]);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void includePatterns_FailWithNull2() {
        Pattern newPattern = Pattern.compile(UUID.randomUUID().toString());
        this.classUnderTestWithoutMocks.withIncludePatterns(newPattern, new Pattern[]{null, newPattern});
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void includePatterns_FailWithNull3() {
        Pattern newPattern = Pattern.compile(UUID.randomUUID().toString());
        this.classUnderTestWithoutMocks.withIncludePatterns(newPattern, (Pattern[])null);
    }

    @Test
    public void includePatterns2_Pass() {
        Pattern newPattern = Pattern.compile(UUID.randomUUID().toString());
        Pattern newPattern2 = Pattern.compile(UUID.randomUUID().toString());
        this.classUnderTestWithoutMocks = this.classUnderTestWithoutMocks.withIncludePatterns(Arrays.asList(newPattern));
        TestClassFinderImplTest.assertAttrEquals((TestClassFinder)this.classUnderTestWithoutMocks, TestClassFinderUtils.DEFAULT_ROOT_DIR_PATH, Arrays.asList(newPattern), TestClassFinderUtils.DEFAULT_EXCLUDE_PATTERN_LIST);
        this.classUnderTestWithoutMocks = this.classUnderTestWithoutMocks.withIncludePatterns(Arrays.asList(newPattern, newPattern2));
        TestClassFinderImplTest.assertAttrEquals((TestClassFinder)this.classUnderTestWithoutMocks, TestClassFinderUtils.DEFAULT_ROOT_DIR_PATH, Arrays.asList(newPattern, newPattern2), TestClassFinderUtils.DEFAULT_EXCLUDE_PATTERN_LIST);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void includePatterns2_FailWithNull() {
        this.classUnderTestWithoutMocks.withIncludePatterns((List)null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void includePatterns2_FailWithNull2() {
        Pattern newPattern = Pattern.compile(UUID.randomUUID().toString());
        this.classUnderTestWithoutMocks.withIncludePatterns(Arrays.asList(newPattern, null));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void includePatterns2_FailWithEmptyList() {
        this.classUnderTestWithoutMocks.withIncludePatterns(Arrays.asList(new Pattern[0]));
    }

    @Test
    public void excludePatterns_Pass() {
        Pattern newPattern = Pattern.compile(UUID.randomUUID().toString());
        Pattern newPattern2 = Pattern.compile(UUID.randomUUID().toString());
        this.classUnderTestWithoutMocks = this.classUnderTestWithoutMocks.withExcludePatterns(newPattern, new Pattern[0]);
        Assert.assertEquals((Collection)this.classUnderTestWithoutMocks.withExcludePatterns(), Arrays.asList(newPattern));
        this.classUnderTestWithoutMocks = this.classUnderTestWithoutMocks.withExcludePatterns(newPattern, new Pattern[]{newPattern2});
        Assert.assertEquals((Collection)this.classUnderTestWithoutMocks.withExcludePatterns(), Arrays.asList(newPattern, newPattern2));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void excludePatterns_FailWithNull() {
        this.classUnderTestWithoutMocks.withExcludePatterns((Pattern)null, new Pattern[0]);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void excludePatterns_FailWithNull2() {
        Pattern newPattern = Pattern.compile(UUID.randomUUID().toString());
        this.classUnderTestWithoutMocks.withExcludePatterns(newPattern, new Pattern[]{null});
    }

    @Test
    public void excludePatterns2_Pass() {
        Pattern newPattern = Pattern.compile(UUID.randomUUID().toString());
        Pattern newPattern2 = Pattern.compile(UUID.randomUUID().toString());
        this.classUnderTestWithoutMocks = this.classUnderTestWithoutMocks.withExcludePatterns(Arrays.asList(newPattern));
        TestClassFinderImplTest.assertAttrEquals((TestClassFinder)this.classUnderTestWithoutMocks, TestClassFinderUtils.DEFAULT_ROOT_DIR_PATH, TestClassFinderUtils.DEFAULT_INCLUDE_PATTERN_LIST, Arrays.asList(newPattern));
        this.classUnderTestWithoutMocks = this.classUnderTestWithoutMocks.withExcludePatterns(Arrays.asList(newPattern, newPattern2));
        TestClassFinderImplTest.assertAttrEquals((TestClassFinder)this.classUnderTestWithoutMocks, TestClassFinderUtils.DEFAULT_ROOT_DIR_PATH, TestClassFinderUtils.DEFAULT_INCLUDE_PATTERN_LIST, Arrays.asList(newPattern, newPattern2));
    }

    @Test
    public void excludePatterns2_PassWithEmptyList() {
        this.classUnderTestWithoutMocks.withExcludePatterns(Arrays.asList(new Pattern[0]));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void excludePatterns2_FailWithNull() {
        this.classUnderTestWithoutMocks.withExcludePatterns((List)null);
    }

    public void _setFindAsMocks() throws ClassNotFoundException {
        Mockito.when((Object)this.mockTraversePathIterableFactory.newInstance((File)Matchers.any(File.class), (TraversePathDepthPolicy)Matchers.any(TraversePathDepthPolicy.class))).thenReturn((Object)this.mockTraversePathIterable);
        Mockito.when((Object)this.mockIteratePathFilterFactory.newInstance((TestClassFinderImpl)Matchers.any(TestClassFinderImpl.class))).thenReturn((Object)this.mockPathFilter);
        Mockito.when((Object)this.mockTraversePathIterable.withOptionalIteratePathFilter(this.mockPathFilter)).thenReturn((Object)this.mockTraversePathIterable);
        Mockito.when((Object)this.mockTraversePathIterable.iterator()).thenReturn((Object)this.mockTraversePathIterator);
        Mockito.when((Object)this.mockTraversePathIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)this.mockTraversePathIterator.next()).thenReturn((Object)new File("dummy"));
        Mockito.when((Object)this.mockSourceFileToClassHelper.getClass((File)Matchers.any(File.class))).thenReturn(Class1.class, (Object[])new Class[]{AbstractClass2.class, Class3.class});
    }

    @Test
    public void findAsList_Pass() throws ClassNotFoundException {
        this._setFindAsMocks();
        this.classUnderTestWithMocks = this.classUnderTestWithMocks.withIncludePatterns(Pattern.compile("abc"), new Pattern[0]);
        List classList = this.classUnderTestWithMocks.findAsList();
        Assert.assertEquals((Collection)classList, Arrays.asList(Class1.class, Class3.class));
        this._assertLogger(SLF4JLogLevel.DEBUG, 1);
    }

    private void _assertLogger(SLF4JLogLevel logLevel, int count) {
        SLF4JMockLogger logger = this.mockLoggerFactory.getLogger(TestClassFinderImpl.class.getName());
        Assert.assertEquals((int)Collections2.filter((Collection)logger.getLoggingEventList(), (Predicate)new AnyLoggingEventAttributeValuePredicate((ILoggingEventAttribute)SLF4JLoggingEventAttribute.LEVEL, (Object)logLevel, new Object[0])).size(), (int)count);
    }

    @Test(expectedExceptions={PathRuntimeException.class})
    public void findAsList_FailWithPathRuntimeException() {
        this.classUnderTestWithoutMocks.withRootDirPath(new File(UUID.randomUUID().toString())).withIncludePatterns(Pattern.compile("a"), new Pattern[0]).findAsList();
    }

    @Test(expectedExceptions={ClassNotFoundRuntimeException.class})
    public void findAsList_FailWithClassNotFoundRuntimeException() throws ClassNotFoundException {
        this._setFindAsMocks();
        this.classUnderTestWithMocks = this.classUnderTestWithMocks.withIncludePatterns(Pattern.compile("abc"), new Pattern[0]);
        ClassNotFoundException cause = new ClassNotFoundException();
        Mockito.when((Object)this.mockSourceFileToClassHelper.getClass((File)Matchers.any(File.class))).thenThrow(new Throwable[]{cause});
        try {
            this.classUnderTestWithMocks.findAsList();
        }
        catch (ClassNotFoundRuntimeException e) {
            Assert.assertSame((Object)e.getCause(), (Object)cause);
            throw e;
        }
    }

    @Test
    public void findAsArray_Pass() throws ClassNotFoundException {
        this._setFindAsMocks();
        this.classUnderTestWithMocks = this.classUnderTestWithMocks.withIncludePatterns(Pattern.compile("abc"), new Pattern[0]);
        Class[] classArr = this.classUnderTestWithMocks.findAsArray();
        Assert.assertEquals(Arrays.asList(classArr), Arrays.asList(Class1.class, Class3.class));
        this._assertLogger(SLF4JLogLevel.DEBUG, 1);
    }

    @Test
    public void TestClassFinderPathFilter_accept_FailWithDirPath() {
        TestClassFinderImpl.IteratePathFilter pathFilter = new TestClassFinderImpl.IteratePathFilter(this.classUnderTestWithoutMocks);
        File mockFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile.isFile()).thenReturn((Object)false);
        Assert.assertFalse((boolean)pathFilter.accept(mockFile, 1));
    }

    @DataProvider
    private static Object[][] _TestClassFinderPathFilter_accept_Pass_Data() {
        Pattern matchingPattern = Pattern.compile("^a$");
        Pattern notMatchingPattern = Pattern.compile("^b$");
        List<Object> emptyList = Arrays.asList(new Object[0]);
        return new Object[][]{{"a", Arrays.asList(matchingPattern), emptyList, true}, {"a", Arrays.asList(matchingPattern, matchingPattern), emptyList, true}, {"a", Arrays.asList(notMatchingPattern, matchingPattern), emptyList, true}, {"a", Arrays.asList(matchingPattern), Arrays.asList(notMatchingPattern), true}, {"a", Arrays.asList(matchingPattern, matchingPattern), Arrays.asList(notMatchingPattern), true}, {"a", Arrays.asList(notMatchingPattern, matchingPattern), Arrays.asList(notMatchingPattern), true}, {"a", Arrays.asList(matchingPattern), Arrays.asList(matchingPattern), false}, {"a", Arrays.asList(matchingPattern, matchingPattern), Arrays.asList(matchingPattern), false}, {"a", Arrays.asList(notMatchingPattern, matchingPattern), Arrays.asList(matchingPattern), false}, {"a", Arrays.asList(notMatchingPattern), Arrays.asList(matchingPattern), false}, {"a", Arrays.asList(notMatchingPattern), Arrays.asList(notMatchingPattern), false}};
    }

    @Test(dataProvider="_TestClassFinderPathFilter_accept_Pass_Data")
    public void TestClassFinderPathFilter_accept_Pass(String absPathname, List<Pattern> includePatternList, List<Pattern> excludePatternList, boolean expectedResult) {
        File mockFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile.isFile()).thenReturn((Object)true);
        Mockito.when((Object)mockFile.getAbsolutePath()).thenReturn((Object)absPathname);
        this.classUnderTestWithMocks = this.classUnderTestWithMocks.withIncludePatterns(includePatternList);
        if (!excludePatternList.isEmpty()) {
            this.classUnderTestWithMocks = this.classUnderTestWithMocks.withExcludePatterns(excludePatternList);
        }
        TestClassFinderImpl.IteratePathFilter pathFilter = new TestClassFinderImpl.IteratePathFilter(this.classUnderTestWithMocks);
        boolean actualResult = pathFilter.accept(mockFile, 1);
        Assert.assertEquals((boolean)actualResult, (boolean)expectedResult);
        this._assertLogger(SLF4JLogLevel.DEBUG, 1);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void TestClassFinderPathFilter_accept_FailWithNull() {
        new TestClassFinderImpl.IteratePathFilter(this.classUnderTestWithoutMocks).accept((File)null, 1);
    }

    private static class Class3 {
        private Class3() {
        }
    }

    private static abstract class AbstractClass2 {
        private AbstractClass2() {
        }
    }

    private static class Class1 {
        private Class1() {
        }
    }
}

