/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.testing;

import com.google.common.collect.ImmutableList;
import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ArrayArgs;
import com.googlecode.kevinarpe.papaya.argument.CollectionArgs;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.container.Lists2;
import com.googlecode.kevinarpe.papaya.exception.ClassNotFoundRuntimeException;
import com.googlecode.kevinarpe.papaya.filesystem.PathFilter;
import com.googlecode.kevinarpe.papaya.filesystem.TraversePathDepthPolicy;
import com.googlecode.kevinarpe.papaya.filesystem.TraversePathIterable;
import com.googlecode.kevinarpe.papaya.filesystem.TraversePathIterableFactory;
import com.googlecode.kevinarpe.papaya.filesystem.TraversePathIterableFactoryImpl;
import com.googlecode.kevinarpe.papaya.testing.SourceFileToClassHelper;
import com.googlecode.kevinarpe.papaya.testing.SourceFileToClassHelperImpl;
import com.googlecode.kevinarpe.papaya.testing.TestClassFinder;
import com.googlecode.kevinarpe.papaya.testing.TestClassFinderUtils;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FullyTested
final class TestClassFinderImpl
implements TestClassFinder {
    private final File _rootDirPath;
    private final List<Pattern> _includeByAbsolutePathPatternList;
    private final List<Pattern> _excludeByAbsolutePathPatternList;
    private final Logger _logger;
    private final TraversePathIterableFactory _traversePathIterableFactory;
    private final IteratePathFilterFactory _iteratePathFilterFactory;
    private final SourceFileToClassHelper _sourceFileToClassHelper;

    public TestClassFinderImpl() {
        this((TraversePathIterableFactory)TraversePathIterableFactoryImpl.INSTANCE, IteratePathFilterFactoryImpl.INSTANCE, SourceFileToClassHelperImpl.INSTANCE, LoggerFactory.getILoggerFactory());
    }

    public TestClassFinderImpl(TraversePathIterableFactory traversePathIterableFactory, IteratePathFilterFactory iteratePathFilterFactory, SourceFileToClassHelper sourceFileToClassHelper, ILoggerFactory loggerFactory) {
        this(TestClassFinderUtils.DEFAULT_ROOT_DIR_PATH, TestClassFinderUtils.DEFAULT_INCLUDE_PATTERN_LIST, TestClassFinderUtils.DEFAULT_EXCLUDE_PATTERN_LIST, TestClassFinderImpl._newLogger(loggerFactory), (TraversePathIterableFactory)ObjectArgs.checkNotNull((Object)traversePathIterableFactory, (String)"traversePathIterableFactory"), (IteratePathFilterFactory)ObjectArgs.checkNotNull((Object)iteratePathFilterFactory, (String)"iteratePathFilterFactory"), (SourceFileToClassHelper)ObjectArgs.checkNotNull((Object)sourceFileToClassHelper, (String)"sourceFileToClassHelper"));
    }

    private static Logger _newLogger(ILoggerFactory loggerFactory) {
        ObjectArgs.checkNotNull((Object)loggerFactory, (String)"loggerFactory");
        Logger x = loggerFactory.getLogger(TestClassFinderImpl.class.getName());
        return x;
    }

    private TestClassFinderImpl(File rootDirPath, List<Pattern> includeByFilePathPatternList, List<Pattern> excludeByFilePathPatternList, Logger logger, TraversePathIterableFactory traversePathIterableFactory, IteratePathFilterFactory iteratePathFilterFactory, SourceFileToClassHelper sourceFileToClassHelper) {
        this._rootDirPath = rootDirPath;
        this._includeByAbsolutePathPatternList = includeByFilePathPatternList;
        this._excludeByAbsolutePathPatternList = excludeByFilePathPatternList;
        this._logger = logger;
        this._traversePathIterableFactory = traversePathIterableFactory;
        this._iteratePathFilterFactory = iteratePathFilterFactory;
        this._sourceFileToClassHelper = sourceFileToClassHelper;
    }

    @Override
    public TestClassFinderImpl withRootDirPath(File rootDirPath) {
        ObjectArgs.checkNotNull((Object)rootDirPath, (String)"rootDirPath");
        TestClassFinderImpl x = new TestClassFinderImpl(rootDirPath, this._includeByAbsolutePathPatternList, this._excludeByAbsolutePathPatternList, this._logger, this._traversePathIterableFactory, this._iteratePathFilterFactory, this._sourceFileToClassHelper);
        return x;
    }

    @Override
    public File withRootDirPath() {
        return this._rootDirPath;
    }

    @Override
    public TestClassFinderImpl withIncludePatterns(Pattern filePathPattern, Pattern ... moreFilePathPatternsArr) {
        List<Pattern> list = this._toArrayList(filePathPattern, moreFilePathPatternsArr);
        TestClassFinder x = this.withIncludePatterns((List)list);
        return x;
    }

    @Override
    public TestClassFinderImpl withIncludePatterns(List<Pattern> filePathPatternList) {
        CollectionArgs.checkNotEmptyAndElementsNotNull(filePathPatternList, (String)"filePathPatternList");
        TestClassFinderImpl x = new TestClassFinderImpl(this._rootDirPath, (List<Pattern>)ImmutableList.copyOf(filePathPatternList), this._excludeByAbsolutePathPatternList, this._logger, this._traversePathIterableFactory, this._iteratePathFilterFactory, this._sourceFileToClassHelper);
        return x;
    }

    @Override
    public List<Pattern> withIncludePatterns() {
        return this._includeByAbsolutePathPatternList;
    }

    @Override
    public TestClassFinderImpl withExcludePatterns(Pattern filePathPattern, Pattern ... moreFilePathPatternsArr) {
        List<Pattern> list = this._toArrayList(filePathPattern, moreFilePathPatternsArr);
        TestClassFinder x = this.withExcludePatterns((List)list);
        return x;
    }

    @Override
    public TestClassFinderImpl withExcludePatterns(List<Pattern> filePathPatternList) {
        CollectionArgs.checkElementsNotNull(filePathPatternList, (String)"filePathPatternList");
        TestClassFinderImpl x = new TestClassFinderImpl(this._rootDirPath, this._includeByAbsolutePathPatternList, (List<Pattern>)ImmutableList.copyOf(filePathPatternList), this._logger, this._traversePathIterableFactory, this._iteratePathFilterFactory, this._sourceFileToClassHelper);
        return x;
    }

    @Override
    public List<Pattern> withExcludePatterns() {
        return this._excludeByAbsolutePathPatternList;
    }

    private List<Pattern> _toArrayList(Pattern filePathPattern, Pattern[] moreFilePathPatternsArr) {
        ObjectArgs.checkNotNull((Object)filePathPattern, (String)"filePathPattern");
        ArrayArgs.checkElementsNotNull((Object[])moreFilePathPatternsArr, (String)"moreFilePathPatternsArr");
        List list = Lists2.newUnmodifiableListFromOneOrMoreValues((Object)filePathPattern, (Object[])moreFilePathPatternsArr);
        return list;
    }

    @Override
    public List<Class<?>> findAsList() {
        TraversePathIterable pathIter = this._newTraversePathIterable();
        ArrayList classList = new ArrayList();
        this._logRootDirPath();
        for (File path : pathIter) {
            Class<?> clazz = this._getClass(path);
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            classList.add(clazz);
        }
        return classList;
    }

    @Override
    public Class<?>[] findAsArray() {
        List<Class<?>> classList = this.findAsList();
        Class[] classArr = new Class[classList.size()];
        classArr = classList.toArray(classArr);
        return classArr;
    }

    private TraversePathIterable _newTraversePathIterable() {
        PathFilter iteratePathFilter = this._iteratePathFilterFactory.newInstance(this);
        TraversePathIterable pathIterable = this._traversePathIterableFactory.newInstance(this._rootDirPath, TraversePathDepthPolicy.DEPTH_LAST);
        pathIterable = pathIterable.withOptionalIteratePathFilter(iteratePathFilter);
        return pathIterable;
    }

    private void _logRootDirPath() {
        if (this._rootDirPath.isAbsolute()) {
            this._logger.debug("Root dir path: '{}'", (Object)this._rootDirPath.getPath());
        } else {
            this._logger.debug("Root dir path: '{}' -> '{}'", (Object)this._rootDirPath.getPath(), (Object)this._rootDirPath.getAbsolutePath());
        }
    }

    private static boolean _isMatch(String pathname, List<Pattern> patternList) {
        for (Pattern pattern : patternList) {
            if (!pattern.matcher(pathname).find()) continue;
            return true;
        }
        return false;
    }

    private Class<?> _getClass(File path) {
        try {
            Class<?> clazz = this._sourceFileToClassHelper.getClass(path);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundRuntimeException(e);
        }
    }

    final class IteratePathFilter
    implements PathFilter {
        IteratePathFilter() {
        }

        public boolean accept(File path, int depth) {
            if (!path.isFile()) {
                return false;
            }
            String absPathname = path.getAbsolutePath();
            boolean include = TestClassFinderImpl._isMatch(absPathname, TestClassFinderImpl.this._includeByAbsolutePathPatternList);
            boolean exclude = TestClassFinderImpl._isMatch(absPathname, TestClassFinderImpl.this._excludeByAbsolutePathPatternList);
            this._logIsMatch(absPathname, include, exclude);
            boolean result = include && !exclude;
            return result;
        }

        private void _logIsMatch(String absPathname, boolean include, boolean exclude) {
            if (include && exclude) {
                TestClassFinderImpl.this._logger.debug(" include &&  exclude: '{}'", (Object)absPathname);
            }
            if (!include && exclude) {
                TestClassFinderImpl.this._logger.debug("!include &&  exclude: '{}'", (Object)absPathname);
            }
            if (include && !exclude) {
                TestClassFinderImpl.this._logger.debug(" include && !exclude: '{}'", (Object)absPathname);
            }
            if (!include && !exclude) {
                TestClassFinderImpl.this._logger.debug("!include && !exclude: '{}'", (Object)absPathname);
            }
        }
    }

    static final class IteratePathFilterFactoryImpl
    implements IteratePathFilterFactory {
        public static final IteratePathFilterFactoryImpl INSTANCE = new IteratePathFilterFactoryImpl();

        IteratePathFilterFactoryImpl() {
        }

        @Override
        public PathFilter newInstance(TestClassFinderImpl parent) {
            IteratePathFilter x = parent.new IteratePathFilter();
            return x;
        }
    }

    static interface IteratePathFilterFactory {
        public PathFilter newInstance(TestClassFinderImpl var1);
    }
}

