/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.testing;

import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.testing.SourceFileToClassHelper;
import java.io.File;

@FullyTested
final class SourceFileToClassHelperImpl
implements SourceFileToClassHelper {
    public static final SourceFileToClassHelperImpl INSTANCE = new SourceFileToClassHelperImpl();

    SourceFileToClassHelperImpl() {
    }

    @Override
    public Class<?> getClass(File sourceFilePath) throws ClassNotFoundException {
        File pathForIter = sourceFilePath;
        String className = this._getFileNameWithSuffix(pathForIter);
        while (true) {
            try {
                Class<?> klass = Class.forName(className);
                return klass;
            }
            catch (Throwable ignored) {
                boolean dummy = false;
                pathForIter = pathForIter.getParentFile();
                if (null == pathForIter) {
                    throw new ClassNotFoundException(String.format("Failed to find class for path: '%s'", sourceFilePath.getAbsolutePath()));
                }
                className = pathForIter.getName() + "." + className;
                continue;
            }
            break;
        }
    }

    private String _getFileNameWithSuffix(File path) {
        ObjectArgs.checkNotNull((Object)path, (String)"path");
        String fileName = path.getName();
        int dotIndex = fileName.lastIndexOf(46);
        if (-1 == dotIndex) {
            throw new IllegalArgumentException(String.format("Failed to find suffix: '%s'", path.getAbsolutePath()));
        }
        String baseFileName = fileName.substring(0, dotIndex);
        return baseFileName;
    }
}

