/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.exception;

import com.googlecode.kevinarpe.papaya.exception.DelegateExceptionTestHelper;
import java.util.UUID;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DelegateExceptionTestHelperTest {
    private DelegateExceptionTestHelper.ClassProxy mockClassProxy;
    private DelegateExceptionTestHelper.ConstructorProxy mockConstructorProxy;
    private DelegateExceptionTestHelper goodClassUnderTestWithoutMocks;
    private DelegateExceptionTestHelper goodClassUnderTestWithMocks;
    private DelegateExceptionTestHelper badClassUnderTestWithoutMocks;

    @BeforeMethod
    public void beforeEachTest() {
        this.mockClassProxy = (DelegateExceptionTestHelper.ClassProxy)Mockito.mock(DelegateExceptionTestHelper.ClassProxy.class);
        this.mockConstructorProxy = (DelegateExceptionTestHelper.ConstructorProxy)Mockito.mock(DelegateExceptionTestHelper.ConstructorProxy.class);
        this.goodClassUnderTestWithoutMocks = DelegateExceptionTestHelper.newInstance(GoodDelegateException.class);
        this.goodClassUnderTestWithMocks = DelegateExceptionTestHelper.newInstance(GoodDelegateException.class, (DelegateExceptionTestHelper.ClassProxy)this.mockClassProxy, (DelegateExceptionTestHelper.ConstructorProxy)this.mockConstructorProxy);
        this.badClassUnderTestWithoutMocks = DelegateExceptionTestHelper.newInstance(BadDelegateException.class);
    }

    @Test
    public void testCtorVoid_Pass() {
        this.goodClassUnderTestWithoutMocks.testCtorVoid();
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testCtorVoid_Fail() {
        this.badClassUnderTestWithoutMocks.testCtorVoid();
    }

    @Test
    public void testCtorString_Pass() {
        this.goodClassUnderTestWithoutMocks.testCtorString();
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testCtorString_Fail() {
        this.badClassUnderTestWithoutMocks.testCtorString();
    }

    @Test
    public void testCtorStringThrowable_Pass() {
        this.goodClassUnderTestWithoutMocks.testCtorStringThrowable();
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testCtorStringThrowable_Fail() {
        this.badClassUnderTestWithoutMocks.testCtorStringThrowable();
    }

    @Test
    public void testCtorThrowable_Pass() {
        this.goodClassUnderTestWithoutMocks.testCtorThrowable();
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testCtorThrowable_Fail() {
        this.badClassUnderTestWithoutMocks.testCtorThrowable();
    }

    private static class BadDelegateException
    extends Exception {
        public BadDelegateException() {
            super(UUID.randomUUID().toString());
        }

        public BadDelegateException(String message) {
            super(UUID.randomUUID().toString());
        }

        public BadDelegateException(String message, Throwable cause) {
            super(UUID.randomUUID().toString(), new Exception("other"));
        }

        public BadDelegateException(Throwable cause) {
            super(new Exception("other"));
        }

        @Override
        public String toString() {
            return UUID.randomUUID().toString();
        }
    }

    private static class GoodDelegateException
    extends Exception {
        public GoodDelegateException() {
        }

        public GoodDelegateException(String message) {
            super(message);
        }

        public GoodDelegateException(String message, Throwable cause) {
            super(message, cause);
        }

        public GoodDelegateException(Throwable cause) {
            super(cause);
        }
    }
}

