/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.exception;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.googlecode.kevinarpe.papaya.argument.ArrayArgs;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class DelegateExceptionTestHelper<TException extends Exception> {
    private final Class<TException> _exceptionClass;
    private final ClassProxy _classProxy;
    private final ConstructorProxy _constructorProxy;

    public static <TException2 extends Exception> DelegateExceptionTestHelper newInstance(Class<TException2> exceptionClass) {
        DelegateExceptionTestHelper<TException2> x = new DelegateExceptionTestHelper<TException2>(exceptionClass, ClassProxyImpl.INSTANCE, ConstructorProxyImpl.INSTANCE);
        return x;
    }

    static <TException2 extends Exception> DelegateExceptionTestHelper newInstance(Class<TException2> exceptionClass, ClassProxy classProxy, ConstructorProxy constructorProxy) {
        DelegateExceptionTestHelper<TException2> x = new DelegateExceptionTestHelper<TException2>(exceptionClass, classProxy, constructorProxy);
        return x;
    }

    private DelegateExceptionTestHelper(Class<TException> exceptionClass, ClassProxy classProxy, ConstructorProxy constructorProxy) {
        this._exceptionClass = (Class)ObjectArgs.checkNotNull(exceptionClass, (String)"exceptionClass");
        this._classProxy = (ClassProxy)ObjectArgs.checkNotNull((Object)classProxy, (String)"classProxy");
        this._constructorProxy = (ConstructorProxy)ObjectArgs.checkNotNull((Object)constructorProxy, (String)"constructorProxy");
    }

    public void runAllTests() {
        this.testCtorVoid();
        this.testCtorString();
        this.testCtorStringThrowable();
        this.testCtorThrowable();
    }

    public void testCtorVoid() {
        Constructor<TException> ctor = this._getCtor(new Class[0]);
        TException classUnderTest = this._newInstance(ctor, new Object[0]);
        this._assertMessage(classUnderTest, "", null);
        this._assertCause(classUnderTest, "", null);
        this._assertToString(classUnderTest, "");
    }

    public void testCtorString() {
        Constructor<TException> ctor = this._getCtor(String.class);
        String message = "dummy";
        TException classUnderTest = this._newInstance(ctor, "dummy");
        this._assertMessage(classUnderTest, "String", "dummy");
        this._assertCause(classUnderTest, "String", null);
    }

    public void testCtorStringThrowable() {
        Constructor<TException> ctor = this._getCtor(String.class, Throwable.class);
        String message = "dummy";
        Exception cause = new Exception("exception");
        TException classUnderTest = this._newInstance(ctor, "dummy", cause);
        this._assertMessage(classUnderTest, "String, Throwable", "dummy");
        this._assertCause(classUnderTest, "String, Throwable", cause);
    }

    public void testCtorThrowable() {
        Constructor<TException> ctor = this._getCtor(Throwable.class);
        Exception cause = new Exception("exception");
        TException classUnderTest = this._newInstance(ctor, cause);
        this._assertMessage(classUnderTest, "Throwable", cause.toString());
        this._assertCause(classUnderTest, "Throwable", cause);
    }

    private Constructor<TException> _getCtor(Class<?> ... paramTypeArr) {
        ArrayArgs.checkElementsNotNull((Object[])paramTypeArr, (String)"paramTypeArr");
        try {
            Constructor<TException> x = this._classProxy.getConstructor(this._exceptionClass, paramTypeArr);
            return x;
        }
        catch (NoSuchMethodException e) {
            String msg = String.format("Failed to find constructor: %s(%s)%nError: %s", this._exceptionClass.getName(), Joiner.on((String)", ").join((Object[])paramTypeArr), e.getMessage());
            throw new AssertionError((Object)msg);
        }
    }

    private TException _newInstance(Constructor<TException> ctor, Object ... argArr) {
        ObjectArgs.checkNotNull(ctor, (String)"ctor");
        ArrayArgs.checkElementsNotNull((Object[])argArr, (String)"argArr");
        try {
            Exception x = (Exception)this._constructorProxy.newInstance(ctor, argArr);
            return (TException)x;
        }
        catch (Exception e) {
            String msg = String.format("Failed to construct new instance: %s(%s)%nError: %s", this._exceptionClass.getName(), Joiner.on((String)", ").join(argArr), e.getMessage());
            throw new AssertionError((Object)msg);
        }
    }

    private void _assertMessage(TException classUnderTest, String ctorParamsDescription, String optionalExpectedMessage) {
        if (!Objects.equal((Object)optionalExpectedMessage, (Object)((Throwable)classUnderTest).getMessage())) {
            String msg = String.format("Constructor %s(%s) does not create new instance with expected message:%nExpected: '%s'%nActual  : '%s'", this._exceptionClass.getName(), ctorParamsDescription, optionalExpectedMessage, ((Throwable)classUnderTest).getMessage());
            throw new AssertionError((Object)msg);
        }
    }

    private void _assertCause(TException classUnderTest, String ctorParamsDescription, Throwable optionalExpectedCause) {
        if (optionalExpectedCause != ((Throwable)classUnderTest).getCause()) {
            String msg = String.format("Constructor %s(%s) does not create new instance with expected cause", this._exceptionClass.getName(), ctorParamsDescription);
            throw new AssertionError((Object)msg);
        }
    }

    private void _assertToString(TException classUnderTest, String ctorParamsDescription) {
        String actual;
        String s = classUnderTest.getClass().getName();
        String message = ((Throwable)classUnderTest).getLocalizedMessage();
        String expected = message != null ? s + ": " + message : s;
        if (!Objects.equal((Object)expected, (Object)(actual = ((Throwable)classUnderTest).toString()))) {
            String msg = String.format("Unexpected result from new %s(%s).toString()%nExpected: '%s'%nActual  : '%s'", this._exceptionClass.getName(), ctorParamsDescription, expected, actual);
            throw new AssertionError((Object)msg);
        }
    }

    static class ConstructorProxyImpl
    implements ConstructorProxy {
        public static final ConstructorProxyImpl INSTANCE = new ConstructorProxyImpl();

        ConstructorProxyImpl() {
        }

        @Override
        public <T> T newInstance(Constructor<T> ctor, Object ... argArr) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            T x = ctor.newInstance(argArr);
            return x;
        }
    }

    static class ClassProxyImpl
    implements ClassProxy {
        public static final ClassProxyImpl INSTANCE = new ClassProxyImpl();

        ClassProxyImpl() {
        }

        @Override
        public <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... paramTypeArr) throws NoSuchMethodException {
            Constructor<T> x = clazz.getConstructor(paramTypeArr);
            return x;
        }
    }

    static interface ConstructorProxy {
        public <T> T newInstance(Constructor<T> var1, Object ... var2) throws IllegalAccessException, InvocationTargetException, InstantiationException;
    }

    static interface ClassProxy {
        public <T> Constructor<T> getConstructor(Class<T> var1, Class<?> ... var2) throws NoSuchMethodException;
    }
}

