/*
 * Decompiled with CFR 0.152.
 */
package kiama.example.picojava.tests;

import java.rmi.RemoteException;
import junit.framework.TestCase;
import kiama.example.picojava.AbstractSyntax;
import kiama.example.picojava.Parser$;
import kiama.example.picojava.tests.ParserTests$;
import kiama.parsing.Parsers;
import org.scalatest.Assertions;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.Manifest;
import scala.runtime.BoxedCharArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserTests
extends TestCase
implements JUnit3Suite,
ScalaObject {
    private final String org$scalatest$Suite$$IgnoreAnnotation;
    private final String org$scalatest$Suite$$InformerInParens;
    private final String org$scalatest$Suite$$TestMethodPrefix;

    public ParserTests() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        JUnit3Suite.class.$init$((JUnit3Suite)this);
    }

    public <T> void assertParseError(String str, Parsers.Parser<T> p$2) {
        Parsers.ParseResult parseResult = Parser$.MODULE$.parse(new $anonfun$assertParseError$1(this, p$2), (CharSequence)str);
        if (parseResult instanceof Parsers.Success) {
            throw this.fail(new StringBuilder().append((Object)"expected to find parse error in ").append((Object)str).toString());
        }
        if (parseResult instanceof Parsers.Failure) {
            return;
        }
        throw new MatchError(parseResult);
    }

    public <T> void assertParseOk(String str, Parsers.Parser<T> p$1, T value) {
        Parsers.ParseResult parseResult = Parser$.MODULE$.parse(new $anonfun$assertParseOk$1(this, p$1), (CharSequence)str);
        if (parseResult instanceof Parsers.Success) {
            Parsers.Success success2 = (Parsers.Success)parseResult;
            Object t = success2.result();
            if (BoxesRunTime.equals(value, t)) {
                return;
            }
            throw this.fail(new StringBuilder().append((Object)"succeeded wrongly with ").append(t).toString());
        }
        if (parseResult instanceof Parsers.Failure) {
            throw this.fail(((Parsers.Failure)parseResult).toString());
        }
        throw new MatchError(parseResult);
    }

    public void testWhileStmtBlock() {
        this.assertParseError("{ while ( a ) { a = b; } }", Parser$.MODULE$.program());
    }

    public void testWhileStmt() {
        this.assertParseOk("{ while ( a ) a = b; }", Parser$.MODULE$.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AbstractSyntax.WhileStmt[]{new AbstractSyntax.WhileStmt(new AbstractSyntax.Use("a"), new AbstractSyntax.AssignStmt(new AbstractSyntax.Use("a"), new AbstractSyntax.Use("b")))})))));
    }

    public void testAssignStmtQualifiedRHS() {
        this.assertParseOk("{ a = b.c.d; }", Parser$.MODULE$.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AbstractSyntax.AssignStmt[]{new AbstractSyntax.AssignStmt(new AbstractSyntax.Use("a"), new AbstractSyntax.Dot(new AbstractSyntax.Dot(new AbstractSyntax.Use("b"), new AbstractSyntax.Use("c")), new AbstractSyntax.Use("d")))})))));
    }

    public void testAssignStmtQualifiedLHS() {
        this.assertParseOk("{ a.b.c = b; }", Parser$.MODULE$.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AbstractSyntax.AssignStmt[]{new AbstractSyntax.AssignStmt(new AbstractSyntax.Dot(new AbstractSyntax.Dot(new AbstractSyntax.Use("a"), new AbstractSyntax.Use("b")), new AbstractSyntax.Use("c")), new AbstractSyntax.Use("b"))})))));
    }

    public void testAssignStmt() {
        this.assertParseOk("{ a = b; }", Parser$.MODULE$.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AbstractSyntax.AssignStmt[]{new AbstractSyntax.AssignStmt(new AbstractSyntax.Use("a"), new AbstractSyntax.Use("b"))})))));
    }

    public void testVarDeclComplexName() {
        this.assertParseError("{ A.B.C a.b; }", Parser$.MODULE$.program());
    }

    public void testVarDeclQualifiedType() {
        this.assertParseOk("{ A.B.C a; }", Parser$.MODULE$.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AbstractSyntax.VarDecl[]{new AbstractSyntax.VarDecl("a", new AbstractSyntax.Dot(new AbstractSyntax.Dot(new AbstractSyntax.Use("A"), new AbstractSyntax.Use("B")), new AbstractSyntax.Use("C")))})))));
    }

    public void testVarDecl() {
        this.assertParseOk("{ A a; }", Parser$.MODULE$.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AbstractSyntax.VarDecl[]{new AbstractSyntax.VarDecl("a", new AbstractSyntax.Use("A"))})))));
    }

    public void testNestedClassDecl() {
        this.assertParseOk("{ class A { class B { } } }", Parser$.MODULE$.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AbstractSyntax.ClassDecl[]{new AbstractSyntax.ClassDecl("A", (Option<AbstractSyntax.IdUse>)None$.MODULE$, new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AbstractSyntax.ClassDecl[]{new AbstractSyntax.ClassDecl("B", (Option<AbstractSyntax.IdUse>)None$.MODULE$, new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)Nil$.MODULE$))}))))})))));
    }

    public void testClassDeclWithQualifiedExtends() {
        this.assertParseError("{ class A extends A.B { } }", Parser$.MODULE$.program());
    }

    public void testClassDeclWithExtends() {
        this.assertParseOk("{ class A extends B { } }", Parser$.MODULE$.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AbstractSyntax.ClassDecl[]{new AbstractSyntax.ClassDecl("A", (Option<AbstractSyntax.IdUse>)new Some((Object)new AbstractSyntax.Use("B")), new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)Nil$.MODULE$))})))));
    }

    public void testClassDecl() {
        this.assertParseOk("{ class A { } }", Parser$.MODULE$.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new AbstractSyntax.ClassDecl[]{new AbstractSyntax.ClassDecl("A", (Option<AbstractSyntax.IdUse>)None$.MODULE$, new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)Nil$.MODULE$))})))));
    }

    public void testSimpleSemi() {
        this.assertParseError(";", Parser$.MODULE$.program());
    }

    public void testSimpleBlock() {
        this.assertParseOk("{}", Parser$.MODULE$.program(), new AbstractSyntax.Program(new AbstractSyntax.Block((Seq<AbstractSyntax.BlockStmt>)Nil$.MODULE$)));
    }

    public void testInvalidTokens() {
        this.assertParseError("_a", Parser$.MODULE$.IDENTIFIER());
        this.assertParseError("1", Parser$.MODULE$.IDENTIFIER());
        this.assertParseError("1a", Parser$.MODULE$.IDENTIFIER());
        this.assertParseError("/* abc */", Parser$.MODULE$.comment());
    }

    public void testValidComments() {
        this.assertParseOk("// !@#$%^&*abc\n", Parser$.MODULE$.comment(), List$.MODULE$.apply((Seq)new BoxedCharArray(new char[]{' ', '!', '@', '#', '$', '%', '^', '&', '*', 'a', 'b', 'c'})));
    }

    public void testValidIdentifiers() {
        this.assertParseOk("a", Parser$.MODULE$.IDENTIFIER(), "a");
        this.assertParseOk("ab", Parser$.MODULE$.IDENTIFIER(), "ab");
        this.assertParseOk("a1", Parser$.MODULE$.IDENTIFIER(), "a1");
        this.assertParseOk("a1b", Parser$.MODULE$.IDENTIFIER(), "a1b");
        this.assertParseOk("a1b1", Parser$.MODULE$.IDENTIFIER(), "a1b1");
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }

    public Nothing$ fail(Throwable x$1) {
        return Assertions.class.fail((Assertions)this, (Throwable)x$1);
    }

    public Nothing$ fail(String x$1, Throwable x$2) {
        return Assertions.class.fail((Assertions)this, (String)x$1, (Throwable)x$2);
    }

    public Nothing$ fail(String x$1) {
        return Assertions.class.fail((Assertions)this, (String)x$1);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public void expect(Object x$1, Object x$2) {
        Assertions.class.expect((Assertions)this, (Object)x$1, (Object)x$2);
    }

    public void expect(Object x$1, Object x$2, Object x$3) {
        Assertions.class.expect((Assertions)this, (Object)x$1, (Object)x$2, (Object)x$3);
    }

    public Object intercept(Function0 x$1, Manifest x$2) {
        return Assertions.class.intercept((Assertions)this, (Function0)x$1, (Manifest)x$2);
    }

    public Object intercept(Class x$1, Function0 x$2) {
        return Assertions.class.intercept((Assertions)this, (Class)x$1, (Function0)x$2);
    }

    public Object intercept(Class x$1, Object x$2, Function0 x$3) {
        return Assertions.class.intercept((Assertions)this, (Class)x$1, (Object)x$2, (Function0)x$3);
    }

    public Assertions.Equalizer convertToEqualizer(Object x$1) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)x$1);
    }

    public void assert(Option x$1) {
        Assertions.class.assert((Assertions)this, (Option)x$1);
    }

    public void assert(Option x$1, Object x$2) {
        Assertions.class.assert((Assertions)this, (Option)x$1, (Object)x$2);
    }

    public void assert(boolean x$1, Object x$2) {
        Assertions.class.assert((Assertions)this, (boolean)x$1, (Object)x$2);
    }

    public void assert(boolean x$1) {
        Assertions.class.assert((Assertions)this, (boolean)x$1);
    }

    public Reporter wrapReporterIfNecessary(Reporter x$1) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)x$1);
    }

    public int expectedTestCount(Set x$1, Set x$2) {
        return Suite.class.expectedTestCount((Suite)this, (Set)x$1, (Set)x$2);
    }

    public String getTestNameForReport(String x$1) {
        return Suite.class.getTestNameForReport((Suite)this, (String)x$1);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public void runNestedSuites(Reporter x$1, Stopper x$2, Set x$3, Set x$4, Map x$5, Option x$6) {
        Suite.class.runNestedSuites((Suite)this, (Reporter)x$1, (Stopper)x$2, (Set)x$3, (Set)x$4, (Map)x$5, (Option)x$6);
    }

    public void runTests(Option x$1, Reporter x$2, Stopper x$3, Set x$4, Set x$5, Map x$6) {
        Suite.class.runTests((Suite)this, (Option)x$1, (Reporter)x$2, (Stopper)x$3, (Set)x$4, (Set)x$5, (Map)x$6);
    }

    public void runTest(String x$1, Reporter x$2, Stopper x$3, Map x$4) {
        Suite.class.runTest((Suite)this, (String)x$1, (Reporter)x$2, (Stopper)x$3, (Map)x$4);
    }

    public Set testNames() {
        return Suite.class.testNames((Suite)this);
    }

    public Map groups() {
        return Suite.class.groups((Suite)this);
    }

    public final void execute(String x$1) {
        Suite.class.execute((Suite)this, (String)x$1);
    }

    public final void execute() {
        Suite.class.execute((Suite)this);
    }

    public List nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public void org$scalatest$Suite$$IgnoreAnnotation_$eq(String x$1) {
        this.org$scalatest$Suite$$IgnoreAnnotation = x$1;
    }

    public void org$scalatest$Suite$$InformerInParens_$eq(String x$1) {
        this.org$scalatest$Suite$$InformerInParens = x$1;
    }

    public void org$scalatest$Suite$$TestMethodPrefix_$eq(String x$1) {
        this.org$scalatest$Suite$$TestMethodPrefix = x$1;
    }

    public final String org$scalatest$Suite$$IgnoreAnnotation() {
        return this.org$scalatest$Suite$$IgnoreAnnotation;
    }

    public final String org$scalatest$Suite$$InformerInParens() {
        return this.org$scalatest$Suite$$InformerInParens;
    }

    public final String org$scalatest$Suite$$TestMethodPrefix() {
        return this.org$scalatest$Suite$$TestMethodPrefix;
    }

    public void runJUnit(Reporter x$1) {
        JUnit3Suite.class.runJUnit((JUnit3Suite)this, (Reporter)x$1);
    }

    public void execute(Option x$1, Reporter x$2, Stopper x$3, Set x$4, Set x$5, Map x$6, Option x$7) {
        JUnit3Suite.class.execute((JUnit3Suite)this, (Option)x$1, (Reporter)x$2, (Stopper)x$3, (Set)x$4, (Set)x$5, (Map)x$6, (Option)x$7);
    }
}

