/*
 * Decompiled with CFR 0.152.
 */
package org.kiama.example.iswim.tests;

import org.junit.runner.RunWith;
import org.kiama.attribution.Attributable;
import org.kiama.attribution.Attribution$;
import org.kiama.example.iswim.compiler.CodeGenerator;
import org.kiama.example.iswim.compiler.CodeGenerator$class;
import org.kiama.example.iswim.compiler.Parser;
import org.kiama.example.iswim.compiler.Parser$Pos$;
import org.kiama.example.iswim.compiler.Parser$class;
import org.kiama.example.iswim.compiler.SemanticAnalysis;
import org.kiama.example.iswim.compiler.SemanticAnalysis$class;
import org.kiama.example.iswim.compiler.Syntax;
import org.kiama.example.iswim.driver.PrettyPrinter$;
import org.kiama.example.iswim.secd.BooleanOps;
import org.kiama.example.iswim.secd.HeapOps;
import org.kiama.example.iswim.secd.IntComparisonOps;
import org.kiama.example.iswim.secd.IntegerOps;
import org.kiama.example.iswim.secd.RecordOps;
import org.kiama.example.iswim.secd.SECDBase;
import org.kiama.example.iswim.secd.SECDBase$;
import org.kiama.example.iswim.secd.SECDBase$CodeSegment$;
import org.kiama.example.iswim.secd.SECDBase$CodeTree$;
import org.kiama.example.iswim.secd.StackOps;
import org.kiama.example.iswim.secd.StringOps;
import org.kiama.util.Tests;
import org.kiama.util.Tests$FocusTest$;
import org.kiama.util.Tests$class;
import org.scalatest.Assertions;
import org.scalatest.Engine;
import org.scalatest.FunSuite;
import org.scalatest.Suite;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scala.util.parsing.combinator.JavaTokenParsers;
import scala.util.parsing.combinator.PackratParsers;
import scala.util.parsing.combinator.PackratParsers$Head$;
import scala.util.parsing.combinator.PackratParsers$LR$;
import scala.util.parsing.combinator.PackratParsers$MemoEntry$;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.combinator.Parsers$$tilde$;
import scala.util.parsing.combinator.Parsers$Error$;
import scala.util.parsing.combinator.Parsers$Failure$;
import scala.util.parsing.combinator.Parsers$NoSuccess$;
import scala.util.parsing.combinator.Parsers$Success$;
import scala.util.parsing.combinator.RegexParsers;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0001\u0002\u0001\u001b\t\u00112i\u001c3f\u000f\u0016tWM]1u_J$Vm\u001d;t\u0015\t\u0019A!A\u0003uKN$8O\u0003\u0002\u0006\r\u0005)\u0011n]<j[*\u0011q\u0001C\u0001\bKb\fW\u000e\u001d7f\u0015\tI!\"A\u0003lS\u0006l\u0017MC\u0001\f\u0003\ry'oZ\u0002\u0001'\u001d\u0001aB\u0006\u000f#K!\u0002\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ii\u0011\u0001\u0007\u0006\u00033!\tA!\u001e;jY&\u00111\u0004\u0007\u0002\u0006)\u0016\u001cHo\u001d\t\u0003;\u0001j\u0011A\b\u0006\u0003?\u0011\t\u0001bY8na&dWM]\u0005\u0003Cy\u0011QbQ8eK\u001e+g.\u001a:bi>\u0014\bCA\u000f$\u0013\t!cD\u0001\tTK6\fg\u000e^5d\u0003:\fG._:jgB\u0011QDJ\u0005\u0003Oy\u0011a\u0001U1sg\u0016\u0014\bCA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#aC*dC2\fwJ\u00196fGRDQa\f\u0001\u0005\u0002A\na\u0001P5oSRtD#A\u0019\u0011\u0005I\u0002Q\"\u0001\u0002)\t\u0001!D(\u0010\t\u0003kij\u0011A\u000e\u0006\u0003oa\naA];o]\u0016\u0014(BA\u001d\u000b\u0003\u0015QWO\\5u\u0013\tYdGA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0003y\u0002\"aP\"\u000e\u0003\u0001S!!O!\u000b\u0005\tS\u0011!C:dC2\fG/Z:u\u0013\t!\u0005IA\u0006K+:LGOU;o]\u0016\u0014\b")
public class CodeGeneratorTests
implements Tests,
CodeGenerator,
SemanticAnalysis,
Parser,
ScalaObject {
    private final HashSet<String> reserved;
    private final Regex identRegex;
    private final Regex intRegex;
    private final Parsers.Parser<Syntax.Variable> variable;
    private final Parsers.Parser<Syntax.Expr> liter;
    private final PackratParsers.PackratParser<Syntax.IswimProg> start;
    private final PackratParsers.PackratParser<Syntax.Expr> expr;
    private final PackratParsers.PackratParser<Syntax.Expr> parenexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> factor;
    private final PackratParsers.PackratParser<Syntax.Expr> applic;
    private final PackratParsers.PackratParser<Syntax.Expr> term1;
    private final PackratParsers.PackratParser<Syntax.Expr> term2;
    private final PackratParsers.PackratParser<Syntax.Expr> term3;
    private final PackratParsers.PackratParser<Syntax.Expr> term4;
    private final PackratParsers.PackratParser<Syntax.Expr> emptyexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> tupleexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> matchexpr;
    private final PackratParsers.PackratParser<Tuple2<Parser.Pos, List<Syntax.Variable>>> pattern;
    private final PackratParsers.PackratParser<Syntax.MatchClause> matchclause;
    private final PackratParsers.PackratParser<Syntax.Expr> blockexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> lambdaexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> returnexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> letexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> letrecexpr;
    private final PackratParsers.PackratParser<Syntax.Stmt> letstmt;
    private final PackratParsers.PackratParser<Syntax.Stmt> letrecstmt;
    private final PackratParsers.PackratParser<Syntax.Stmt> exprstmt;
    private final PackratParsers.PackratParser<Syntax.Stmt> importstmt;
    private final PackratParsers.PackratParser<Syntax.Expr> ifelseexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> whileexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> callccexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> throwtoexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> valexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> mkrefexpr;
    private final PackratParsers.PackratParser<Syntax.Stmt> primstmt;
    private final Regex whiteSpace;
    private Parsers.NoSuccess lastNoSuccess;
    private final Function1<Syntax.Iswim, Map<Syntax.Variable, Syntax.Iswim>> envir;
    private final Function1<Syntax.Iswim, Map<Syntax.Variable, Syntax.Iswim>> envirOut;
    private final Function1<Syntax.MatchClause, Object> unreachable;
    private final Function1<Syntax.Iswim, Object> isSemanticallyCorrect;
    private final Function1<Syntax.Iswim, SECDBase.CodeTree> code;
    private final Engine org$scalatest$FunSuite$$engine;
    public volatile int bitmap$0;
    private volatile Parser$Pos$ Pos$module;
    public volatile int bitmap$1;
    private volatile PackratParsers$MemoEntry$ scala$util$parsing$combinator$PackratParsers$$MemoEntry$module;
    private volatile PackratParsers$LR$ scala$util$parsing$combinator$PackratParsers$$LR$module;
    private volatile PackratParsers$Head$ scala$util$parsing$combinator$PackratParsers$$Head$module;
    private volatile Parsers$Success$ Success$module;
    private volatile Parsers$NoSuccess$ NoSuccess$module;
    private volatile Parsers$Failure$ Failure$module;
    private volatile Parsers$Error$ Error$module;
    private volatile Parsers$$tilde$ $tilde$module;
    private volatile Tests$FocusTest$ FocusTest$module;

    public CodeGeneratorTests() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        FunSuite.class.$init$((FunSuite)this);
        Tests$class.$init$(this);
        CodeGenerator$class.$init$(this);
        SemanticAnalysis$class.$init$(this);
        Parsers.class.$init$((Parsers)this);
        RegexParsers.class.$init$((RegexParsers)this);
        JavaTokenParsers.class.$init$((JavaTokenParsers)this);
        PackratParsers.class.$init$((PackratParsers)this);
        Parser$class.$init$(this);
        this.test("compile a simple arithmetic expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "10 + x * 42");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                this.$outer.assert(this.$outer.convertToEqualizer(result).$eq$eq$eq((Object)SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new IntegerOps.PushInt(10), new SECDBase.Lookup("x"), new IntegerOps.PushInt(42), new IntegerOps.Mult(), new IntegerOps.Add()}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile a simple boolean expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "true & x | y");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                this.$outer.assert(this.$outer.convertToEqualizer(result).$eq$eq$eq((Object)SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new BooleanOps.PushTrue(), new BooleanOps.Test(SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.Lookup("x")})), SECDBase$.MODULE$.toCodeSegment(new BooleanOps.PushFalse())), new BooleanOps.Test(SECDBase$.MODULE$.toCodeSegment(new BooleanOps.PushTrue()), SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.Lookup("y")})))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile a boolean comparison expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "(a == 20) | (b != 30) & (a > b)");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                this.$outer.assert(this.$outer.convertToEqualizer(result).$eq$eq$eq((Object)SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.Lookup("a"), new IntegerOps.PushInt(20), new BooleanOps.Equals(), new BooleanOps.Test(SECDBase$.MODULE$.toCodeSegment(new BooleanOps.PushTrue()), SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.Lookup("b"), new IntegerOps.PushInt(30), new BooleanOps.Equals(), new BooleanOps.Test(SECDBase$.MODULE$.toCodeSegment(new BooleanOps.PushFalse()), SECDBase$.MODULE$.toCodeSegment(new BooleanOps.PushTrue())), new BooleanOps.Test(SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.Lookup("a"), new SECDBase.Lookup("b"), new StackOps.Swap(1, 1), new IntComparisonOps.LessThan()})), SECDBase$.MODULE$.toCodeSegment(new BooleanOps.PushFalse()))})))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile a let expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "let x = 10 and y = 22 + 11 in x * y");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                this.$outer.assert(BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect())));
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                this.$outer.assert(this.$outer.convertToEqualizer(result).$eq$eq$eq((Object)SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new IntegerOps.PushInt(10), new IntegerOps.PushInt(22), new IntegerOps.PushInt(11), new IntegerOps.Add(), new SECDBase.Enter((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "y"}))), new SECDBase.Lookup("x"), new SECDBase.Lookup("y"), new IntegerOps.Mult(), new SECDBase.Exit()}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile a letrec expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "letrec f = fun(n) (n + 1) and g = fun(m) (m - 1) in f");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                this.$outer.assert(BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect())));
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                this.$outer.assert(this.$outer.convertToEqualizer(result).$eq$eq$eq((Object)SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.MkClosures((List<SECDBase.FunctionSpec>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.FunctionSpec[]{new SECDBase.FunctionSpec((Option<String>)new Some((Object)"f"), "n", SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.Lookup("n"), new IntegerOps.PushInt(1), new IntegerOps.Add()}))), new SECDBase.FunctionSpec((Option<String>)new Some((Object)"g"), "m", SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.Lookup("m"), new IntegerOps.PushInt(1), new IntegerOps.Sub()})))}))), new SECDBase.Enter((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f", "g"}))), new SECDBase.Lookup("f"), new SECDBase.Exit()}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile a tuple expressio", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "(10,20,(),30)");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                this.$outer.assert(BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect())));
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                this.$outer.assert(this.$outer.convertToEqualizer(result).$eq$eq$eq((Object)SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new IntegerOps.PushInt(10), new IntegerOps.PushInt(20), new SECDBase.PushEmpty(), new IntegerOps.PushInt(30), new RecordOps.MkRecord(4)}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile a let binding of a lambda expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "let f = fun(n) (n + 1) and g = fun(m) (m - 1) in f(g(10))");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                this.$outer.assert(BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect())));
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                this.$outer.assert(this.$outer.convertToEqualizer(result).$eq$eq$eq((Object)SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.MkClosures((List<SECDBase.FunctionSpec>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.FunctionSpec[]{new SECDBase.FunctionSpec((Option<String>)None$.MODULE$, "n", SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.Lookup("n"), new IntegerOps.PushInt(1), new IntegerOps.Add()})))}))), new SECDBase.MkClosures((List<SECDBase.FunctionSpec>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.FunctionSpec[]{new SECDBase.FunctionSpec((Option<String>)None$.MODULE$, "m", SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.Lookup("m"), new IntegerOps.PushInt(1), new IntegerOps.Sub()})))}))), new SECDBase.Enter((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f", "g"}))), new IntegerOps.PushInt(10), new SECDBase.Lookup("g"), new SECDBase.App(), new SECDBase.Lookup("f"), new SECDBase.App(), new SECDBase.Exit()}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile some function applications", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "f(10 + g(h(k)))");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                this.$outer.assert(this.$outer.convertToEqualizer(result).$eq$eq$eq((Object)SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new IntegerOps.PushInt(10), new SECDBase.Lookup("k"), new SECDBase.Lookup("h"), new SECDBase.App(), new SECDBase.Lookup("g"), new SECDBase.App(), new IntegerOps.Add(), new SECDBase.Lookup("f"), new SECDBase.App()}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile a block expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "{10;20;\"hello\";();22} + {true}");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                this.$outer.assert(BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect())));
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                this.$outer.assert(this.$outer.convertToEqualizer(result).$eq$eq$eq((Object)SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new IntegerOps.PushInt(10), new StackOps.Pop(1), new IntegerOps.PushInt(20), new StackOps.Pop(1), new StringOps.PushString("hello"), new StackOps.Pop(1), new SECDBase.PushEmpty(), new StackOps.Pop(1), new IntegerOps.PushInt(22), new BooleanOps.PushTrue(), new IntegerOps.Add()}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile a simple while loop - count from 1 to 20", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "\n    let c = mkref 0\n    in while (val c < 20) {\n        c := val c + 1\n    }\n");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                this.$outer.assert(BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect())));
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                this.$outer.assert(this.$outer.convertToEqualizer(result).$eq$eq$eq((Object)SECDBase$CodeSegment$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new HeapOps.Alloc(), new StackOps.Dup(1), new IntegerOps.PushInt(0), new HeapOps.Put(), new SECDBase.Enter((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))), new SECDBase.MkClosures((List<SECDBase.FunctionSpec>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.FunctionSpec[]{new SECDBase.FunctionSpec((Option<String>)None$.MODULE$, "@loop", SECDBase$.MODULE$.toCodeSegment(SECDBase$CodeTree$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.Lookup("c"), new HeapOps.Get(), new IntegerOps.PushInt(20), new IntComparisonOps.LessThan(), new BooleanOps.Test(SECDBase$.MODULE$.toCodeSegment(SECDBase$CodeTree$.MODULE$.apply((Seq<SECDBase.ByteCodeBase>)Predef$.MODULE$.wrapRefArray((Object[])new SECDBase.ByteCodeBase[]{new SECDBase.Lookup("c"), new SECDBase.Lookup("c"), new HeapOps.Get(), new IntegerOps.PushInt(1), new IntegerOps.Add(), new StackOps.Dup(1), new StackOps.Swap(1, 2), new HeapOps.Put(), new SECDBase.Lookup("@loop"), new StackOps.Dup(1), new SECDBase.TailApp()}))), SECDBase$.MODULE$.toCodeSegment(new SECDBase.PushEmpty()))}))))}))), new StackOps.Dup(1), new SECDBase.App(), new SECDBase.Exit()}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile a simple match expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "\n    (1,2) match {\n        (x,y,z)     -> x * y + z;\n        ()          -> 20\n    }\n");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                this.$outer.assert(BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect())));
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                Attribution$.MODULE$.initTree((Attributable)result);
                String p = PrettyPrinter$.MODULE$.pretty(result);
                this.$outer.assert(this.$outer.convertToEqualizer(p).$eq$eq$eq((Object)"CodeSegment(\n    1: PushInt(1),\n    2: PushInt(2),\n    3: MkRecord(2),\n    4: Dup(1),\n    5: GetType(),\n    6: Dup(1),\n    7: PushType(RecordTypeValue),\n    8: Equals(),\n    9: Swap(1,1),\n    10: PushType(EmptyTypeValue),\n    11: Equals(),\n    12: Test(\n        CodeSegment(13: Pop(1), 14: PushInt(0)),\n        CodeSegment(\n            15: Test(\n                CodeSegment(16: Dup(1), 17: Fields()),\n                CodeSegment(18: PushInt(1))))),\n    19: Dup(1),\n    20: PushInt(3),\n    21: Equals(),\n    22: Test(\n        CodeSegment(\n            23: Pop(1),\n            24: UnpackRecord(),\n            25: Enter(List(x, y, z)),\n            26: Lookup(x),\n            27: Lookup(y),\n            28: Mult(),\n            29: Lookup(z),\n            30: Add(),\n            31: Exit()),\n        CodeSegment(\n            32: Dup(1),\n            33: PushInt(0),\n            34: Equals(),\n            35: Test(\n                CodeSegment(36: Pop(2), 37: PushInt(20)),\n                CodeSegment(\n                    38: PushMachineException(MachineExceptionValue: match error, value not matched at <undefined position>),\n                    39: RaiseException())))))"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile a simple, but complete, program", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final CodeGeneratorTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.start(), "\n        /*\n         * Title:       Fibonacci fun\n         * Description: A very simple imperative Fibonacci function with driver.\n         * Copyright:   (c) 2010-2012 Dominic Verity, Macquarie University\n         */\n\n        // declare preloaded primitives\n        primitives write, read, fields, type;\n\n        // Imperative fibonacci function\n        letrec fib = fun(n)\n            let r1 = mkref 0\n            and r2 = mkref 1\n            and r3 = mkref (-1)\n            in  letrec f = fun(m)\n                    if (m == 0)\n                        val r1\n                    else {\n                        r3 := val r1 + val r2;\n                        r1 := val r2;\n                        r2 := val r3;\n                        f (m-1) }\n                in f n;\n\n        // Execute an example and print the result.\n        {\n            write (fib 200);\n            write \"\\n\"\n        }\n");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                this.$outer.assert(BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect())));
                SECDBase.CodeSegment result = SECDBase$.MODULE$.toCodeSegment((SECDBase.ByteCodeBase)this.$outer.code().apply(prog.get()));
                Attribution$.MODULE$.initTree((Attributable)result);
                String p = PrettyPrinter$.MODULE$.pretty(result);
                this.$outer.assert(this.$outer.convertToEqualizer(p).$eq$eq$eq((Object)"CodeSegment(\n    1: BindPrims(List(write, read, fields, type)),\n    2: MkClosures(\n        FunctionSpec(\n            fib,\n            n,\n            CodeSegment(\n                3: Alloc(),\n                4: Dup(1),\n                5: PushInt(0),\n                6: Put(),\n                7: Alloc(),\n                8: Dup(1),\n                9: PushInt(1),\n                10: Put(),\n                11: Alloc(),\n                12: Dup(1),\n                13: PushInt(0),\n                14: PushInt(1),\n                15: Sub(),\n                16: Put(),\n                17: Enter(List(r1, r2, r3)),\n                18: MkClosures(\n                    FunctionSpec(\n                        f,\n                        m,\n                        CodeSegment(\n                            19: Lookup(m),\n                            20: PushInt(0),\n                            21: Equals(),\n                            22: Test(\n                                CodeSegment(23: Lookup(r1), 24: Get()),\n                                CodeSegment(\n                                    25: Lookup(r3),\n                                    26: Lookup(r1),\n                                    27: Get(),\n                                    28: Lookup(r2),\n                                    29: Get(),\n                                    30: Add(),\n                                    31: Dup(1),\n                                    32: Swap(1,2),\n                                    33: Put(),\n                                    34: Pop(1),\n                                    35: Lookup(r1),\n                                    36: Lookup(r2),\n                                    37: Get(),\n                                    38: Dup(1),\n                                    39: Swap(1,2),\n                                    40: Put(),\n                                    41: Pop(1),\n                                    42: Lookup(r2),\n                                    43: Lookup(r3),\n                                    44: Get(),\n                                    45: Dup(1),\n                                    46: Swap(1,2),\n                                    47: Put(),\n                                    48: Pop(1),\n                                    49: Lookup(m),\n                                    50: PushInt(1),\n                                    51: Sub(),\n                                    52: Lookup(f),\n                                    53: App()))))),\n                54: Enter(List(f)),\n                55: Lookup(n),\n                56: Lookup(f),\n                57: App(),\n                58: Exit(),\n                59: Exit()))),\n    60: Enter(List(fib)),\n    61: PushInt(200),\n    62: Lookup(fib),\n    63: App(),\n    64: Lookup(write),\n    65: App(),\n    66: Pop(1),\n    67: PushString(\\n),\n    68: Lookup(write),\n    69: App(),\n    70: Exit(),\n    71: Exit())"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

