/*
 * Decompiled with CFR 0.152.
 */
package org.kiama.example.iswim.tests;

import org.junit.runner.RunWith;
import org.kiama.example.iswim.compiler.Parser;
import org.kiama.example.iswim.compiler.Parser$Pos$;
import org.kiama.example.iswim.compiler.Parser$class;
import org.kiama.example.iswim.compiler.Syntax;
import org.kiama.util.RegexParserTests;
import org.kiama.util.RegexParserTests$class;
import org.kiama.util.Tests$FocusTest$;
import org.kiama.util.Tests$class;
import org.scalatest.Assertions;
import org.scalatest.Engine;
import org.scalatest.FunSuite;
import org.scalatest.Suite;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;
import scala.util.parsing.combinator.JavaTokenParsers;
import scala.util.parsing.combinator.PackratParsers;
import scala.util.parsing.combinator.PackratParsers$Head$;
import scala.util.parsing.combinator.PackratParsers$LR$;
import scala.util.parsing.combinator.PackratParsers$MemoEntry$;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.combinator.Parsers$$tilde$;
import scala.util.parsing.combinator.Parsers$Error$;
import scala.util.parsing.combinator.Parsers$Failure$;
import scala.util.parsing.combinator.Parsers$NoSuccess$;
import scala.util.parsing.combinator.Parsers$Success$;
import scala.util.parsing.combinator.RegexParsers;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u001b\tY\u0001+\u0019:tKJ$Vm\u001d;t\u0015\t\u0019A!A\u0003uKN$8O\u0003\u0002\u0006\r\u0005)\u0011n]<j[*\u0011q\u0001C\u0001\bKb\fW\u000e\u001d7f\u0015\tI!\"A\u0003lS\u0006l\u0017MC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0015\u0001aB\u0006\u000f#!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u001b\u001b\u0005A\"BA\r\t\u0003\u0011)H/\u001b7\n\u0005mA\"\u0001\u0005*fO\u0016D\b+\u0019:tKJ$Vm\u001d;t!\ti\u0002%D\u0001\u001f\u0015\tyB!\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0013\t\tcD\u0001\u0004QCJ\u001cXM\u001d\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003*\u0001\u0011\u0005!&\u0001\u0004=S:LGO\u0010\u000b\u0002WA\u0011A\u0006A\u0007\u0002\u0005!\"\u0001A\f\u001c8!\tyC'D\u00011\u0015\t\t$'\u0001\u0004sk:tWM\u001d\u0006\u0003g)\tQA[;oSRL!!\u000e\u0019\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\n\u0001\b\u0005\u0002:{5\t!H\u0003\u00024w)\u0011AHC\u0001\ng\u000e\fG.\u0019;fgRL!A\u0010\u001e\u0003\u0017)+f.\u001b;Sk:tWM\u001d")
public class ParserTests
implements RegexParserTests,
Parser,
ScalaObject {
    private final HashSet<String> reserved;
    private final Regex identRegex;
    private final Regex intRegex;
    private final Parsers.Parser<Syntax.Variable> variable;
    private final Parsers.Parser<Syntax.Expr> liter;
    private final PackratParsers.PackratParser<Syntax.IswimProg> start;
    private final PackratParsers.PackratParser<Syntax.Expr> expr;
    private final PackratParsers.PackratParser<Syntax.Expr> parenexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> factor;
    private final PackratParsers.PackratParser<Syntax.Expr> applic;
    private final PackratParsers.PackratParser<Syntax.Expr> term1;
    private final PackratParsers.PackratParser<Syntax.Expr> term2;
    private final PackratParsers.PackratParser<Syntax.Expr> term3;
    private final PackratParsers.PackratParser<Syntax.Expr> term4;
    private final PackratParsers.PackratParser<Syntax.Expr> emptyexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> tupleexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> matchexpr;
    private final PackratParsers.PackratParser<Tuple2<Parser.Pos, List<Syntax.Variable>>> pattern;
    private final PackratParsers.PackratParser<Syntax.MatchClause> matchclause;
    private final PackratParsers.PackratParser<Syntax.Expr> blockexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> lambdaexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> returnexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> letexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> letrecexpr;
    private final PackratParsers.PackratParser<Syntax.Stmt> letstmt;
    private final PackratParsers.PackratParser<Syntax.Stmt> letrecstmt;
    private final PackratParsers.PackratParser<Syntax.Stmt> exprstmt;
    private final PackratParsers.PackratParser<Syntax.Stmt> importstmt;
    private final PackratParsers.PackratParser<Syntax.Expr> ifelseexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> whileexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> callccexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> throwtoexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> valexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> mkrefexpr;
    private final PackratParsers.PackratParser<Syntax.Stmt> primstmt;
    private final Regex whiteSpace;
    private Parsers.NoSuccess lastNoSuccess;
    private final Engine org$scalatest$FunSuite$$engine;
    public volatile int bitmap$0;
    private volatile Parser$Pos$ Pos$module;
    public volatile int bitmap$1;
    private volatile PackratParsers$MemoEntry$ scala$util$parsing$combinator$PackratParsers$$MemoEntry$module;
    private volatile PackratParsers$LR$ scala$util$parsing$combinator$PackratParsers$$LR$module;
    private volatile PackratParsers$Head$ scala$util$parsing$combinator$PackratParsers$$Head$module;
    private volatile Parsers$Success$ Success$module;
    private volatile Parsers$NoSuccess$ NoSuccess$module;
    private volatile Parsers$Failure$ Failure$module;
    private volatile Parsers$Error$ Error$module;
    private volatile Parsers$$tilde$ $tilde$module;
    private volatile Tests$FocusTest$ FocusTest$module;

    public ParserTests() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        FunSuite.class.$init$((FunSuite)this);
        Tests$class.$init$(this);
        RegexParserTests$class.$init$(this);
        Parsers.class.$init$((Parsers)this);
        RegexParsers.class.$init$((RegexParsers)this);
        JavaTokenParsers.class.$init$((JavaTokenParsers)this);
        PackratParsers.class.$init$((PackratParsers)this);
        Parser$class.$init$(this);
        this.test("parse a 0-tuple", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("()", this.$outer.expr(), new Syntax.Empty());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a 2-tuple of manifest boolean values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("(true,true)", this.$outer.expr(), new Syntax.Tuple((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.BoolVal[]{new Syntax.BoolVal(true), new Syntax.BoolVal(true)}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a 4-tuple of manifest boolean values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("(true,false,false,true)", this.$outer.expr(), new Syntax.Tuple((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.BoolVal[]{new Syntax.BoolVal(true), new Syntax.BoolVal(false), new Syntax.BoolVal(false), new Syntax.BoolVal(true)}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse nested tuples of manifest boolean values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("(true,(false,false),true)", this.$outer.expr(), new Syntax.Tuple((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Expr[]{new Syntax.BoolVal(true), new Syntax.Tuple((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.BoolVal[]{new Syntax.BoolVal(false), new Syntax.BoolVal(false)}))), new Syntax.BoolVal(true)}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse error: tuple missing open bracket", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("true,false)", this.$outer.expr(), 1, 5, "string matching regex `\\z' expected but `,' found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse error: tuple missing close bracket", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("(true,()", this.$outer.expr(), 1, 9, "operator \")\" expected", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a tuple of literal integers and boolean values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("(1,true,3,-5)", this.$outer.expr(), new Syntax.Tuple((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Expr[]{new Syntax.NumVal(1), new Syntax.BoolVal(true), new Syntax.NumVal(3), new Syntax.Negate(new Syntax.NumVal(5))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a simple arithmetic expression (1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("1 + 2 * 3 + 4 * (5- 4 + 7 % -2) / 6", this.$outer.expr(), new Syntax.Plus(new Syntax.Plus(new Syntax.NumVal(1), new Syntax.Times(new Syntax.NumVal(2), new Syntax.NumVal(3))), new Syntax.Divide(new Syntax.Times(new Syntax.NumVal(4), new Syntax.Plus(new Syntax.Minus(new Syntax.NumVal(5), new Syntax.NumVal(4)), new Syntax.Remainder(new Syntax.NumVal(7), new Syntax.Negate(new Syntax.NumVal(2))))), new Syntax.NumVal(6))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a simple arithmetic expression (2)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("1+2*3+4*(dom-4+7%-2)/6", this.$outer.expr(), new Syntax.Plus(new Syntax.Plus(new Syntax.NumVal(1), new Syntax.Times(new Syntax.NumVal(2), new Syntax.NumVal(3))), new Syntax.Divide(new Syntax.Times(new Syntax.NumVal(4), new Syntax.Plus(new Syntax.Minus(new Syntax.Variable("dom"), new Syntax.NumVal(4)), new Syntax.Remainder(new Syntax.NumVal(7), new Syntax.Negate(new Syntax.NumVal(2))))), new Syntax.NumVal(6))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("attempt to parse a keyword as a variable name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("callcc", this.$outer.variable(), 1, 7, "keyword \"callcc\" found where variable name expected", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a variable name whose prefix is a keyword", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("elseifvar", this.$outer.variable(), new Syntax.Variable("elseifvar"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("attempted parse of non-matching keyword", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("else", this.$outer.keyword("if"), 1, 5, "keyword \"if\" expected", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("attempted parse of matching keyword from front of variable name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("elseifvar", this.$outer.keyword("else"), 1, 10, "keyword \"else\" expected", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a match clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("(dom,sal) -> sal * dom + 1", this.$outer.matchclause(), new Syntax.MatchClause(new Syntax.Pattern((List<Syntax.Variable>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Variable[]{new Syntax.Variable("dom"), new Syntax.Variable("sal")}))), new Syntax.Plus(new Syntax.Times(new Syntax.Variable("sal"), new Syntax.Variable("dom")), new Syntax.NumVal(1))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("attempt to parse a match clause with a bad pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("(1,x) -> 1", this.$outer.matchclause(), 1, 2, "variable name expected", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("attempt to parse a letrec which binds a non-lambda expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("letrec x = fun(y) (x y) and z = x in (x 10)", this.$outer.expr(), 1, 34, "keyword \"fun\" expected", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a match expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("\n(dom 10) match {\n    ()      -> 0;\n    x       -> x;\n    (x,y,z) -> x * y + z\n}\n", this.$outer.expr(), new Syntax.Match(new Syntax.Apply(new Syntax.Variable("dom"), new Syntax.NumVal(10)), (List<Syntax.MatchClause>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.MatchClause[]{new Syntax.MatchClause(new Syntax.Pattern((List<Syntax.Variable>)Nil$.MODULE$), new Syntax.NumVal(0)), new Syntax.MatchClause(new Syntax.Pattern((List<Syntax.Variable>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Variable[]{new Syntax.Variable("x")}))), new Syntax.Variable("x")), new Syntax.MatchClause(new Syntax.Pattern((List<Syntax.Variable>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Variable[]{new Syntax.Variable("x"), new Syntax.Variable("y"), new Syntax.Variable("z")}))), new Syntax.Plus(new Syntax.Times(new Syntax.Variable("x"), new Syntax.Variable("y")), new Syntax.Variable("z")))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a sequence of function applications", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("dom 10 (sal + flo * 10) herb (10,30)", this.$outer.expr(), new Syntax.Apply(new Syntax.Apply(new Syntax.Apply(new Syntax.Apply(new Syntax.Variable("dom"), new Syntax.NumVal(10)), new Syntax.Plus(new Syntax.Variable("sal"), new Syntax.Times(new Syntax.Variable("flo"), new Syntax.NumVal(10)))), new Syntax.Variable("herb")), new Syntax.Tuple((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.NumVal[]{new Syntax.NumVal(10), new Syntax.NumVal(30)})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a code block", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ 10 ; 15 * dom }", this.$outer.expr(), new Syntax.Block((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Expr[]{new Syntax.NumVal(10), new Syntax.Times(new Syntax.NumVal(15), new Syntax.Variable("dom"))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse application of a function to a code block", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("domFun10 { 10 ; test }", this.$outer.expr(), new Syntax.Apply(new Syntax.Variable("domFun10"), new Syntax.Block((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Expr[]{new Syntax.NumVal(10), new Syntax.Variable("test")})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse if ... else if ... else ... expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("\nif (inp == 20)\n    test * 10 + 5\nelse if (inp <= 40)\n    (test + 5) * hello\nelse if (inp >= 200)\n    test % 4\nelse\n    10\n        ", this.$outer.expr(), new Syntax.If(new Syntax.Equal(new Syntax.Variable("inp"), new Syntax.NumVal(20)), new Syntax.Plus(new Syntax.Times(new Syntax.Variable("test"), new Syntax.NumVal(10)), new Syntax.NumVal(5)), new Syntax.If(new Syntax.LessEq(new Syntax.Variable("inp"), new Syntax.NumVal(40)), new Syntax.Times(new Syntax.Plus(new Syntax.Variable("test"), new Syntax.NumVal(5)), new Syntax.Variable("hello")), new Syntax.If(new Syntax.GreaterEq(new Syntax.Variable("inp"), new Syntax.NumVal(200)), new Syntax.Remainder(new Syntax.Variable("test"), new Syntax.NumVal(4)), new Syntax.NumVal(10)))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a while expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("\n{\n    i := 0;\n    while (i <= 20)\n        i := i + 1\n}\n        ", this.$outer.expr(), new Syntax.Block((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Expr[]{new Syntax.Assign(new Syntax.Variable("i"), new Syntax.NumVal(0)), new Syntax.While(new Syntax.LessEq(new Syntax.Variable("i"), new Syntax.NumVal(20)), new Syntax.Assign(new Syntax.Variable("i"), new Syntax.Plus(new Syntax.Variable("i"), new Syntax.NumVal(1))))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a callcc expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("10 + callcc dom", this.$outer.expr(), new Syntax.Plus(new Syntax.NumVal(10), new Syntax.CallCC(new Syntax.Variable("dom"))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse throw...to expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("10 + throw v to c * 20", this.$outer.expr(), new Syntax.Plus(new Syntax.NumVal(10), new Syntax.Times(new Syntax.ThrowTo(new Syntax.Variable("v"), new Syntax.Variable("c")), new Syntax.NumVal(20))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse some other builtins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ r := mkref 100; 10 + val r * 20; write dom }", this.$outer.expr(), new Syntax.Block((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Expr[]{new Syntax.Assign(new Syntax.Variable("r"), new Syntax.MkRef(new Syntax.NumVal(100))), new Syntax.Plus(new Syntax.NumVal(10), new Syntax.Times(new Syntax.Val(new Syntax.Variable("r")), new Syntax.NumVal(20))), new Syntax.Apply(new Syntax.Variable("write"), new Syntax.Variable("dom"))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a lambda expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("fun(x) { write 10; return (x+1) }", this.$outer.expr(), new Syntax.Lambda(new Syntax.Variable("x"), new Syntax.Block((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Expr[]{new Syntax.Apply(new Syntax.Variable("write"), new Syntax.NumVal(10)), new Syntax.Return(new Syntax.Plus(new Syntax.Variable("x"), new Syntax.NumVal(1)))})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a simple correct let expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("let a = 1 and b = 2 in a * b", this.$outer.expr(), new Syntax.Let((List<Syntax.Binding>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Binding[]{new Syntax.Binding(new Syntax.Variable("a"), new Syntax.NumVal(1)), new Syntax.Binding(new Syntax.Variable("b"), new Syntax.NumVal(2))})), new Syntax.Times(new Syntax.Variable("a"), new Syntax.Variable("b"))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a correct letrec expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("\nletrec  plusone = fun(n) { n + 1 }\nand     factorial = fun(n) { if (n == 0) 1 else n * factorial (n-1) }\nin      factorial(plusone 5)\n        ", this.$outer.expr(), new Syntax.LetRec((List<Syntax.Binding>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Binding[]{new Syntax.Binding(new Syntax.Variable("plusone"), new Syntax.Lambda(new Syntax.Variable("n"), new Syntax.Block((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Plus[]{new Syntax.Plus(new Syntax.Variable("n"), new Syntax.NumVal(1))}))))), new Syntax.Binding(new Syntax.Variable("factorial"), new Syntax.Lambda(new Syntax.Variable("n"), new Syntax.Block((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.If[]{new Syntax.If(new Syntax.Equal(new Syntax.Variable("n"), new Syntax.NumVal(0)), new Syntax.NumVal(1), new Syntax.Times(new Syntax.Variable("n"), new Syntax.Apply(new Syntax.Variable("factorial"), new Syntax.Minus(new Syntax.Variable("n"), new Syntax.NumVal(1)))))})))))})), new Syntax.Apply(new Syntax.Variable("factorial"), new Syntax.Apply(new Syntax.Variable("plusone"), new Syntax.NumVal(5)))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("attempted parse of a letrec with a binding whose rhs is not a lambda clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("letrec a = fun(n) n + 1 and b = 22 in (a b)", this.$outer.expr(), 1, 33, "keyword expected", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse an expression containing a string literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ write \"hello\\n\"; write \"there!\\n\" }", this.$outer.expr(), new Syntax.Block((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Apply[]{new Syntax.Apply(new Syntax.Variable("write"), new Syntax.StringVal("hello\\n")), new Syntax.Apply(new Syntax.Variable("write"), new Syntax.StringVal("there!\\n"))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check that the expression parser correctly handles comments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("\n/* put */ fun /* a */ (/*comment*/x/*wherever*/)/* you */ { /* like */ write\n/* and */ 10 /* everything */; /* should */ return /* still */(/*parse*/x\n/*just   */+/* perfectly */1/*dontcha*/)/* know */ } /* old bean */\n        ", this.$outer.expr(), new Syntax.Lambda(new Syntax.Variable("x"), new Syntax.Block((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Expr[]{new Syntax.Apply(new Syntax.Variable("write"), new Syntax.NumVal(10)), new Syntax.Return(new Syntax.Plus(new Syntax.Variable("x"), new Syntax.NumVal(1)))})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse a simple, but complete, program", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("\n        /*\n         * Title:       Fibonacci fun\n         * Description: A very simple imperative Fibonacci function with driver.\n         * Copyright:   (C) 2010-2012 Dominic Verity, Macquarie University\n         */\n\n        // declare preloaded primitives\n        primitives write, read, fields, type;\n\n        // Imperative fibonacci function\n        letrec fib = fun(n)\n            let r1 = mkref 0\n            and r2 = mkref 1\n            and r3 = mkref (-1)\n            in  letrec f = fun(m)\n                    if (m == 0)\n                        val r1\n                    else {\n                        r3 := val r1 + val r2;\n                        r1 := val r2;\n                        r2 := val r3;\n                        f (m-1) }\n                in f n;\n\n        // Execute an example and print the result.\n        {\n            write (fib 200);\n            write \"\\n\"\n        }\n", this.$outer.start(), new Syntax.IswimProg((List<Syntax.Stmt>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Stmt[]{new Syntax.Primitives((List<Syntax.Variable>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Variable[]{new Syntax.Variable("write"), new Syntax.Variable("read"), new Syntax.Variable("fields"), new Syntax.Variable("type")}))), new Syntax.LetRecStmt((List<Syntax.Binding>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Binding[]{new Syntax.Binding(new Syntax.Variable("fib"), new Syntax.Lambda(new Syntax.Variable("n"), new Syntax.Let((List<Syntax.Binding>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Binding[]{new Syntax.Binding(new Syntax.Variable("r1"), new Syntax.MkRef(new Syntax.NumVal(0))), new Syntax.Binding(new Syntax.Variable("r2"), new Syntax.MkRef(new Syntax.NumVal(1))), new Syntax.Binding(new Syntax.Variable("r3"), new Syntax.MkRef(new Syntax.Negate(new Syntax.NumVal(1))))})), new Syntax.LetRec((List<Syntax.Binding>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Binding[]{new Syntax.Binding(new Syntax.Variable("f"), new Syntax.Lambda(new Syntax.Variable("m"), new Syntax.If(new Syntax.Equal(new Syntax.Variable("m"), new Syntax.NumVal(0)), new Syntax.Val(new Syntax.Variable("r1")), new Syntax.Block((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Expr[]{new Syntax.Assign(new Syntax.Variable("r3"), new Syntax.Plus(new Syntax.Val(new Syntax.Variable("r1")), new Syntax.Val(new Syntax.Variable("r2")))), new Syntax.Assign(new Syntax.Variable("r1"), new Syntax.Val(new Syntax.Variable("r2"))), new Syntax.Assign(new Syntax.Variable("r2"), new Syntax.Val(new Syntax.Variable("r3"))), new Syntax.Apply(new Syntax.Variable("f"), new Syntax.Minus(new Syntax.Variable("m"), new Syntax.NumVal(1)))}))))))})), new Syntax.Apply(new Syntax.Variable("f"), new Syntax.Variable("n"))))))}))), new Syntax.ExprStmt(new Syntax.Block((List<Syntax.Expr>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Syntax.Apply[]{new Syntax.Apply(new Syntax.Variable("write"), new Syntax.Apply(new Syntax.Variable("fib"), new Syntax.NumVal(200))), new Syntax.Apply(new Syntax.Variable("write"), new Syntax.StringVal("\\n"))}))))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check that the parser can handle very long comments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParserTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String input = "\n/**\n * Title:     An implementation of try...catch exception\n *            handling using continuations\n * Author:    Dominic Verity\n * Copyright: Macquarie University (C) 2007-2011\n *\n * A try..catch block is implemented using 2 continuations:\n *        The first marks the exit point for normal exits.\n *        The second marks the entry point to the exception handler code.\n *\n * We might picture this arrangement as:\n *\n *  --- normal exit cont    --- error handler cont\n *   |                       |\n *   |                       |                    code in the try block\n *   |                       |\n *   |                       |         at the end of the try block throw to normal\n *   |                       V         exit continuation to avoid exectuing the exception\n *   |                      ___        handler after successful execution of try code.\n *   |\n *   |\n *   |                                         code of corresponding\n *   |                                         exception handler.\n *   V\n *  ---\n *\n * The SECD machine provides a primitive, called 'raise', which allows us\n * to raise an exception. This can be brought into scope in user code using the 'primitives'\n * key word. The same mechanism also allows us to bring the names of the exception\n * values associated with the various machine exceptions into scope. Having done that we can\n * write code to catch and handle different kinds of machine error.\n *\n * The SECD 'raise' primitive assumes that when it is called a variable named 'exceptionHandler'\n * will be in scope and that it will be bound to a continuation. All it actually does is to\n * throw the exception value given as its argument to this continuation. The default provided\n * by the machine on startup is that 'exceptionHandler' is bound to a continuation marking the\n * exit point of the running program.\n *\n * We can replace this simple \"exit on error\" mechanism with something a little more useful\n * simply by re-binding 'exceptionHandler' to a more useful continuation. In the code given here\n * we organise things so that 'exceptionHandler' is bound always bound to the continuation\n * which marks the entry point to the catch block of the closest enclosing try...catch construct.\n */\n";
                this.$outer.assertParseError(input, this.$outer.start(), 45, 1, "operator \"{\" expected", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

