/*
 * Decompiled with CFR 0.152.
 */
package org.kiama.example.iswim.tests;

import org.junit.runner.RunWith;
import org.kiama.attribution.Attributable;
import org.kiama.attribution.Attribution$;
import org.kiama.example.iswim.compiler.Parser;
import org.kiama.example.iswim.compiler.Parser$Pos$;
import org.kiama.example.iswim.compiler.Parser$class;
import org.kiama.example.iswim.compiler.SemanticAnalysis;
import org.kiama.example.iswim.compiler.SemanticAnalysis$class;
import org.kiama.example.iswim.compiler.Syntax;
import org.kiama.util.Messaging$;
import org.kiama.util.Tests;
import org.kiama.util.Tests$FocusTest$;
import org.kiama.util.Tests$class;
import org.scalatest.Assertions;
import org.scalatest.Engine;
import org.scalatest.FunSuite;
import org.scalatest.Suite;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scala.util.parsing.combinator.JavaTokenParsers;
import scala.util.parsing.combinator.PackratParsers;
import scala.util.parsing.combinator.PackratParsers$Head$;
import scala.util.parsing.combinator.PackratParsers$LR$;
import scala.util.parsing.combinator.PackratParsers$MemoEntry$;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.combinator.Parsers$$tilde$;
import scala.util.parsing.combinator.Parsers$Error$;
import scala.util.parsing.combinator.Parsers$Failure$;
import scala.util.parsing.combinator.Parsers$NoSuccess$;
import scala.util.parsing.combinator.Parsers$Success$;
import scala.util.parsing.combinator.RegexParsers;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001\u001b\t)2+Z7b]RL7-\u00118bYf\u001c\u0018n\u001d+fgR\u001c(BA\u0002\u0005\u0003\u0015!Xm\u001d;t\u0015\t)a!A\u0003jg^LWN\u0003\u0002\b\u0011\u00059Q\r_1na2,'BA\u0005\u000b\u0003\u0015Y\u0017.Y7b\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0002\u0001\u000f-q\u0011S\u0005\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t9\"$D\u0001\u0019\u0015\tI\u0002\"\u0001\u0003vi&d\u0017BA\u000e\u0019\u0005\u0015!Vm\u001d;t!\ti\u0002%D\u0001\u001f\u0015\tyB!\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0013\t\tcD\u0001\tTK6\fg\u000e^5d\u0003:\fG._:jgB\u0011QdI\u0005\u0003Iy\u0011a\u0001U1sg\u0016\u0014\bC\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#aC*dC2\fwJ\u00196fGRDQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtD#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\u0002)\t\u0001\t\u0014H\u000f\t\u0003e]j\u0011a\r\u0006\u0003iU\naA];o]\u0016\u0014(B\u0001\u001c\u000b\u0003\u0015QWO\\5u\u0013\tA4GA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0003m\u0002\"\u0001\u0010!\u000e\u0003uR!A\u000e \u000b\u0005}R\u0011!C:dC2\fG/Z:u\u0013\t\tUHA\u0006K+:LGOU;o]\u0016\u0014\b")
public class SemanticAnalysisTests
implements Tests,
SemanticAnalysis,
Parser,
ScalaObject {
    private final HashSet<String> reserved;
    private final Regex identRegex;
    private final Regex intRegex;
    private final Parsers.Parser<Syntax.Variable> variable;
    private final Parsers.Parser<Syntax.Expr> liter;
    private final PackratParsers.PackratParser<Syntax.IswimProg> start;
    private final PackratParsers.PackratParser<Syntax.Expr> expr;
    private final PackratParsers.PackratParser<Syntax.Expr> parenexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> factor;
    private final PackratParsers.PackratParser<Syntax.Expr> applic;
    private final PackratParsers.PackratParser<Syntax.Expr> term1;
    private final PackratParsers.PackratParser<Syntax.Expr> term2;
    private final PackratParsers.PackratParser<Syntax.Expr> term3;
    private final PackratParsers.PackratParser<Syntax.Expr> term4;
    private final PackratParsers.PackratParser<Syntax.Expr> emptyexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> tupleexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> matchexpr;
    private final PackratParsers.PackratParser<Tuple2<Parser.Pos, List<Syntax.Variable>>> pattern;
    private final PackratParsers.PackratParser<Syntax.MatchClause> matchclause;
    private final PackratParsers.PackratParser<Syntax.Expr> blockexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> lambdaexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> returnexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> letexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> letrecexpr;
    private final PackratParsers.PackratParser<Syntax.Stmt> letstmt;
    private final PackratParsers.PackratParser<Syntax.Stmt> letrecstmt;
    private final PackratParsers.PackratParser<Syntax.Stmt> exprstmt;
    private final PackratParsers.PackratParser<Syntax.Stmt> importstmt;
    private final PackratParsers.PackratParser<Syntax.Expr> ifelseexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> whileexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> callccexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> throwtoexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> valexpr;
    private final PackratParsers.PackratParser<Syntax.Expr> mkrefexpr;
    private final PackratParsers.PackratParser<Syntax.Stmt> primstmt;
    private final Regex whiteSpace;
    private Parsers.NoSuccess lastNoSuccess;
    private final Function1<Syntax.Iswim, Map<Syntax.Variable, Syntax.Iswim>> envir;
    private final Function1<Syntax.Iswim, Map<Syntax.Variable, Syntax.Iswim>> envirOut;
    private final Function1<Syntax.MatchClause, Object> unreachable;
    private final Function1<Syntax.Iswim, Object> isSemanticallyCorrect;
    private final Engine org$scalatest$FunSuite$$engine;
    public volatile int bitmap$0;
    private volatile Parser$Pos$ Pos$module;
    public volatile int bitmap$1;
    private volatile PackratParsers$MemoEntry$ scala$util$parsing$combinator$PackratParsers$$MemoEntry$module;
    private volatile PackratParsers$LR$ scala$util$parsing$combinator$PackratParsers$$LR$module;
    private volatile PackratParsers$Head$ scala$util$parsing$combinator$PackratParsers$$Head$module;
    private volatile Parsers$Success$ Success$module;
    private volatile Parsers$NoSuccess$ NoSuccess$module;
    private volatile Parsers$Failure$ Failure$module;
    private volatile Parsers$Error$ Error$module;
    private volatile Parsers$$tilde$ $tilde$module;
    private volatile Tests$FocusTest$ FocusTest$module;

    public SemanticAnalysisTests() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        FunSuite.class.$init$((FunSuite)this);
        Tests$class.$init$(this);
        SemanticAnalysis$class.$init$(this);
        Parsers.class.$init$((Parsers)this);
        RegexParsers.class.$init$((RegexParsers)this);
        JavaTokenParsers.class.$init$((JavaTokenParsers)this);
        PackratParsers.class.$init$((PackratParsers)this);
        Parser$class.$init$(this);
        this.test("simple test of use of a correctly bound variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final SemanticAnalysisTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "let x = 1 in x + x");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                Messaging$.MODULE$.resetmessages();
                boolean result = BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)result)).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Messaging$.MODULE$.messagecount())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple test of a recursive binding", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final SemanticAnalysisTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "letrec f = fun(x){ g x } and g = fun(y){ f y } in f 1");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                Messaging$.MODULE$.resetmessages();
                boolean result = BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)result)).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Messaging$.MODULE$.messagecount())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("test of top level bindings in which all variables correctly bound", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final SemanticAnalysisTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.start(), " let x = 1 and y = 60;\n\n    let f = fun(x) { x + y };\n\n    letrec g = fun(z) { if (z <= 0) 1 else x * g(z-1) };\n\n    let main = fun(w) {\n        f(20) + g(y)\n    }\n");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                Messaging$.MODULE$.resetmessages();
                boolean result = BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)result)).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Messaging$.MODULE$.messagecount())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple test of use of an unbound variable in body of let", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final SemanticAnalysisTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "let x = 1 in x + y");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                Messaging$.MODULE$.resetmessages();
                boolean result = BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)result)).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Messaging$.MODULE$.messagecount())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assertMessage(0, 1, 18, "unbound variable 'y'");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("use of an unbound variable in an expression being bound to a variable in a let", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final SemanticAnalysisTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "let x = y and z = x in z + x");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                Messaging$.MODULE$.resetmessages();
                boolean result = BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)result)).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Messaging$.MODULE$.messagecount())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assertMessage(0, 1, 9, "unbound variable 'y'");
                this.$outer.assertMessage(1, 1, 19, "unbound variable 'x'");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("test of top level bindings in which some variables incorrectly bound", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final SemanticAnalysisTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.start(), " let x = 1 and y = 60;\n\n    let f = fun(x) { x + w };\n\n    let w = (let z = (let y = w in y + t) in (let m = t * z in (m + z1, z)));\n\n    letrec g = fun(z) { if (z <= 0) 1 else x * g(z-1) * (k w) }\n    and k = fun(z) { g(1) + m(2) };\n\n    let main = fun(w) {\n        f(20) + g(y)\n    }\n");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                Messaging$.MODULE$.resetmessages();
                boolean result = BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)result)).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Messaging$.MODULE$.messagecount())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)6)));
                this.$outer.assertMessage(0, 3, 26, "unbound variable 'w'");
                this.$outer.assertMessage(1, 5, 31, "unbound variable 'w'");
                this.$outer.assertMessage(2, 5, 40, "unbound variable 't'");
                this.$outer.assertMessage(3, 5, 55, "unbound variable 't'");
                this.$outer.assertMessage(4, 5, 69, "unbound variable 'z1'");
                this.$outer.assertMessage(5, 8, 29, "unbound variable 'm'");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("correct use of bound variables in a match expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final SemanticAnalysisTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "\n    (1,2) match {\n        ()      -> 34;\n        (y,z)   -> y + z;\n        x       -> x * x\n    }\n");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                boolean result = BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)result)).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("unbound variables in a match expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final SemanticAnalysisTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "\n    (1,2) match {\n        ()      -> y;\n        (y,z)   -> y + w;\n        x       -> x * z\n    }\n");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                Messaging$.MODULE$.resetmessages();
                boolean result = BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)result)).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Messaging$.MODULE$.messagecount())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assertMessage(0, 3, 20, "unbound variable 'y'");
                this.$outer.assertMessage(1, 4, 24, "unbound variable 'w'");
                this.$outer.assertMessage(2, 5, 24, "unbound variable 'z'");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("unreachable clauses in a match expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final SemanticAnalysisTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Parsers.ParseResult prog = this.$outer.parseAll((Parsers.Parser)this.$outer.expr(), "\n    (1,2) match {\n        ()      -> 1;\n        w       -> w + 1;\n        (y,z)   -> y + z;\n        x       -> x / 10\n    }\n");
                this.$outer.assert(prog.successful());
                Attribution$.MODULE$.initTree((Attributable)prog.get());
                Messaging$.MODULE$.resetmessages();
                boolean result = BoxesRunTime.unboxToBoolean((Object)((Attributable)prog.get()).$minus$greater(this.$outer.isSemanticallyCorrect()));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)result)).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Messaging$.MODULE$.messagecount())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assertMessage(0, 5, 9, "unreachable match clause");
                this.$outer.assertMessage(1, 6, 9, "unreachable match clause");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

