/*
 * Decompiled with CFR 0.152.
 */
package org.kiama.example.json;

import org.junit.runner.RunWith;
import org.kiama.example.json.JSONTree;
import org.kiama.example.json.SyntaxAnalysis;
import org.kiama.example.json.SyntaxAnalysis$class;
import org.kiama.util.ParserUtilities;
import org.kiama.util.RegexParserTests;
import org.kiama.util.RegexParserTests$class;
import org.kiama.util.Tests$FocusTest$;
import org.kiama.util.Tests$class;
import org.scalatest.Assertions;
import org.scalatest.Engine;
import org.scalatest.FunSuite;
import org.scalatest.Suite;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;
import scala.util.parsing.combinator.PackratParsers;
import scala.util.parsing.combinator.PackratParsers$Head$;
import scala.util.parsing.combinator.PackratParsers$LR$;
import scala.util.parsing.combinator.PackratParsers$MemoEntry$;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.combinator.Parsers$$tilde$;
import scala.util.parsing.combinator.Parsers$Error$;
import scala.util.parsing.combinator.Parsers$Failure$;
import scala.util.parsing.combinator.Parsers$NoSuccess$;
import scala.util.parsing.combinator.Parsers$Success$;
import scala.util.parsing.combinator.RegexParsers;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u0017\ta\u0001+\u0019:tS:<G+Z:ug*\u00111\u0001B\u0001\u0005UN|gN\u0003\u0002\u0006\r\u00059Q\r_1na2,'BA\u0004\t\u0003\u0015Y\u0017.Y7b\u0015\u0005I\u0011aA8sO\u000e\u00011#\u0002\u0001\r)iq\u0002CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011\u0001B;uS2L!!\u0007\f\u0003!I+w-\u001a=QCJ\u001cXM\u001d+fgR\u001c\bCA\u000e\u001d\u001b\u0005\u0011\u0011BA\u000f\u0003\u00059\u0019\u0016P\u001c;bq\u0006s\u0017\r\\=tSN\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u00121bU2bY\u0006|%M[3di\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"\u0012a\n\t\u00037\u0001AC\u0001A\u00152eA\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0007eVtg.\u001a:\u000b\u00059B\u0011!\u00026v]&$\u0018B\u0001\u0019,\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013a\r\t\u0003iaj\u0011!\u000e\u0006\u0003]YR!a\u000e\u0005\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u001d6\u0005-QUK\\5u%Vtg.\u001a:")
public class ParsingTests
implements RegexParserTests,
SyntaxAnalysis,
ScalaObject {
    private final PackratParsers.PackratParser<JSONTree.JValue> parser;
    private final PackratParsers.PackratParser<JSONTree.JValue> jvalue;
    private final Parsers.Parser<JSONTree.JObject> jobject;
    private final Parsers.Parser<Tuple2<JSONTree.JName, JSONTree.JValue>> jpair;
    private final Parsers.Parser<JSONTree.JArray> jarray;
    private final Parsers.Parser<JSONTree.JString> jstring;
    private final Parsers.Parser<String> string;
    private final Parsers.Parser<JSONTree.JNumber> jnumber;
    private final Parsers.Parser<JSONTree.JTrue> jtrue;
    private final Parsers.Parser<JSONTree.JFalse> jfalse;
    private final Parsers.Parser<JSONTree.JNull> jnull;
    private final PackratParsers.PackratParser<Object> constrainedInt;
    private final Regex whiteSpace;
    private Parsers.NoSuccess lastNoSuccess;
    private final Engine org$scalatest$FunSuite$$engine;
    public volatile int bitmap$0;
    private volatile PackratParsers$MemoEntry$ scala$util$parsing$combinator$PackratParsers$$MemoEntry$module;
    private volatile PackratParsers$LR$ scala$util$parsing$combinator$PackratParsers$$LR$module;
    private volatile PackratParsers$Head$ scala$util$parsing$combinator$PackratParsers$$Head$module;
    private volatile Parsers$Success$ Success$module;
    private volatile Parsers$NoSuccess$ NoSuccess$module;
    private volatile Parsers$Failure$ Failure$module;
    private volatile Parsers$Error$ Error$module;
    private volatile Parsers$$tilde$ $tilde$module;
    private volatile Tests$FocusTest$ FocusTest$module;

    public ParsingTests() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        FunSuite.class.$init$((FunSuite)this);
        Tests$class.$init$(this);
        RegexParserTests$class.$init$(this);
        Parsers.class.$init$((Parsers)this);
        RegexParsers.class.$init$((RegexParsers)this);
        PackratParsers.class.$init$((PackratParsers)this);
        ParserUtilities.class.$init$((ParserUtilities)this);
        SyntaxAnalysis$class.$init$(this);
        this.test("parsing true works", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("true", this.$outer.jtrue(), new JSONTree.JTrue());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parsing false works", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("false", this.$outer.jfalse(), new JSONTree.JFalse());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parsing null works", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("null", this.$outer.jnull(), new JSONTree.JNull());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parsing a single digit integer works", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("0", this.$outer.jnumber(), new JSONTree.JNumber(0.0));
                this.$outer.assertParseOk("4", this.$outer.jnumber(), new JSONTree.JNumber(4.0));
                this.$outer.assertParseOk("-7", this.$outer.jnumber(), new JSONTree.JNumber(-7.0));
                this.$outer.assertParseOk("-9", this.$outer.jnumber(), new JSONTree.JNumber(-9.0));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parsing a non-trivial integer works", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("78", this.$outer.jnumber(), new JSONTree.JNumber(78.0));
                this.$outer.assertParseOk("-123", this.$outer.jnumber(), new JSONTree.JNumber(-123.0));
                this.$outer.assertParseOk("793223", this.$outer.jnumber(), new JSONTree.JNumber(793223.0));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parsing non-numbers as numbers fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("x", this.$outer.jnumber(), 1, 1, "string matching regex `-?(0|[1-9]\\d*)(\\.\\d+)?([eE][-+]?\\d+)?' expected but `x' found", this.$outer.assertParseError$default$6());
                this.$outer.assertParseError("Eugene", this.$outer.jnumber(), 1, 1, "string matching regex `-?(0|[1-9]\\d*)(\\.\\d+)?([eE][-+]?\\d+)?' expected but `E' found", this.$outer.assertParseError$default$6());
                this.$outer.assertParseError("(", this.$outer.jnumber(), 1, 1, "string matching regex `-?(0|[1-9]\\d*)(\\.\\d+)?([eE][-+]?\\d+)?' expected but `(' found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parsing a floating point number without exponent works", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("0.9", this.$outer.jnumber(), new JSONTree.JNumber(0.9));
                this.$outer.assertParseOk("-1.4", this.$outer.jnumber(), new JSONTree.JNumber(-1.4));
                this.$outer.assertParseOk("42.09", this.$outer.jnumber(), new JSONTree.JNumber(42.09));
                this.$outer.assertParseOk("1234.5678", this.$outer.jnumber(), new JSONTree.JNumber(1234.5678));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parsing a floating point number without decimal part but with exponent works", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("0e5", this.$outer.jnumber(), new JSONTree.JNumber(0.0));
                this.$outer.assertParseOk("-4e+3", this.$outer.jnumber(), new JSONTree.JNumber(-4000.0));
                this.$outer.assertParseOk("73e-6", this.$outer.jnumber(), new JSONTree.JNumber(7.3E-5));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parsing a floating point number with decimal part and exponent works", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("8.5e2", this.$outer.jnumber(), new JSONTree.JNumber(850.0));
                this.$outer.assertParseOk("-0.7e-5", this.$outer.jnumber(), new JSONTree.JNumber(-7.0E-6));
                this.$outer.assertParseOk("96.0001e+13", this.$outer.jnumber(), new JSONTree.JNumber(9.60001E14));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parsing a number with leading zeros doesn't work", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseError("00", this.$outer.jnumber(), 1, 2, "string matching regex `\\z' expected but `0' found", this.$outer.assertParseError$default$6());
                this.$outer.assertParseError("000", this.$outer.jnumber(), 1, 2, "string matching regex `\\z' expected but `0' found", this.$outer.assertParseError$default$6());
                this.$outer.assertParseError("01", this.$outer.jnumber(), 1, 2, "string matching regex `\\z' expected but `1' found", this.$outer.assertParseError$default$6());
                this.$outer.assertParseError("000.1", this.$outer.jnumber(), 1, 2, "string matching regex `\\z' expected but `0' found", this.$outer.assertParseError$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("empty string parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("\"\"", this.$outer.jstring(), new JSONTree.JString(""));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple string parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("\"hello there\"", this.$outer.jstring(), new JSONTree.JString("hello there"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("empty array parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("[]", this.$outer.jarray(), new JSONTree.JArray((Vector<JSONTree.JValue>)package$.MODULE$.Vector().empty()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single element array parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("[ 1 ]", this.$outer.jarray(), new JSONTree.JArray((Vector<JSONTree.JValue>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JSONTree.JNumber[]{new JSONTree.JNumber(1.0)})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple element array parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("[ \"a\", null, true ]", this.$outer.jarray(), new JSONTree.JArray((Vector<JSONTree.JValue>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JSONTree.JValue[]{new JSONTree.JString("a"), new JSONTree.JNull(), new JSONTree.JTrue()})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("nested array parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("[ false, [ 10, 20 ], 30 ]", this.$outer.jarray(), new JSONTree.JArray((Vector<JSONTree.JValue>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JSONTree.JValue[]{new JSONTree.JFalse(), new JSONTree.JArray((Vector<JSONTree.JValue>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JSONTree.JNumber[]{new JSONTree.JNumber(10.0), new JSONTree.JNumber(20.0)})))), new JSONTree.JNumber(30.0)})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("object inside array parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("[ false, { \"f\" : 10, \"g\" : 20 }, 30 ]", this.$outer.jarray(), new JSONTree.JArray((Vector<JSONTree.JValue>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JSONTree.JValue[]{new JSONTree.JFalse(), new JSONTree.JObject((List<Tuple2<JSONTree.JName, JSONTree.JValue>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("f")).$minus$greater((Object)new JSONTree.JNumber(10.0)), Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("g")).$minus$greater((Object)new JSONTree.JNumber(20.0))}))), new JSONTree.JNumber(30.0)})))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("empty object parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{}", this.$outer.jobject(), new JSONTree.JObject((List<Tuple2<JSONTree.JName, JSONTree.JValue>>)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single pair object parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ \"one\" : 1 }", this.$outer.jobject(), new JSONTree.JObject((List<Tuple2<JSONTree.JName, JSONTree.JValue>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("one")).$minus$greater((Object)new JSONTree.JNumber(1.0))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple pair object parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ \"a\" : \"a\", \"b\" : null, \"c\" : true }", this.$outer.jobject(), new JSONTree.JObject((List<Tuple2<JSONTree.JName, JSONTree.JValue>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("a")).$minus$greater((Object)new JSONTree.JString("a")), Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("b")).$minus$greater((Object)new JSONTree.JNull()), Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("c")).$minus$greater((Object)new JSONTree.JTrue())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("nested object parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ \"e\" : false, \"f\" : { \"g\" : 10, \"h\" : 20 }, \"i\" : 30 }", this.$outer.jobject(), new JSONTree.JObject((List<Tuple2<JSONTree.JName, JSONTree.JValue>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("e")).$minus$greater((Object)new JSONTree.JFalse()), Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("f")).$minus$greater((Object)new JSONTree.JObject((List<Tuple2<JSONTree.JName, JSONTree.JValue>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("g")).$minus$greater((Object)new JSONTree.JNumber(10.0)), Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("h")).$minus$greater((Object)new JSONTree.JNumber(20.0))})))), Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("i")).$minus$greater((Object)new JSONTree.JNumber(30.0))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("array inside object parses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final ParsingTests $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertParseOk("{ \"e\" : false, \"f\" : [ 10, 20 ], \"i\" : 30 }", this.$outer.jobject(), new JSONTree.JObject((List<Tuple2<JSONTree.JName, JSONTree.JValue>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("e")).$minus$greater((Object)new JSONTree.JFalse()), Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("f")).$minus$greater((Object)new JSONTree.JArray((Vector<JSONTree.JValue>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JSONTree.JNumber[]{new JSONTree.JNumber(10.0), new JSONTree.JNumber(20.0)}))))), Predef$.MODULE$.any2ArrowAssoc((Object)new JSONTree.JName("i")).$minus$greater((Object)new JSONTree.JNumber(30.0))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

